<?php 

ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

header("Access-Control-Allow-Origin: https://estrovive.com");
header("Access-Control-Allow-Methods: POST, GET, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type, Authorization");


include_once('config.php');
require('vendor/autoload.php');
use Shopify\PuplicApp;
use rdx\graphqlquery\Query;

  
  function checkCustomers($email) {
      global $client;
      
   $query=   'query {
  customers(first: 2,query:"email:'.$email.'") { 
    edges {
      node {
        id
        email
       
      }
    }
  }
}
';

  $response = $client->callGraphql($query);
  if(count($response['data']['customers']['edges'])>=1) {
  
  return $response['data']['customers']['edges'][0]['node'];
  }else {
      return 'no';
  }
  }
  
  

$client = new Shopify\PublicApp($SHOPIFY_SHOP_DOMAIN_EST, $SHOPIFY_API_KEY_EST, $SHOPIFY_API_SECRET_EST, $api_params);
  $client->setAccessToken($SHOPIFY_TOKEN_EST);
  
  if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Get the raw POST data
    $postData = file_get_contents('php://input');

    // Decode the JSON data
    $requestData = json_decode($postData, true);


    // Access the individual fields
    $firstName = $requestData['firstName'];
    $email = $requestData['email'];

    
    $checkCustomer =  checkCustomers($email) ;
    
                $dateTime = new DateTime();
             

                $dateTime->setTimezone(new DateTimeZone('UTC'));
                
                 $formattedDate = $dateTime->format('Y-m-d\TH:i:s\Z');

  if($checkCustomer=='no') {
      
          $mutation = 'mutation {';

                  $mutation .=  '  customer_1: customerCreate(input: {
      email: "'.$email.'",
      firstName:  "'.$firstName.'",
    ';
        
         if($firstName!='') {
      $mutation .=  ' emailMarketingConsent: {
      consentUpdatedAt:  "'.$formattedDate.'",
      marketingOptInLevel: SINGLE_OPT_IN,
      marketingState: SUBSCRIBED
    }';
         }

    
     $mutation .=  '  
    }) {
    customer {
      id
      email
    }
    userErrors {
      field
      message
    }
  }
  
  ';
       $mutation .=  '  }';
      
           $client->callGraphql($mutation);
               
  } 
  else {
             $mutation = 'mutation {';


                  $mutation .=  ' customerEmailMarketingConsentUpdate(input: {
                  customerId: "'.$checkCustomer['id'].'",
    
    ';
        
         if($email!='') {
      $mutation .=  ' emailMarketingConsent: {
      consentUpdatedAt:  "'.$formattedDate.'",
      marketingOptInLevel: SINGLE_OPT_IN,
      marketingState: SUBSCRIBED
    }';
         }

    
     $mutation .=  '  
    }) {
    customer {
      id
      email
    }
    userErrors {
      field
      message
    }
  }
  
  ';
       $mutation .=  '  }';

       
           $client->callGraphql($mutation);   
      
  }
        

    // Send a response
    $response = ['status' => 'success', 'message' => 'Subscribed Successfully'];
    echo json_encode($response);
    die;
} else {
    // If the request method is not POST, return an error response
    http_response_code(405);
    echo json_encode(['error' => 'Method Not Allowed']);
    die;
}
  


  

    
    
 
  
  die;