<?php 
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
include_once('config.php');
require('vendor/autoload.php');
use Shopify\PuplicApp;
use rdx\graphqlquery\Query;

use Shopify\Rest\Admin2023_07\FulfillmentRequest;
use Shopify\Utils;

$client = new Shopify\PublicApp($SHOPIFY_SHOP_DOMAIN, $SHOPIFY_API_KEY, $SHOPIFY_API_SECRET, $api_params);
  $client->setAccessToken($SHOPIFY_TOKEN);
echo '<pre>';
function fulfillRequest($FulfillmentOrderId) {
global $client;
    $query ='mutation {
        fulfillmentOrderSubmitFulfillmentRequest(id: "'.$FulfillmentOrderId.'",shippingMethod:"", notifyCustomer:false,message: "Fulfillment request to MCF.") {
            originalFulfillmentOrder {
                id
                status
              }


              userErrors {
                field
                message
              }
            }
          }';
        
  $order = $client->callGraphql($query);
  print_r($order);
}
function fullfillOrder($FulfillmentOrderId)
{
  global $client;

  $fullfillorderstatus = '          mutation {
                fulfillmentCreateV2(
                    fulfillment: {
                        lineItemsByFulfillmentOrder:{
                            fulfillmentOrderId:"' . $FulfillmentOrderId . '"
                        }
                     
                    }
                ) {
                    fulfillment {
                        id
                    }
                }
            }
     
     ';

  $order = $client->callGraphql($fullfillorderstatus);
}
function getShopifyFulFillmentId($ordernum)
{
  global $client;
  $oq = 'query {
      orders(first:1, query:"name:#' . $ordernum . '") {
        edges {
          node {
            id
           fulfillmentOrders(first:30) {
              edges {
                node {
                  id
                }
              }
            }
          }
        }
      }
    }';

  $order = $client->callGraphql($oq);
  if ($order['data']['orders']['edges'][0]['node']['fulfillmentOrders']['edges'][0]['node']['id'] != '') {
    return  $order['data']['orders']['edges'][0]['node']['fulfillmentOrders']['edges'][0]['node']['id'];
  }
  return false;
}

function fulfillRequestCurl($forderId) {
  global $SHOPIFY_TOKEN,$SHOPIFY_SHOP_DOMAIN;
  $curl = curl_init();
echo 'https://'.$SHOPIFY_SHOP_DOMAIN.'/admin/api/2023-07/fulfillment_orders/'.$forderId.'/fulfillment_request.json';

die;
curl_setopt_array($curl, array(
  CURLOPT_URL => 'https://'.$SHOPIFY_SHOP_DOMAIN.'/admin/api/2023-07/fulfillment_orders/'.$forderId.'/fulfillment_request.json',
  CURLOPT_RETURNTRANSFER => true,
  CURLOPT_ENCODING => '',
  CURLOPT_MAXREDIRS => 10,
  CURLOPT_TIMEOUT => 0,
  CURLOPT_FOLLOWLOCATION => true,
  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
  CURLOPT_CUSTOMREQUEST => 'POST',
  CURLOPT_HTTPHEADER => array(
    'X-Shopify-Access-Token: '.$SHOPIFY_TOKEN,
    'Content-Type: application/json'
  ),
));

$response = curl_exec($curl);
print_r($response );
curl_close($curl);
echo $response;


}
function fulfillOrdeAcceptCurl ($forderId) {
global $SHOPIFY_TOKEN,$SHOPIFY_SHOP_DOMAIN;

$curl = curl_init();

curl_setopt_array($curl, array(
  CURLOPT_URL => 'https://'.$SHOPIFY_SHOP_DOMAIN.'/admin/api/2023-07/fulfillment_orders/'.$forderId.'/fulfillment_request/accept.json',
  CURLOPT_RETURNTRANSFER => true,
  CURLOPT_ENCODING => '',
  CURLOPT_MAXREDIRS => 10,
  CURLOPT_TIMEOUT => 0,
  CURLOPT_FOLLOWLOCATION => true,
  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
  CURLOPT_CUSTOMREQUEST => 'POST',
  CURLOPT_POSTFIELDS =>'{"fulfillment_request":{"message":"We will start processing your fulfillment asap."}}',
  CURLOPT_HTTPHEADER => array(
    'X-Shopify-Access-Token: '.$SHOPIFY_TOKEN,
    'Content-Type: application/json'
  ),
));

$response = curl_exec($curl);
print_r($response );
curl_close($curl);
echo $response;

}
$orders= array();

if(isset($_GET['order']) && $_GET['order']!='') {
  $orderid = $_GET['order'];
  $query ='query {
    order(id: "gid://shopify/Order/'.$orderid.'") {
      id
      name
      tags
     displayFulfillmentStatus
      displayFinancialStatus
    }
  }';
  
$order = $client->callGraphql($query);
$orders[]['node']= ($order['data']['order']);

}else {
  $query = '  query {
    orders(first: 10, query: "fulfillment_status:unfulfilled tag:MCF") {
	   edges {
    cursor
      node {        
      id
      name
      tags
     displayFulfillmentStatus
      displayFinancialStatus

      }
    }
	}
}';

$orders = $client->callGraphql($query);

$orders = $orders['data']['orders']['edges'];
}



foreach($orders as $order) {

    if( $order['node']['displayFulfillmentStatus']=='UNFULFILLED') {
        echo $order['node']['displayFulfillmentStatus'];
    echo '<br>';

  $FulfillmentOrderId=   getShopifyFulFillmentId($order['node']['name']);

  //fulfillRequest($FulfillmentOrderId);

$FulfillmentOrderId = str_replace('gid://shopify/FulfillmentOrder/','',$FulfillmentOrderId);
  echo   $FulfillmentOrderId;
  fulfillRequestCurl($FulfillmentOrderId);
  fulfillOrdeAcceptCurl($FulfillmentOrderId);
    }

}