<?php 
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
include_once('config.php');
require('vendor/autoload.php');
use Shopify\PuplicApp;
use rdx\graphqlquery\Query;


$client = new Shopify\PublicApp($SHOPIFY_SHOP_DOMAIN, $SHOPIFY_API_KEY, $SHOPIFY_API_SECRET, $api_params);
  $client->setAccessToken($SHOPIFY_TOKEN);
  
  
  function getAllProducts($cursor = '')
{
    global $client;

    $allProducts = [];

    do {
        $query = '
        {
            products(first: 100' . ($cursor ? ', after: "' . $cursor . '"' : '') . ') {
                edges {
                    cursor
                    node {
                        id
                        title
                        description
                        createdAt
                        updatedAt
                        publishedAt
                        vendor
                        productType
                        tags
                        variants(first: 10) {
                            edges {
                                node {
                                    id
                                    title
                                    sku
                                    price
                                    inventoryQuantity
                                    weight
                                    weightUnit
                                    compareAtPrice
                                    selectedOptions {
                                        name
                                        value
                                    }
                                }
                            }
                        }
                   
                    }
                }
                pageInfo {
                    hasNextPage
                }
            }
        }';

        $products = $client->callGraphql($query);
        $rproducts = $products['data']['products']['edges'];
        $allProducts = array_merge($allProducts, $rproducts);
        
        // Check if there is a next page
        $hasNextPage = $products['data']['products']['pageInfo']['hasNextPage'];

        // Update the cursor to the last product's cursor
        if ($hasNextPage) {
            $cursor = end($rproducts)['cursor'];
        }
    } while ($hasNextPage);

    return $allProducts;
}

$products = getAllProducts();
echo '<pre>';
print_r($products);