<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ERROR | E_WARNING | E_PARSE);


$sql = "SELECT 
    op.stockCode AS ProductTitle,
    IFNULL(SUM(op.quantity), 0) AS OrderedQuantity,
    IFNULL(SUM(rp.quantity), 0) AS ReturnedQuantity,
    CASE 
        WHEN IFNULL(SUM(op.quantity), 0) = 0 THEN 0
        ELSE (IFNULL(SUM(rp.quantity), 0) / IFNULL(SUM(op.quantity), 0)) * 100 
    END AS ReturnRate
FROM 
    newsystem_orders o
LEFT JOIN 
    newsystem_orders_product op ON o.newSystemOrderID = op.newSystemOrderID
LEFT JOIN 
    newsystem_refund_orders r ON o.newSystemOrderID = r.newSystemOrderID
LEFT JOIN 
    newsystem_refund_orders_product rp ON r.newSystemOrderID = rp.newSystemOrderID AND op.stockCode = rp.stockCode
GROUP BY 
    op.stockCode
ORDER BY
    OrderedQuantity DESC;
";