<?php 
include_once('config.php');


/*
$sqlValues = "SELECT 
    segmentID,
    endDate,
    MAX(CASE WHEN stepID = 1 THEN conversionRate END) AS conversionRate_step1,
    MAX(CASE WHEN stepID = 1 THEN ctrValue END) AS ctrValue_step1,
    MAX(CASE WHEN stepID = 2 THEN conversionRate END) AS conversionRate_step2,
    MAX(CASE WHEN stepID = 2 THEN ctrValue END) AS ctrValue_step2,
    MAX(CASE WHEN stepID = 3 THEN conversionRate END) AS conversionRate_step3,
    MAX(CASE WHEN stepID = 3 THEN ctrValue END) AS ctrValue_step3,
    MAX(CASE WHEN stepID = 4 THEN conversionRate END) AS conversionRate_step4,
    MAX(CASE WHEN stepID = 4 THEN ctrValue END) AS ctrValue_step4
FROM 
    tbl_conversion_values
WHERE
    isActive = 1
GROUP BY 
    segmentID, endDate
ORDER BY
    segmentID, endDate;
";

$sqlValuesSteps = "SELECT 
    cv.segmentID,
    cv.endDate,
    MAX(CASE WHEN cv.stepID = 1 THEN cv.conversionRate END) AS conversionRate_step1,
    MAX(CASE WHEN cv.stepID = 1 THEN cv.ctrValue END) AS ctrValue_step1,
    MAX(CASE WHEN cv.stepID = 1 THEN cs.stepURL END) AS text_step1,
    MAX(CASE WHEN cv.stepID = 2 THEN cv.conversionRate END) AS conversionRate_step2,
    MAX(CASE WHEN cv.stepID = 2 THEN cv.ctrValue END) AS ctrValue_step2,
    MAX(CASE WHEN cv.stepID = 2 THEN cs.stepURL END) AS text_step2,
    MAX(CASE WHEN cv.stepID = 3 THEN cv.conversionRate END) AS conversionRate_step3,
    MAX(CASE WHEN cv.stepID = 3 THEN cv.ctrValue END) AS ctrValue_step3,
    MAX(CASE WHEN cv.stepID = 3 THEN cs.stepURL END) AS text_step3,
    MAX(CASE WHEN cv.stepID = 4 THEN cv.conversionRate END) AS conversionRate_step4,
    MAX(CASE WHEN cv.stepID = 4 THEN cv.ctrValue END) AS ctrValue_step4,
    MAX(CASE WHEN cv.stepID = 4 THEN cs.stepURL END) AS text_step4
FROM 
    tbl_conversion_values cv
JOIN 
    tbl_conversion_steps cs ON cv.segmentID = cs.segmentID AND cv.stepID = cs.stepNumber
WHERE
    cv.isActive = 1 AND cs.isActive = 1
GROUP BY 
    cv.segmentID, cv.endDate
ORDER BY
    cv.segmentID, cv.endDate;
";
*/
$sqlValuesCSteps = "SELECT 
    cv.endDate,
    c.segmentName,
    ROUND(MAX(CASE WHEN cv.stepID = 1 THEN cv.conversionRate END), 2) AS conversionRate_step1,
    ROUND(MAX(CASE WHEN cv.stepID = 1 THEN cv.ctrValue END), 2) AS ctrValue_step1,
    MAX(CASE WHEN cv.stepID = 1 THEN cs.stepURL END) AS text_step1,
    ROUND(MAX(CASE WHEN cv.stepID = 2 THEN cv.conversionRate END), 2) AS conversionRate_step2,
    ROUND(MAX(CASE WHEN cv.stepID = 2 THEN cv.ctrValue END), 2) AS ctrValue_step2,
    MAX(CASE WHEN cv.stepID = 2 THEN cs.stepURL END) AS text_step2,
    ROUND(MAX(CASE WHEN cv.stepID = 3 THEN cv.conversionRate END), 2) AS conversionRate_step3,
    ROUND(MAX(CASE WHEN cv.stepID = 3 THEN cv.ctrValue END), 2) AS ctrValue_step3,
    MAX(CASE WHEN cv.stepID = 3 THEN cs.stepURL END) AS text_step3,
    ROUND(MAX(CASE WHEN cv.stepID = 4 THEN cv.conversionRate END), 2) AS conversionRate_step4,
    ROUND(MAX(CASE WHEN cv.stepID = 4 THEN cv.ctrValue END), 2) AS ctrValue_step4,
    MAX(CASE WHEN cv.stepID = 4 THEN cs.stepURL END) AS text_step4
FROM 
    tbl_conversion_values cv
JOIN 
    tbl_conversion_steps cs ON cv.segmentID = cs.segmentID AND cv.stepID = cs.stepNumber
JOIN 
    tbl_conversion c ON c.id = cs.segmentID
WHERE
    cv.isActive = 1 AND cs.isActive = 1 AND c.isActive = 1
GROUP BY 
    c.segmentName, cv.endDate
ORDER BY
    c.segmentName, cv.endDate;
;
";

$datas = getDatafromSQL($sqlValuesCSteps);

$jsonArray = array();
$i= 1;
foreach($datas as $data) {
    $jsonArray[] =   [
        "ID" =>$i,
        "recordDate"=>$data['endDate'],
        "Funnel" => $data['segmentName'],
        "Step1_Text"=>$data['text_step1'],
        "Step1_Conversion" =>round( $data['conversionRate_step1'],2),
        "Step1_CTR" => $data['ctrValue_step1'],
          "Step3_Text"=>$data['text_step2'],
        "Step2_Conversion" => $data['conversionRate_step2'],
        "Step2_CTR" =>  $data['ctrValue_step2'],
         "Step3_Text"=>$data['text_step3'],
        "Step3_Conversion" =>  $data['conversionRate_step3'],
        "Step3_CTR" => $data['ctrValue_step3'],
        "Step4_Text"=>$data['text_step4'],
        "Step4_Conversion" => $data['conversionRate_step4'],
        "Step4_CTR" =>  $data['ctrValue_step4'],
    ]; 
    $i++;
}

$jsonData = json_encode($jsonArray);
echo $jsonData;
die;
?>
