<?php 
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ERROR | E_WARNING | E_PARSE);
set_time_limit(300);


require 'vendor/autoload.php';



use Google\Analytics\Data\V1beta\Client\BetaAnalyticsDataClient;
use Google\Analytics\Data\V1beta\DateRange;
use Google\Analytics\Data\V1beta\Dimension;
use Google\Analytics\Data\V1beta\Filter;
use Google\Analytics\Data\V1beta\Filter\StringFilter;
use Google\Analytics\Data\V1beta\FilterExpression;
use Google\Analytics\Data\V1beta\FilterExpressionList;
use Google\Analytics\Data\V1beta\Metric;
use Google\Analytics\Data\V1beta\MetricType;
use Google\Analytics\Data\V1beta\RunReportRequest;
use Google\Analytics\Data\V1beta\RunReportResponse;


/**
 * TODO(developer): Replace this variable with your Google Analytics 4
 *   property ID before running the sample.
 */
$property_id = '311142476';

// Using a default constructor instructs the client to use the credentials
// specified in GOOGLE_APPLICATION_CREDENTIALS environment variable.
// Path to the service account key file
$keyFilePath = 'keys/credentials1.json';

// Instantiate the client using the key file
$client = new BetaAnalyticsDataClient([
    'credentials' => $keyFilePath
]);





// Make an API call.
$request = (new RunReportRequest())
    ->setProperty('properties/' . $property_id)
    ->setDateRanges([
        new DateRange([
            'start_date' => '2020-03-31',
            'end_date' => 'today',
        ]),
    ])
    ->setDimensions([new Dimension([
            'name' => 'city',
        ]),
    ])
    ->setMetrics([new Metric([
            'name' => 'activeUsers',
        ])
    ]);
$response = $client->runReport($request);
/*
// Print results of an API call.
print 'Report result: ' . PHP_EOL;

foreach ($response->getRows() as $row) {
    print $row->getDimensionValues()[0]->getValue()
        . ' ' . $row->getMetricValues()[0]->getValue() . PHP_EOL;
}
*/


function getMetrics($analytics, $propertyId, $startDate = '30daysAgo', $endDate = 'today', $sourceUrl, $destinationUrl) {
    try {
        $dateRange = new DateRange();
        $dateRange->setStartDate($startDate);
        $dateRange->setEndDate($endDate);

        $metrics = [
            new Metric(['name' => 'eventCount']),
            new Metric(['name' => 'totalUsers'])
        ];

        $dimensions = [
            new Dimension(['name' => 'pagePath'])
        ];

        $requests = [];

        foreach ([$sourceUrl, $destinationUrl] as $url) {
            $stringFilter = new StringFilter();
            $stringFilter->setMatchType('EXACT');
            $stringFilter->setValue($url);

            $dimensionFilter = new Filter();
            $dimensionFilter->setFieldName('pagePath');
            $dimensionFilter->setStringFilter($stringFilter);

            $filterExpression = new FilterExpression();
            $filterExpression->setFilter($dimensionFilter);

            $request = new RunReportRequest();
            $request->setDateRanges([$dateRange]);
            $request->setMetrics($metrics);
            $request->setDimensions($dimensions);
            $request->setDimensionFilter($filterExpression);

            $requests[$url] = $analytics->properties->RunReportRequest("properties/{$propertyId}", $request);
        }

        $sourceResponse = $requests[$sourceUrl];
        $destinationResponse = $requests[$destinationUrl];

        $sourceEventCount = $sourceResponse->getRows()[0]->getMetricValues()[0]->getValue();
        $sourceTotalUsers = $sourceResponse->getRows()[0]->getMetricValues()[1]->getValue();

        $destinationEventCount = $destinationResponse->getRows()[0]->getMetricValues()[0]->getValue();
        $destinationTotalUsers = $destinationResponse->getRows()[0]->getMetricValues()[1]->getValue();

        $conversionRate = ($destinationEventCount / $sourceEventCount) * 100;
        $ctr = ($sourceTotalUsers / $destinationTotalUsers) * 100;

        echo "Source URL: $sourceUrl\n";
        echo "Destination URL: $destinationUrl\n";
        echo "Source Event Count: $sourceEventCount\n";
        echo "Destination Event Count: $destinationEventCount\n";
        echo "Source Total Users: $sourceTotalUsers\n";
        echo "Destination Total Users: $destinationTotalUsers\n";
        echo "Conversion Rate: $conversionRate%\n";
        echo "CTR: $ctr%\n";
    } catch (Exception $e) {
        echo 'Error fetching metrics: ', $e->getMessage(), "\n";
        return null;
    }
}



function run_report_with_dimension_exclude_filter($client, $propertyId,$sourceUrl,$destinationUrl)
{
   
     $startDate = '2024-02-02';
    $endDate = '2024-02-08';




    // Make an API call.
    $request = (new RunReportRequest())
        ->setProperty('properties/' . $propertyId)
        ->setDimensions([
            new Dimension(['name' => 'pagePath'])
           
        ])
        ->setMetrics([
            new Metric(['name' => 'eventCount']),
            new Metric(['name' => 'sessions']),
            new Metric(['name' => 'conversions']),
              new Metric(['name' => 'totalUsers'])
        
        ])
        ->setDateRanges([
            new DateRange([
                 'start_date' => $startDate,
                'end_date' => $endDate,
            ]),
        ])
        ->setDimensionFilter(new FilterExpression([
            'and_group' => new FilterExpressionList([
                'expressions' => [
                    new FilterExpression([
                        'filter' => new Filter([
                            'field_name' => 'pagePath',
                            'string_filter' => new StringFilter([
                                'value' => $sourceUrl,
                            ])
                        ]),
                    ]),
                    new FilterExpression([
                        'filter' => new Filter([
                            'field_name' => 'pagePath',
                            'string_filter' => new StringFilter([
                                'value' => $destinationUrl,
                            ])
                         ]),
                    ]),
                ],
            ]),
        ]));
    $response = $client->runReport($request);

    printRunReportResponseWithCTRAndConversion($response);
}


function printRunReportResponseWithCTRAndConversion(RunReportResponse $response)
{
    // [START analyticsdata_print_run_report_response_header]
    printf('%s rows received%s', $response->getRowCount(), PHP_EOL);
    foreach ($response->getDimensionHeaders() as $dimensionHeader) {
        printf('Dimension header name: %s%s', $dimensionHeader->getName(), PHP_EOL);
    }
    foreach ($response->getMetricHeaders() as $metricHeader) {
        printf(
            'Metric header name: %s (%s)' . PHP_EOL,
            $metricHeader->getName(),
            MetricType::name($metricHeader->getType())
        );
    }
    // [END analyticsdata_print_run_report_response_header]

    // [START analyticsdata_print_run_report_response_rows]
    print 'Report result: ' . PHP_EOL;

    foreach ($response->getRows() as $row) {
        $source = $row->getDimensionValues()[0]->getValue();
        $destination = $row->getDimensionValues()[1]->getValue();
        $clicks = $row->getMetricValues()[0]->getValue();
        $impressions = $row->getMetricValues()[1]->getValue();
        $conversions = $row->getMetricValues()[2]->getValue();
        $ctr = ($impressions > 0) ? ($clicks / $impressions) * 100 : 0;

        printf(
            'Source: %s, Destination: %s, Clicks: %s, Impressions: %s, CTR: %.2f%%, Conversions: %s' . PHP_EOL,
            $source,
            $destination,
            $clicks,
            $impressions,
            $ctr,
            $conversions
        );
    }
    // [END analyticsdata_print_run_report_response_rows]
}
    $sourceUrl = 'https://skinresearchinstitute.com/pages/sri-dryq-lp'; // Replace with your actual source URL
    $destinationUrl = 'https://skinresearchinstitute.com/pages/sri-dryq-ftc'; // Replace with your actual destination URL
    
    
    //getMetrics($client, $property_id, '30daysAgo', 'today', $sourceUrl, $destinationUrl);
    
    
    
    run_report_with_dimension_exclude_filter($client,$property_id,$sourceUrl,$destinationUrl);

