<?php 
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ERROR | E_WARNING | E_PARSE);
set_time_limit(300);

require_once('config.php');
require 'vendor/autoload.php';


use Google\Client;
use Google\Service\AnalyticsData;
use Google\Service\AnalyticsData\DateRange;
use Google\Service\AnalyticsData\Metric;
use Google\Service\AnalyticsData\Dimension;
use Google\Service\AnalyticsData\StringFilter;
use Google\Service\AnalyticsData\Filter;
use Google\Service\AnalyticsData\FilterExpression;
use Google\Service\AnalyticsData\RunReportRequest;

$PROPERTY_ID = '311142476';
$KEY_FILE_LOCATION =  'gen-tracking-8a4567223f92.json';



function initializeAnalytics() {
    global $KEY_FILE_LOCATION;
    $client = new Client();
    $client->setAuthConfig($KEY_FILE_LOCATION);
    $client->addScope('https://www.googleapis.com/auth/analytics.readonly');
    return new AnalyticsData($client);
}
echo '<pre>';

try {
    $client = initializeAnalytics();
   // print_r($client);
    echo "Authentication successful!";
} catch (Exception $e) {
    echo 'Caught exception: ',  $e->getMessage(), "\n";
}



// Get conversion rate and CTR
function getMetrics($analytics, $propertyId, $startDate = '30daysAgo', $endDate = 'today', $sourceUrl, $destinationUrl) {
    try {
        $dateRange = new DateRange();
        $dateRange->setStartDate($startDate);
        $dateRange->setEndDate($endDate);

        $metrics = [
            new Metric(['name' => 'eventCount']),
            new Metric(['name' => 'totalUsers'])
        ];

        $dimensions = [
            new Dimension(['name' => 'pagePath']),
            new Dimension(['name' => 'pageTitle'])
        ];

        $stringFilter = new StringFilter();
        $stringFilter->setMatchType('EXACT');
        $stringFilter->setValue($sourceUrl);

        $dimensionFilter = new Filter();
        $dimensionFilter->setFieldName('pagePath');
        $dimensionFilter->setStringFilter($stringFilter);

        $filterExpression = new FilterExpression();
        $filterExpression->setFilter($dimensionFilter);

        $request = new RunReportRequest();
        $request->setDateRanges([$dateRange]);
        $request->setMetrics($metrics);
        $request->setDimensions($dimensions);
        $request->setDimensionFilter($filterExpression);
    

$response = $analytics->properties->runReport("properties/{$propertyId}", $request);
echo "Full Response:\n";
print_r($response);
       
    } catch (Exception $e) {
        echo 'Error fetching metrics: ',  $e->getMessage(), "\n";
        return null;
    }
}


function main() {
      global $PROPERTY_ID;
    $sourceUrl = 'https://skinresearchinstitute.com/pages/sri-dryq-lp'; // Replace with your actual source URL
    $destinationUrl = 'https://skinresearchinstitute.com/pages/sri-dryq-ftc'; // Replace with your actual destination URL
    
   $analytics = initializeAnalytics();
    $response = getMetrics($analytics, $PROPERTY_ID, '30daysAgo', 'today', $sourceUrl, $destinationUrl);
   
    die;

    if ($response === null) {
        echo "Failed to fetch metrics.\n";
        return;
    }

    // Ensure the response structure matches your expectations
    $rows = $response->getRows();
    if ($rows === null || !is_array($rows)) {
        echo "No data found or incorrect response format.\n";
        return;
    }

    foreach ($rows as $row) {
        $dimensions = $row->getDimensions();
        $metrics = $row->getMetrics();
        $conversionRate = $metrics[0]->getValues()[0] ?? 0;
        $ctr = $metrics[1]->getValues()[0] ?? 0;
print_r($ctr);
        //insertMetricsIntoMySQL($conversionRate, $ctr);
    }
}

main();