<?php 
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
set_time_limit(300);

require_once('config.php');
require_once('vendor/autoload.php');

use Google\Client;
use Google\Service\AnalyticsData;
use Google\Service\AnalyticsData\DateRange;
use Google\Service\AnalyticsData\Metric;
use Google\Service\AnalyticsData\Dimension;
use Google\Service\AnalyticsData\Filter;
use Google\Service\AnalyticsData\FilterExpression;
use Google\Service\AnalyticsData\StringFilter;
use Google\Service\AnalyticsData\RunReportRequest;

// Replace with your own values
$PROPERTY_ID = '311142476';
$KEY_FILE_LOCATION =  'gen-tracking-8a4567223f92.json';

// Initialize Google Analytics Data API
function initializeAnalytics() {
    global $KEY_FILE_LOCATION;
    $client = new Client();
    
    if (!file_exists($KEY_FILE_LOCATION)) {
        die("Key file not found: " . $KEY_FILE_LOCATION);
    }

    $client->setAuthConfig($KEY_FILE_LOCATION);
    $client->addScope('https://www.googleapis.com/auth/analytics.readonly');
    return new AnalyticsData($client);
}

// Get conversion rate and CTR
function getMetrics($analytics, $propertyId, $startDate = '30daysAgo', $endDate = 'today', $sourceUrl, $destinationUrl) {
    $dateRange = new DateRange();
    $dateRange->setStartDate($startDate);
    $dateRange->setEndDate($endDate);

    $metrics = [
        new Metric(['name' => 'eventCount']),
        new Metric(['name' => 'totalUsers'])
    ];

    $dimensions = [
        new Dimension(['name' => 'pagePath']),
        new Dimension(['name' => 'pageTitle'])
    ];

    $stringFilter = new StringFilter();
    $stringFilter->setMatchType('EXACT');
    $stringFilter->setValue($sourceUrl);

    $dimensionFilter = new Filter();
    $dimensionFilter->setFieldName('pagePath');
    $dimensionFilter->setStringFilter($stringFilter);

    $filterExpression = new FilterExpression();
    $filterExpression->setFilter($dimensionFilter);

    $request = new RunReportRequest();
    $request->setDateRanges([$dateRange]);
    $request->setMetrics($metrics);
    $request->setDimensions($dimensions);
    $request->setDimensionFilter($filterExpression);

    try {
        $response = $analytics->properties->runReport("properties/{$propertyId}", $request);
        return $response;
    } catch (Exception $e) {
        echo 'Request failed: ' . $e->getMessage();
        return null;
    }
}

// Insert metrics into MySQL
function insertMetricsIntoMySQL($conversionRate, $ctr) {
    $servername = "yourservername";
    $username = "yourusername";
    $password = "yourpassword";
    $dbname = "yourdbname";

    // Create connection
    $conn = new mysqli($servername, $username, $password, $dbname);

    // Check connection
    if ($conn->connect_error) {
        die("Connection failed: " . $conn->connect_error);
    }

    $sql = "INSERT INTO metrics (date, conversion_rate, ctr) VALUES (NOW(), ?, ?)";

    $stmt = $conn->prepare($sql);
    $stmt->bind_param("dd", $conversionRate, $ctr);

    if ($stmt->execute()) {
        echo "New record created successfully";
    } else {
        echo "Error: " . $sql . "<br>" . $conn->error;
    }

    $stmt->close();
    $conn->close();
}

// Main function
function main() {
    global $PROPERTY_ID;
    $sourceUrl = 'https://skinresearchinstitute.com/pages/sri-dryq-lp'; // Replace with your actual source URL
    $destinationUrl = 'https://skinresearchinstitute.com/pages/sri-dryq-ftc'; // Replace with your actual destination URL
    
    $analytics = initializeAnalytics();
    $response = getMetrics($analytics, $PROPERTY_ID, '30daysAgo', 'today', $sourceUrl, $destinationUrl);

    if ($response && $response->getRows()) {
        $rows = $response->getRows();
        foreach ($rows as $row) {
            $dimensions = $row->getDimensions();
            $metrics = $row->getMetrics();
            $conversionRate = $metrics[0]->getValues()[0];
            $ctr = $metrics[1]->getValues()[0];

            //insertMetricsIntoMySQL($conversionRate, $ctr);
        }
    } else {
        echo "No data found or error in response.";
    }
}

main();
