<?Php 

include_once('config.php');
$seldate = date('Y-m-d');
if(isset($_GET['seldate']) && $_GET['seldate']!='') {
    $seldate = $_GET['seldate'];
}

?>
<!DOCTYPE html>
<html xmlns="http://www.w3.org/1999/xhtml">
  <head>
    <title>Conversion & CTR</title>
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0" />
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
<script>window.jQuery || document.write(decodeURIComponent('%3Cscript src="js/jquery.min.js"%3E%3C/script%3E'))</script>

<link href="https://cdn3.devexpress.com/jslib/21.2.15/css/dx.common.css" rel="stylesheet" integrity="sha384-9ceVmCuW5Hi2O6t2DMUwzXLPJoXQBRHey6E6C5alO+ePpbqGKZTSdSNyjIsjMkka sha512-Iy5gn0p54NPHsw7C4tL7y3dNBA5qss7cBb5s7fPFwFYW4s0sQ7qd6Tqn+hsN2ddqioLziDhu9SgLdFcYEtrkMQ==" crossorigin="anonymous">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/devextreme/21.2.15/css/dx.light.css" rel="stylesheet">


       <script src="https://cdnjs.cloudflare.com/ajax/libs/babel-polyfill/7.4.0/polyfill.min.js"></script>



    <script src="https://cdn3.devexpress.com/jslib/21.2.15/js/dx.all.js"></script>
 
   <style>
   #gridContainer sup {
  font-size: 0.8em;
  vertical-align: super;
  line-height: 0;
}
 #dateRangeContainer {
    display: flex;
    align-items: center;  justify-content: flex-end;
    margin: 0 0 15px 0;
    gap: 10px; /* Adjust the spacing between elements as needed */
  }

  #startDate, #endDate, #applyFilterButton {
    margin: 0;
  }
  #applyFilterButton {
  padding: 10px 0;
    background: #ddd;
  }
.long-title {

  top: 0px;
  left: 0;
  right: 45px;
  z-index: 1;
}

.long-title h3 {
  font-family: 'Segoe UI Light', 'Helvetica Neue Light', 'Segoe UI', 'Helvetica Neue', 'Trebuchet MS', Verdana;
  font-weight: 200;
  font-size: 28px;
  text-align: center;
  margin: 45px 0 0 45px;
}
</style>
<script>
$(() => {
  const dataGrid = $('#gridContainer').dxDataGrid({
    dataSource: '<?php echo $baseurl?>/apiConversion.php?t=<?php echo date('YmdHis')?>&s=<?php echo $_GET['s']?>&d=<?php echo $_GET['d']?>&seldate=<?php echo $seldate?>' ,
    keyExpr: 'ID',
    allowColumnReordering: true,
    width: '100%',
    showBorders: true,
    grouping: {
      autoExpandAll: true,
    },
    filterRow: {
      visible: true,
      applyFilter: 'auto',
    },
    searchPanel: {
      visible: false,
    },
    paging: {
      pageSize: 50,
    },
    groupPanel: {
      visible: false,
    },
    columns: [
      {
        caption: 'Date',
        dataField: 'recordDate',
        alignment: 'right',
        dataType: 'date',
        width: 120,
        calculateFilterExpression(value, selectedFilterOperations, target) {
          if (target === 'headerFilter' && value === 'weekends') {
            return [[getOrderDay, '=', 0], 'or', [getOrderDay, '=', 6]];
          }
          return this.defaultCalculateFilterExpression(value, selectedFilterOperations, target);
        },
        headerFilter: {
          dataSource(data) {
            data.dataSource.postProcess = function (results) {
              results.push({
                text: 'Weekends',
                value: 'weekends',
              });
              return results;
            };
          },
        },
        editorOptions: {
          max: new Date(),  // Disable future dates
        },
      },
      {
        caption: 'Step 1',
        columns: [{
          caption: 'Conversion',
          dataField: 'Step1_Conversion'
        }, {
          caption: 'CTR',
          dataField: 'Step1_CTR'
        }],
      },
      {
        caption: 'Step 2',
        columns: [{
          caption: 'Conversion',
          dataField: 'Step2_Conversion'
        }, {
          caption: 'CTR',
          dataField: 'Step2_CTR'
        }],
      },
      {
        caption: 'Step 3',
        columns: [{
          caption: 'Conversion',
          dataField: 'Step3_Conversion'
        }, {
          caption: 'CTR',
          dataField: 'Step3_CTR'
        }],
      },
      {
        caption: 'Step 4',
        columns: [{
          caption: 'Conversion',
          dataField: 'Step4_Conversion'
        }, {
          caption: 'CTR',
          dataField: 'Step4_CTR'
        }],
      },
      {
        dataField: 'Funnel',
        groupIndex: 0,
      }
    ],
  }).dxDataGrid('instance');

  const applyFilterTypes = [{
    key: 'auto',
    name: 'Immediately',
  }, {
    key: 'onClick',
    name: 'On Button Click',
  }];

  const applyFilterModeEditor = $('#useFilterApplyButton').dxSelectBox({
    items: applyFilterTypes,
    value: applyFilterTypes[0].key,
    valueExpr: 'key',
    inputAttr: { 'aria-label': 'Apply Filter' },
    displayExpr: 'name',
    onValueChanged(data) {
      dataGrid.option('filterRow.applyFilter', data.value);
    },
  }).dxSelectBox('instance');

  const startDatePicker = $('#startDate').dxDateBox({
    type: 'date',
    placeholder: 'Start Date',
        max: new Date()  // Set max date to today

  }).dxDateBox('instance');

  const endDatePicker = $('#endDate').dxDateBox({
    type: 'date',
    placeholder: 'End Date',
        max: new Date()  // Set max date to today

  }).dxDateBox('instance');

  $('#applyFilterButton').dxButton({
    text: 'Apply Filter',
    onClick: function() {
      const startDate = startDatePicker.option('value');
      let endDate = endDatePicker.option('value');

      if (startDate && endDate) {
        // Adjust endDate to the end of the selected day
        endDate = new Date(endDate);
        endDate.setHours(23, 59, 59, 999);

        dataGrid.filter([['recordDate', '>=', startDate], 'and', ['recordDate', '<=', endDate]]);
      }
    }
  });

  function getOrderDay(rowData) {
    return (new Date(rowData.recordDate)).getDay();
  }
});
</script>


  </head>
  <body class="dx-viewport">
    <div class="demo-container">
              <div class="long-title"><h3>Conversions & CTRs</h3></div>
<div id="dateRangeContainer">
        <div id="startDate"></div>
        <div id="endDate"></div>
        <button id="applyFilterButton">Apply Filter</button>
    </div>
      <div id="gridContainer"></div>
   
    </div>
  </body>
</html>
