<?php 
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ERROR | E_WARNING | E_PARSE);


set_time_limit(300);
include_once('config.php');

date_default_timezone_set("America/Los_Angeles");
$timeZone = new DateTimeZone('America/Los_Angeles'); // Set to your desired time zone


require 'vendor/autoload.php';

// [START analyticsdata_run_funnel_report]
use Google\Analytics\Data\V1alpha\Client\AlphaAnalyticsDataClient;
use Google\Analytics\Data\V1alpha\DateRange;
use Google\Analytics\Data\V1alpha\Dimension;
use Google\Analytics\Data\V1alpha\FunnelBreakdown;
use Google\Analytics\Data\V1alpha\FunnelEventFilter;
use Google\Analytics\Data\V1alpha\FunnelFieldFilter;
use Google\Analytics\Data\V1alpha\FunnelFilterExpression;
use Google\Analytics\Data\V1alpha\FunnelFilterExpressionList;
use Google\Analytics\Data\V1alpha\FunnelStep;
use Google\Analytics\Data\V1alpha\Funnel;
use Google\Analytics\Data\V1alpha\FunnelSubReport;
use Google\Analytics\Data\V1alpha\RunFunnelReportRequest;
use Google\Analytics\Data\V1alpha\RunFunnelReportResponse;
use Google\Analytics\Data\V1alpha\StringFilter;
use Google\Analytics\Data\V1alpha\StringFilter\MatchType;



$keyFilePath = 'keys/credentials1.json';

// Instantiate the client using the key file
$client = new AlphaAnalyticsDataClient([
    'credentials' => $keyFilePath
]);



function run_funnel_report(string $propertyId,$steps,$dates,$segmentID)
{
    
    global $client,$timeZone;
    // Create an instance of the Google Analytics Data API client library.
    
$startDateTime = new DateTime($dates['startDate'], $timeZone);
$endDateTime = new DateTime($dates['endDate'], $timeZone);

// Format the dates to the required format
$startDate = $startDateTime->format('Y-m-d');
$endDate = $endDateTime->format('Y-m-d');


    // Create the funnel report request.
    $request = (new RunFunnelReportRequest())
        ->setProperty('properties/' . $propertyId)
        ->setDateRanges([
            new DateRange([
                'start_date' => $startDate, //yesterday
                'end_date' => $endDate, //today
            ]),
        ])
        
        ->setFunnel(new Funnel());

    // Add funnel steps to the funnel.


    // 2. Add organic visitors step.
    foreach($steps as $step) {
    $request->getFunnel()->getSteps()[] = new FunnelStep([
        'name' => 'Step_'.$step['stepNumber'],
        'filter_expression' => new FunnelFilterExpression([
            'funnel_field_filter' => new FunnelFieldFilter([
                'field_name' => $step['stepCondition'],
                'string_filter' => new StringFilter([
                    'match_type' => MatchType::CONTAINS,
                    'case_sensitive' => false,
                    'value' => $step['stepURL'],
                ])
            ])
        ])
    ]);
    
    }


    // 5. Add purchase step.
    $request->getFunnel()->getSteps()[] = new FunnelStep([
        'name' => 'Step_Purchase',
        'filter_expression' => new FunnelFilterExpression([
            'or_group' => new FunnelFilterExpressionList([
                'expressions' => [
                    new FunnelFilterExpression([
                        'funnel_event_filter' => new FunnelEventFilter([
                            'event_name' => 'purchase',
                        ])
                    ]),
                    new FunnelFilterExpression([
                        'funnel_event_filter' => new FunnelEventFilter([
                            'event_name' => 'in_app_purchase'
                        ])
                    ])
                ]
            ])
        ])
    ]);


    // Make an API call.
    $response = $client->runFunnelReport($request);
    print_r($response);
    
    $funnelReport = ($response->getFunnelTable());
$insertData = array();
foreach ($funnelReport->getRows() as $rowIndex => $row) {
    $stepNumber = null;

    // Process dimension values to get the step number
    foreach ($row->getDimensionValues() as $dimIndex => $dimValue) {
        $dimName = $funnelReport->getDimensionHeaders()[$dimIndex]->getName();
        //print $dimName . ": '" . $dimValue->getValue() . "'" . PHP_EOL;

        $StepName = $dimValue->getValue();
        $StepName = explode("Step_", $StepName);
        $stepNumber = $StepName[1];

        // Initialize the step data if not already initialized
        if (!isset($insertData[$stepNumber])) {
            $insertData[$stepNumber] = array('stepID' => $stepNumber);
        }
    }

    // Process metric values and add them to the corresponding step
    foreach ($row->getMetricValues() as $metricIndex => $metricValue) {
        $metricName = $funnelReport->getMetricHeaders()[$metricIndex]->getName();
        $metricValue = $metricValue->getValue();

        if ($metricName == 'activeUsers') {
            $insertData[$stepNumber]['activeUsers'] = $metricValue;
        } elseif ($metricName == 'funnelStepCompletionRate') {
            $insertData[$stepNumber]['ctrValue'] = $metricValue;
        } elseif ($metricName == 'funnelStepAbandonments') {
            $insertData[$stepNumber]['abandonmentValue'] = $metricValue;
        } elseif ($metricName == 'funnelStepAbandonmentRate') {
            $insertData[$stepNumber]['abandonmentRate'] = $metricValue;
        }
    }

    // Handle the 'Purchase' step specifically if needed
    if ($stepNumber == 'Purchase') {
        $insertData[$stepNumber]['purchase'] = $metricValue;
    }

   
}

if(isset($insertData['Purchase']['activeUsers']) && $insertData['Purchase']['activeUsers']>0){

$purchaseActiveUsers = $insertData['Purchase']['activeUsers'];
}else {
    $purchaseActiveUsers = 0;
}


foreach ($insertData as $key => $row) {
    if ($key !== 'Purchase') {
        $stepID = $row['stepID'];
        $activeUsers = $row['activeUsers'];
        $ctrValue = $row['ctrValue']*100;
        $abandonmentValue = $row['abandonmentValue'];
        $abandonmentRate = $row['abandonmentRate'] * 100;
        $conversionRate = 100*($purchaseActiveUsers/$activeUsers);
        
      $checkData =   getDatas('tbl_conversion_values', array('segmentID' => $segmentID,'stepID' => $stepID,'startDate'=>$startDate,'endDate'=>$endDate), '', '', false);
      
        if(count($checkData)<1){

        $query = "INSERT INTO tbl_conversion_values (segmentID,stepID, activeUsers,ctrValue, conversionRate, abandonmentValue, abandonmentRate,purchase,startDate,endDate) VALUES ($segmentID,$stepID, $activeUsers, $ctrValue, $conversionRate,$abandonmentValue, $abandonmentRate,$purchaseActiveUsers,'$startDate','$endDate');";
        }else {
       $query = "UPDATE tbl_conversion_values SET activeUsers = $activeUsers, ctrValue=$ctrValue,conversionRate = $conversionRate, abandonmentValue = $abandonmentValue, abandonmentRate = $abandonmentRate, purchase = $purchaseActiveUsers WHERE segmentID = $segmentID AND stepID = $stepID AND startDate = '$startDate' AND endDate = '$endDate';";

        }
       // echo $query.'<br>';
         processquery($query);
   
    }
}


  // printRunFunnelReportResponse($response);
}





   echo '<pre><br>';   
   
   

$sql = "SELECT * FROM `tbl_conversion` ORDER BY `tbl_conversion`.`processedDate` ASC limit 1";
$pDatas = getDatafromSQL($sql);


foreach($pDatas as $pData) {
    

        $recordDate = $pData['processedDate'];
        

    
    $dateTimeEnd = new DateTime($recordDate);
    
    $dateTimeEnd->modify('+1 day');

// Format the date to display it
$recordDateEnd = $dateTimeEnd->format('Y-m-d');
    
    $dates = array('startDate'=>$recordDate,'endDate'=>$recordDateEnd);
    

    
    $sql2 ="SELECT * FROM tbl_conversion_steps  WHERE segmentID ='".$pData['id']."' ORDER BY `stepNumber` ASC";
$steps = getDatafromSQL($sql2);

run_funnel_report(GA4_PROPERTY_ID,$steps,$dates,$pData['id']);
 

    

updateDatas('tbl_conversion',  array('processedDate'=>date('Y/m/d',strtotime($recordDateEnd))),  array('id'=>$pData["id"]),  false);

    
}


//echo date('Y-m-d H:i:s');

//id	setgmentID	stepID	coversionValue	conversionRate	ctrValue	abandonmentValue	abandonmentRate	recordDate	isActive