<?php
include_once('config.php');

$maxtdcount = getDatafromSQL("SELECT segmentID, COUNT(*) as count
        FROM tbl_conversion_steps
        GROUP BY segmentID
        ORDER BY count DESC
        LIMIT 1");

        
$max_steps= $maxtdcount[0]['count'];
?><title>Landing Page Status - Segments</title>
   <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-QWTKZyjpPEjISv5WaRU9OFeRpok6YctnYmDr5pNlyT2bRjXh0JMhjY6hW+ALEwIH" crossorigin="anonymous">
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js" integrity="sha384-YvpcrYf0tY3lHB60NNkmXc5s9fDVZLESaAA55NDzOxhy9GkcIdslK1eN7N6jIeHz" crossorigin="anonymous"></script>
    <div class="container mt-3">
        <h3>Segments</h3>
<table class="table  table-hover  table-striped table-bordered">
  <thead>
    <tr>
      <th scope="col">Segment</th>
      <?php for ($i = 1; $i <= $max_steps; $i++): ?>
                <th>Step <?php echo $i; ?></th>
            <?php endfor; ?>
            <th>Actions</th>
      
    </tr>
  </thead>
  <?php 
$sql = "SELECT 
    tbl_conversion.segmentName,
    tbl_conversion_steps.id,
    tbl_conversion_steps.segmentID,
    tbl_conversion_steps.stepURL,
    tbl_conversion_steps.stepCondition,
    tbl_conversion_steps.stepNumber,
    tbl_conversion_steps.isActive
FROM 
    tbl_conversion_steps
JOIN 
    tbl_conversion 
ON 
    tbl_conversion.id = tbl_conversion_steps.segmentID
ORDER BY 
    tbl_conversion_steps.segmentID, tbl_conversion_steps.stepNumber";

$segmentDatas = getDatafromSQL($sql);

$data = [];
foreach ($segmentDatas as $segmentData) {
    $segmentID = $segmentData['segmentID'];
    $segmentName = $segmentData['segmentName'];
    $data[$segmentID]['segmentName'] = $segmentName;
    $data[$segmentID]['steps'][] = [
        'stepURL' => $segmentData['stepURL'],
        'stepCondition' => $segmentData['stepCondition'],
        'stepNumber' => $segmentData['stepNumber']
    ];
}

$max_steps = 4; // You may want to dynamically determine this value based on your data

?>
<tbody>
    <?php foreach ($data as $segmentID => $segmentData): ?>
        <tr>
            <td><?php echo $segmentData['segmentName']; ?></td>
            <?php for ($i = 0; $i < $max_steps; $i++): ?>
                <td>
                    <?php echo isset($segmentData['steps'][$i]['stepURL']) ? '<strong>Path/Title</strong> : '.$segmentData['steps'][$i]['stepURL'] : ''; ?><br>
                    <?php echo isset($segmentData['steps'][$i]['stepCondition']) ? '<strong>Condition</strong> : '.$segmentData['steps'][$i]['stepCondition'] : ''; ?><br>
                </td>
            <?php endfor; ?>
            <td><a href="/conversion/addSteps.php?id=<?php echo $segmentID; ?>">Edit</a></td>
        </tr>
    <?php endforeach; ?>
</tbody>

</table>
</div>