<?Php
include_once('config.php');



$sqls = "SELECT 
    sri_urls.urlName,
    sri_urls.sriURL,
    performance_data.*
FROM
    sri_urls
JOIN (
    SELECT 
        pageID,
        DATE(recordDate) AS recordDate,
        CONCAT(
            ROUND(GROUP_CONCAT(CASE WHEN strategy = 'mobile' THEN performance END ORDER BY strategy), 2),
            '/',
            ROUND(GROUP_CONCAT(CASE WHEN strategy = 'desktop' THEN performance END ORDER BY strategy), 2)
        ) AS performance,
        CONCAT(
            ROUND(GROUP_CONCAT(CASE WHEN strategy = 'mobile' THEN accessibility END ORDER BY strategy), 2),
            '/',
            ROUND(GROUP_CONCAT(CASE WHEN strategy = 'desktop' THEN accessibility END ORDER BY strategy), 2)
        ) AS accessibility,
        CONCAT(
            ROUND(GROUP_CONCAT(CASE WHEN strategy = 'mobile' THEN bestPractice END ORDER BY strategy), 2),
            '/',
            ROUND(GROUP_CONCAT(CASE WHEN strategy = 'desktop' THEN bestPractice END ORDER BY strategy), 2)
        ) AS bestPractice,
        CONCAT(
            ROUND(GROUP_CONCAT(CASE WHEN strategy = 'mobile' THEN seo END ORDER BY strategy), 2),
            '/',
            ROUND(GROUP_CONCAT(CASE WHEN strategy = 'desktop' THEN seo END ORDER BY strategy), 2)
        ) AS seo,
        GROUP_CONCAT(strategy) AS strategy
    FROM 
        sri_performance_data
    GROUP BY 
        pageID, DATE(recordDate)  
    ORDER BY 
        recordDate ASC
) AS performance_data ON sri_urls.id = performance_data.pageID
";
$sql  = "SELECT 
    sri_urls.urlName, 
    sri_urls.sriURL, 
    performance_data.* 
FROM 
    sri_urls 
JOIN 
    (SELECT 
        pageID, 
        DATE(recordDate) AS recordDate, 
        CONCAT(ROUND(GROUP_CONCAT(CASE WHEN strategy = 'mobile' THEN performance*100 END ORDER BY strategy), 0), '/', ROUND(GROUP_CONCAT(CASE WHEN strategy = 'desktop' THEN performance*100 END ORDER BY strategy), 0)) AS performance, 
        CONCAT(ROUND(GROUP_CONCAT(CASE WHEN strategy = 'mobile' THEN accessibility*100 END ORDER BY strategy), 0), '/', ROUND(GROUP_CONCAT(CASE WHEN strategy = 'desktop' THEN accessibility*100 END ORDER BY strategy), 0)) AS accessibility, 
        CONCAT(ROUND(GROUP_CONCAT(CASE WHEN strategy = 'mobile' THEN bestPractice*100 END ORDER BY strategy), 0), '/', ROUND(GROUP_CONCAT(CASE WHEN strategy = 'desktop' THEN bestPractice*100 END ORDER BY strategy), 0)) AS bestPractice, 
        CONCAT(ROUND(GROUP_CONCAT(CASE WHEN strategy = 'mobile' THEN seo*100 END ORDER BY strategy), 0), '/', ROUND(GROUP_CONCAT(CASE WHEN strategy = 'desktop' THEN seo*100 END ORDER BY strategy), 0)) AS seo, 
        GROUP_CONCAT(strategy) AS strategy 
    FROM 
        sri_performance_data 
    GROUP BY 
        pageID, DATE(recordDate) 
    ORDER BY 
        recordDate ASC 
    ) AS performance_data 
ON 
    sri_urls.id = performance_data.pageID 
";

if((isset($_GET['s']) && $_GET['s']!='') || (isset($_GET['seldate']) && $_GET['seldate']!='')) {
      
    $sql .= "WHERE ";
}
    
    
if(isset($_GET['s']) && $_GET['s']!='') {
    
    $sql .= "
    sri_urls.id IN (".$_GET['s'].")";
}
    
    if(isset($_GET['seldate']) && $_GET['seldate']!='') {
    if(isset($_GET['s']) && $_GET['s']!='') {
         $sql .= " AND "; 
    }
    
    $sql .= "
    recordDate = '".$_GET['seldate']."'";
    
    
}
    

//echo $sql;
$allDatas = getDatafromSQL($sql);
$rData = array();

foreach($allDatas as $allData) {
    
    $rData[]= array(  "name"=> $allData['urlName'],
       "fullUrl"=> $allData['sriURL'],
       "performance"=> $allData['performance'],
       "accessibility"=> $allData['accessibility'],
       "bestPractice"=> $allData['bestPractice'],
       "seo"=> $allData['seo'],
       "recordDate"=> $allData['recordDate']
       );
}

echo json_encode($rData);die;