<?php 
set_time_limit(300);
ini_set('display_errors', '1');
ini_set('display_startup_errors', '1');
error_reporting(E_ALL);

//require_once('config.php');
require_once '../vendor/autoload.php';
echo '<pre>';

use Google\Client;
use Google\Service\Webmasters;

// Create the Google Client
$client = new Client();
$client->setApplicationName('Google Search Console PHP');
$client->setScopes([Webmasters::WEBMASTERS_READONLY]);
$client->setAuthConfig('../gkeys/credentials.json');

// Create the Webmasters Service
$service = new Webmasters($client);

// Define the request parameters
$request = new Webmasters\SearchAnalyticsQueryRequest();
$request->setStartDate('2024-06-01');
$request->setEndDate('2024-06-30');
$request->setDimensions(['query']);
$request->setRowLimit(10);

try {
    // Make the API request
    $response = $service->searchanalytics->query('https://skinresearchinstitute.com/pages/sri-colsilk-lp', $request);
    print_r($response);
} catch (Exception $e) {
    echo 'Error: ' . $e->getMessage();
}
