<?php 
set_time_limit(300);
ini_set('display_errors', '1');
ini_set('display_startup_errors', '1');
error_reporting(E_ALL);

require_once('config.php');
require_once('vendor/autoload.php');
use Symfony\Component\HttpClient\HttpClient;

use PageSpeed\Insights;
$client = HttpClient::create();
// Instantiate the PageSpeed\Service class
$pageSpeed = new PageSpeed\Insights\Service($client,'https://www.googleapis.com/pagespeedonline/v5/runPagespeed', $apiKey);

//$pageSpeedService = new Service($client, 'https://www.googleapis.com/pagespeedonline/v5/runPagespeed', $apiKey);
//https://pagespeedonline.googleapis.com/pagespeedonline/v5/runPagespeed
    if(isset($_GET['strategy']) && $_GET['strategy']=='desktop') {
        $strategy='desktop';
        $sql = "SELECT * FROM `sri_urls` where processedDate!= DATE_FORMAT(NOW(), '%Y-%m-%d') ORDER BY `sri_urls`.`processedDate` ASC limit 1";
    }else {
          $strategy='mobile';

    
$sql = "SELECT * FROM `sri_urls` where processedDateMobile!= DATE_FORMAT(NOW(), '%Y-%m-%d') ORDER BY `sri_urls`.`processedDateMobile` ASC limit 1";

        
    }
    


$allURLS = getDatafromSQL($sql);



$extraParams = [
    'category' => ['SEO','BEST_PRACTICES','ACCESSIBILITY','PERFORMANCE'], // Example of category parameter
    'fields' => 'lighthouseResult.categories', // Example of another parameter
];


foreach($allURLS as $pageurl) {


$response = $pageSpeed->getResults($pageurl['sriURL'],$strategy,$extraParams);

//print_r($response);

$data = array('pageID'=>$pageurl['id'],'recordDate'=>date('Y-m-d H:i:s'),'strategy'=>$strategy,
              'performance'=>$response['lighthouseResult']['categories']['performance']['score'],
            'accessibility'=>$response['lighthouseResult']['categories']['accessibility']['score'],
            'bestPractice'=>$response['lighthouseResult']['categories']['best-practices']['score'],
            'seo'=>$response['lighthouseResult']['categories']['seo']['score']);
createDatas('sri_performance_data',  $data, false);

    if($_GET['strategy']=='desktop') {
updateDatas('sri_urls', array('processedDate'=>date('Y-m-d')), array('id'=>$pageurl['id']), false);
}else {
    updateDatas('sri_urls', array('processedDateMobile'=>date('Y-m-d')), array('id'=>$pageurl['id']), false);

}

    //$response = getInsightsData($pageurl['sriURL'], $strategy);
    
}



?>
