<!DOCTYPE html>
<html>
<head>
    <title>DevExtreme Tabs with DataGrid and Chart</title>
    <meta charset="utf-8" />
    <link rel="stylesheet" type="text/css" href="https://cdn3.devexpress.com/jslib/21.2.6/css/dx.light.css" />
    <script src="https://cdn.jsdelivr.net/npm/jquery@3.5.1/dist/jquery.min.js"></script>
    <script src="https://cdn3.devexpress.com/jslib/21.2.6/js/dx.all.js"></script>
    <style>
        #dataGridContainer {
            display: block;
        }

        #chartContainer {
            display: none;
        }
    </style>
</head>
<body>
    <div id="tabsContainer"></div>

    <div id="dataGridContainer">
        <div id="dataGrid"></div>
    </div>

    <div id="chartContainer">
        <div id="chart"></div>
    </div>

    <script>
        $(function() {
            var dataGrid = $("#dataGrid").dxDataGrid({
                dataSource: {
                    store: {
                        type: "array",
                        data: [
                            { id: 1, name: "John", age: 30 },
                            { id: 2, name: "Jane", age: 25 },
                            { id: 3, name: "Doe", age: 40 }
                        ],
                        key: "id"
                    }
                },
                columns: ["id", "name", "age"]
            }).dxDataGrid("instance");

            var chart = $("#chart").dxChart({
                dataSource: [
                    { month: "January", value: 10 },
                    { month: "February", value: 20 },
                    { month: "March", value: 30 }
                ],
                series: {
                    argumentField: "month",
                    valueField: "value",
                    type: "bar"
                }
            }).dxChart("instance");

            $("#tabsContainer").dxTabs({
                dataSource: [
                    { title: "DataGrid Tab" },
                    { title: "Chart Tab" }
                ],
                selectedIndex: 0, // Select the first tab by default
                itemTemplate: function(itemData, itemIndex, itemElement) {
                    itemElement.text(itemData.title);
                },
                onSelectionChanged: function(e) {
                    // Handle selection change event
                    var selectedTabIndex = e.component.option("selectedIndex");
                    console.log("Selected Tab Index:", selectedTabIndex);
                    toggleComponents(selectedTabIndex);
                }
            });

            function toggleComponents(selectedTabIndex) {
                if (selectedTabIndex === 0) {
                    $("#dataGridContainer").show();
                    $("#chartContainer").hide();
                } else if (selectedTabIndex === 1) {
                    $("#dataGridContainer").hide();
                    $("#chartContainer").show();
                }
            }
        });
    </script>
</body>
</html>
