<?php 
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ERROR | E_WARNING | E_PARSE);



include_once('config.php');


//weekly product refund

$startDate = $_GET['startDate']; // Replace with dynamic value
$endDate = $_GET['endDate'];   // Replace with dynamic value
$stores = "'SRI', 'PSC'";  // Replace with dynamic values or user input

if(isset($_GET['stores']) && $_GET['stores']!='') {
    $stores = wrapElementsInQuotes($_GET['stores']);  
}



    
   $sql = "WITH weekly_refunds AS (
    SELECT 
        np.stockCode AS Product,
        DATE_FORMAT(sr.Refunded_Date__c, '%Y-%u') AS RefundWeek,
        SUM(sr.Amount__c) AS RefundAmount
    FROM 
        salesforce_refunds sr
    JOIN 
        newsystem_orders ot ON sr.Order__c = ot.salesforceID
    JOIN 
        newsystem_orders_product np ON ot.newSystemOrderID = np.newSystemOrderID
    WHERE 
        sr.Refunded_Date__c BETWEEN '$startDate' AND '$endDate'
        AND sr.Cart_Number__c IN ($stores)
    GROUP BY 
        np.stockCode, RefundWeek
),
all_weeks AS (
    SELECT DISTINCT
        DATE_FORMAT(Refunded_Date__c, '%Y-%u') AS RefundWeek
    FROM
        salesforce_refunds
    WHERE 
        Refunded_Date__c BETWEEN '$startDate' AND '$endDate'
        AND Cart_Number__c IN ($stores)
)
        
SELECT 
    COALESCE(wr.Product, 'No Product') AS Product,
    w.RefundWeek,
    COALESCE(wr.RefundAmount, 0) AS RefundAmount
FROM 
    all_weeks w
LEFT JOIN 
    weekly_refunds wr ON w.RefundWeek = wr.RefundWeek
ORDER BY 
    w.RefundWeek DESC, wr.Product;";

$data = [];
$weeks = [];


$returndatas = getDatafromSQL($sql);



foreach($returndatas as $returndata) {
 $dateRange = convertToDate($returndata['RefundWeek']);
  $weeks[$returndata['RefundWeek']] = $dateRange['startDay'].' to '.$dateRange['endDay'];
    
}

foreach($returndatas as $row) {
 $Product = $row['Product'];
    $refundWeek = $row['RefundWeek'];
    $refundAmount = $row['RefundAmount'];

    if (!isset($data[$Product])) {
        
        $data[$Product] = ["Product" => $Product];
    }
    
    $data[$Product][$weeks[$refundWeek]] = $refundAmount;
}

$jsonOutput = array_values($data);

echo json_encode($jsonOutput, JSON_PRETTY_PRINT);

die;