<?php 
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ERROR | E_WARNING | E_PARSE);



include_once('config.php');



$startDate = $_GET['startDate']; // Replace with dynamic value
$endDate = $_GET['endDate'];   // Replace with dynamic value
$stores = "'SRI', 'PSC'";  // Replace with dynamic values or user input

if(isset($_GET['stores']) && $_GET['stores']!='') {
    $stores = wrapElementsInQuotes($_GET['stores']);  
    
   
}
$sql = "WITH weekly_refunds AS (
            SELECT 
                sr.Reason_for_Refund__c AS RefundReason,
                DATE_FORMAT(sr.Refunded_Date__c, '%Y-%u') AS RefundWeek,
                SUM(sr.Amount__c) AS RefundAmount
            FROM 
                salesforce_refunds sr
            JOIN 
                newsystem_orders ot ON sr.Order__c = ot.salesforceID
            WHERE 
                sr.Refunded_Date__c BETWEEN '$startDate' AND '$endDate'
                AND sr.Cart_Number__c IN ($stores)
            GROUP BY 
                sr.Reason_for_Refund__c, RefundWeek
        ),
        all_weeks AS (
            SELECT DISTINCT
                DATE_FORMAT(Refunded_Date__c, '%Y-%u') AS RefundWeek
            FROM
                salesforce_refunds
            WHERE 
                Refunded_Date__c BETWEEN '$startDate' AND '$endDate'
                AND Cart_Number__c IN ($stores)
        )
        
        SELECT 
            wr.RefundReason,
            w.RefundWeek,
            COALESCE(wr.RefundAmount, 0) AS RefundAmount
        FROM 
            all_weeks w
        LEFT JOIN 
            weekly_refunds wr ON w.RefundWeek = wr.RefundWeek
        ORDER BY 
            w.RefundWeek DESC, wr.RefundReason";
            
            
            
            
          $sql = "WITH RECURSIVE date_range AS (
    -- Adjust the start date to the nearest previous Friday
    SELECT 
        CASE 
            WHEN WEEKDAY('$startDate') = 5 THEN DATE('$startDate') -- If start date is Friday
            ELSE DATE_SUB('$startDate', INTERVAL (WEEKDAY('$startDate') + 2) % 7 + 1 DAY)
        END AS StartDate,
        '$endDate' AS EndDate
),
week_boundaries AS (
    SELECT
        StartDate,
        DATE_ADD(StartDate, INTERVAL 6 DAY) AS EndDate
    FROM date_range
    UNION ALL
    SELECT
        DATE_ADD(StartDate, INTERVAL 7 DAY),
        DATE_ADD(EndDate, INTERVAL 7 DAY)
    FROM week_boundaries
    WHERE DATE_ADD(StartDate, INTERVAL 7 DAY) <= (SELECT EndDate FROM date_range)
),
weekly_refunds AS (
    SELECT 
        COALESCE(sr.Reason_for_Refund__c, 'Blank') AS RefundReason, 
        sr.Refunded_Date__c AS RefundDate,
        SUM(sr.Amount__c) AS RefundAmount 
    FROM salesforce_refunds sr 
    JOIN newsystem_orders ot ON sr.Order__c = ot.salesforceID 
    WHERE sr.Refunded_Date__c BETWEEN (SELECT StartDate FROM date_range) AND (SELECT EndDate FROM date_range)
    AND sr.Brand__c IN  ($stores)
    GROUP BY RefundReason, RefundDate
),
all_reasons AS (
    SELECT DISTINCT COALESCE(Reason_for_Refund__c, 'Blank') AS RefundReason
    FROM salesforce_refunds
),
date_weeks AS (
    SELECT
        wb.StartDate,
        wb.EndDate,
        CONCAT(DATE_FORMAT(wb.StartDate, '%Y-%m-%d'), ' to ', DATE_FORMAT(wb.EndDate, '%Y-%m-%d')) AS RefundWeek
    FROM week_boundaries wb
)
SELECT 
    ar.RefundReason,
    dw.RefundWeek,
    COALESCE(SUM(wr.RefundAmount), 0) AS RefundAmount
FROM all_reasons ar
CROSS JOIN date_weeks dw
LEFT JOIN weekly_refunds wr 
    ON ar.RefundReason = wr.RefundReason 
    AND wr.RefundDate BETWEEN dw.StartDate AND dw.EndDate
GROUP BY ar.RefundReason, dw.RefundWeek
ORDER BY dw.StartDate DESC, ar.RefundReason;
";


$data = [];
$weeks = [];


$returndatas = getDatafromSQL($sql);


foreach($returndatas as $returndata) {
//$dateRange = convertToDate($returndata['RefundWeek']);
 // $weeks[$returndata['RefundWeek']] = $dateRange['startDay'].' to '.$dateRange['endDay'];
      $weeks[$returndata['RefundWeek']] =$returndata['RefundWeek'];

}

foreach($returndatas as $row) {
 $refundReason = $row['RefundReason'];
    $refundWeek = $row['RefundWeek'];
    $refundAmount = $row['RefundAmount'];

    if (!isset($data[$refundReason])) {
        
        $data[$refundReason] = ["RefundReason" => $refundReason];
    }
    
    $data[$refundReason][$weeks[$refundWeek]] = $refundAmount;
}

$jsonOutput = array_values($data);

echo json_encode($jsonOutput, JSON_PRETTY_PRINT);

die;