<?php 
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ERROR | E_WARNING | E_PARSE);

require 'vendor/autoload.php';
echo '<pre>';

include_once('config.php');



use GuzzleHttp\Client;
use Shopify\PuplicApp;
use rdx\graphqlquery\Query;


  

function createSalesforceProduct($access_token, $instance_url, $product_data) {

    $client = new Client();
    try {
        $response = $client->request('POST', "$instance_url/services/data/v52.0/sobjects/Product2", [
            'headers' => [
                'Authorization' => "Bearer $access_token",
                'Content-Type' => 'application/json',
            ],
            'body' => json_encode($product_data),
        ]);
        $data = json_decode($response->getBody(), true);
        return $data;
    } catch (\GuzzleHttp\Exception\RequestException $e) {
        echo "Error creating Product2: " . $e->getResponse()->getBody()->getContents();
        return null;
    }
}



function createSalesforceProductVariant($access_token, $instance_url, $variant_data) {
    

    $client = new Client();
    try {
        $response = $client->request('POST', "$instance_url/services/data/v52.0/sobjects/ProductItem", [
            'headers' => [
                'Authorization' => "Bearer $access_token",
                'Content-Type' => 'application/json',
            ],
            'body' => json_encode($variant_data),
        ]);
        $data = json_decode($response->getBody(), true);
        return $data;
    } catch (\GuzzleHttp\Exception\RequestException $e) {
        echo "Error creating ProductItem: " . $e->getResponse()->getBody()->getContents();
        return null;
    }
}


function getContactFields($access_token, $instance_url) {
    $client = new Client();
    try {
        $response = $client->request('GET', "$instance_url/services/data/v52.0/sobjects/Contact/describe", [
            'headers' => [
                'Authorization' => "Bearer $access_token",
                'Content-Type' => 'application/json',
            ]
        ]);

        $data = json_decode($response->getBody(), true);
        $fields = array_map(function($field) {
            return $field['name'];
        }, $data['fields']);
        return $fields;
    } catch (\GuzzleHttp\Exception\RequestException $e) {
        echo "Error describing Contact object: " . $e->getResponse()->getBody()->getContents();
        return null;
    }
}


function getAllContacts($access_token, $instance_url, $fields) {
    $client = new Client();
    try {
        $response = $client->request('GET', "$instance_url/services/data/v52.0/query", [
            'headers' => [
                'Authorization' => "Bearer $access_token",
                'Content-Type' => 'application/json',
            ],
            'query' => [
                'q' => "SELECT " . implode(',', $fields) . " FROM Contact"
            ]
        ]);

        $data = json_decode($response->getBody(), true);
        return $data['records'];
    } catch (\GuzzleHttp\Exception\RequestException $e) {
        echo "Error retrieving Contact records: " . $e->getResponse()->getBody()->getContents();
        return null;
    }
}

            
function createSalesforceContact($access_token, $instance_url, $contact_data) {
    $client = new Client();
    try {
        $response = $client->request('POST', "$instance_url/services/data/v52.0/sobjects/Contact", [
            'headers' => [
                'Authorization' => "Bearer $access_token",
                'Content-Type' => 'application/json',
            ],
            'body' => json_encode($contact_data),
        ]);
        $data = json_decode($response->getBody(), true);
        return $data;
    } catch (\GuzzleHttp\Exception\RequestException $e) {
        echo "Error creating Contact: " . $e->getResponse()->getBody()->getContents();
        return null;
    }
}


function authenticateSalesforce($client_id, $client_secret, $username, $password, $security_token) {
    $client = new Client();
    $response = $client->request('POST', 'https://login.salesforce.com/services/oauth2/token', [
        'form_params' => [
            'grant_type' => 'password',
            'client_id' => $client_id,
            'client_secret' => $client_secret,
            'username' => $username,
            'password' => $password . $security_token,
        ],
    ]);

    $data = json_decode($response->getBody(), true);
    return $data['access_token'];
}

function createSalesforceOrder($access_token, $instance_url, $order_data) {
    $client = new Client();
    try {
        $response = $client->request('POST', "$instance_url/services/data/v52.0/sobjects/Order__c", [
            'headers' => [
                'Authorization' => "Bearer $access_token",
                'Content-Type' => 'application/json',
            ],
            'body' => json_encode($order_data),
        ]);
        $data = json_decode($response->getBody(), true);
        return $data;
    } catch (\GuzzleHttp\Exception\RequestException $e) {
        echo "Error creating Order__c: " . $e->getResponse()->getBody()->getContents();
        return null;
    }
}
function getOrderLineItems($access_token, $instance_url, $order_id) {
    $client = new Client();
    $response = $client->request('GET', "$instance_url/services/data/v52.0/query/", [
        'headers' => [
            'Authorization' => "Bearer $access_token",
            'Content-Type' => 'application/json',
        ],
        'query' => [
            'q' => "SELECT Id FROM Order_Line_Item__c WHERE Order__c = '$order_id'"
        ],
    ]);

    $data = json_decode($response->getBody(), true);
    return $data['records'];
}

function deleteOrderLineItem($access_token, $instance_url, $line_item_id) {
    $client = new Client();
    $response = $client->request('DELETE', "$instance_url/services/data/v52.0/sobjects/Order_Line_Item__c/$line_item_id", [
        'headers' => [
            'Authorization' => "Bearer $access_token",
        ],
    ]);

    return $response->getStatusCode();
}



function createSalesforceOrderLineItem($access_token, $instance_url, $line_item_data) {
    $client = new Client();
    $response = $client->request('POST', "$instance_url/services/data/v52.0/sobjects/Order_Line_Item__c", [
        'headers' => [
            'Authorization' => "Bearer $access_token",
            'Content-Type' => 'application/json',
        ],
        'body' => json_encode($line_item_data),
    ]);

    $data = json_decode($response->getBody(), true);
    return $data;
}


$access_token = authenticateSalesforce(SF_CLIENT_ID, SF_CLIENT_SECRET, SF_USERNAME, SF_PASSWORD, SECURITY_TOKEN);
$instance_url = 'https://thgenesis.my.salesforce.com';


function getSalesforceOrders($access_token, $instance_url,$orderNumber) {
    $client = new Client();
    try {
        $response = $client->request('GET', "$instance_url/services/data/v52.0/query", [
            'headers' => [
                'Authorization' => "Bearer $access_token",
                'Content-Type' => 'application/json',
            ],
            'query' => [
                'q' => "SELECT Id, Name, Contact__c,Shopify_Created_date__c FROM Order__c WHERE Order_Id__c = '".$orderNumber."'"  // Adjust the fields as necessary
            ]
        ]);

        $data = json_decode($response->getBody(), true);
        return $data['records'];
    } catch (\GuzzleHttp\Exception\RequestException $e) {
        echo "Error retrieving Order__c records: " . $e->getResponse()->getBody()->getContents();
        return null;
    }
}

function updateSalesforceOrder($access_token, $instance_url, $order_id, $order_data) {
    $client = new Client();
    try {
        $response = $client->request('PATCH', "$instance_url/services/data/v52.0/sobjects/Order__c/$order_id", [
            'headers' => [
                'Authorization' => "Bearer $access_token",
                'Content-Type' => 'application/json',
            ],
            'body' => json_encode($order_data),
        ]);
        return true;
    } catch (\GuzzleHttp\Exception\RequestException $e) {
        echo "Error updating Order__c: " . $e->getResponse()->getBody()->getContents();
        return false;
    }
}


function getCustomContacts($access_token, $instance_url,$email) {

    $client = new Client();
    try {
        $response = $client->request('GET', "$instance_url/services/data/v52.0/query", [
            'headers' => [
                'Authorization' => "Bearer $access_token",
                'Content-Type' => 'application/json',
            ],
            'query' => [
                'q' => "SELECT Id, Phone, MobilePhone, FirstName, MiddleName, LastName, Email, MailingStreet, MailingCity, MailingState, MailingPostalCode, MailingCountry,HomePhone FROM Contact WHERE Email = '".$email."'"  // Adjust the fields as necessary
            ]
        ]);

        $data = json_decode($response->getBody(), true);
        return $data['records'];
    } catch (\GuzzleHttp\Exception\RequestException $e) {
        echo "Error retrieving Order__c records: " . $e->getResponse()->getBody()->getContents();
        return null;
    }
}

// $custom_contacts = getCustomContacts($access_token, $instance_url);
// print_r($custom_contacts);
// die;




function getProduct2Fields($access_token, $instance_url) {
    $client = new Client();
    try {
        $response = $client->request('GET', "$instance_url/services/data/v52.0/sobjects/Product2/describe", [
            'headers' => [
                'Authorization' => "Bearer $access_token",
                'Content-Type' => 'application/json',
            ]
        ]);

        $data = json_decode($response->getBody(), true);
        $fields = array_map(function($field) {
            return $field['name'];
        }, $data['fields']);
        return $fields;
    } catch (\GuzzleHttp\Exception\RequestException $e) {
        echo "Error describing Product2 object: " . $e->getResponse()->getBody()->getContents();
        return null;
    }
}


function getAllProducts($access_token, $instance_url,$sku) {
    $client = new Client();
    try {
      
        $response = $client->request('GET', "$instance_url/services/data/v52.0/query", [
            'headers' => [
                'Authorization' => "Bearer $access_token",
                'Content-Type' => 'application/json',
            ],
            'query' => [
                'q' => "SELECT Id,SKU__c,Status__c,Price__c,Name FROM Product2 where SKU__c ='".$sku."'"
            ]
        ]);
        $data = json_decode($response->getBody(), true);
        return $data['records'];
    } catch (\GuzzleHttp\Exception\RequestException $e) {
        echo "Error retrieving Product2 records: " . $e->getResponse()->getBody()->getContents();
        return null;
    }
}

function processProduct($access_token, $instance_url,$productDetail) {
    global $SRIclient,$SHOPIFY_SHOP_DOMAIN,$SHOPIFY_API_KEY,$SHOPIFY_API_SECRET,$api_params,$SHOPIFY_TOKEN;
              $sfProducts = getAllProducts($access_token, $instance_url,$productDetail['stockCode']);


      if(count($sfProducts)>=1) {
          
          $sfProduct = $sfProducts[0];
      
      $productData  = array('PID'=>$sfProduct['Id'],'Price'=>$sfProduct['Price__c'],'Name'=>$sfProduct['Name']);
      
      return $productData;
  }
  
  
else {
  
    

    
    $product_data = [
    'Name' => $productDetail['stockCode'],
    'ProductCode' =>$productDetail['stockCode'],
    'Description' =>$productDetail['stockCode'],
    'IsActive' => true,
    'SKU__c'=>$productDetail['stockCode'],
    'Price__c'=>$productDetail['unitPrice']
    // Add other custom fields as necessary
];

$product_result = createSalesforceProduct($access_token, $instance_url, $product_data);
if ($product_result === null) {
    exit("Failed to create Product2.\n");
}

$product_id = $product_result['id'];  // Capture the ID of the newly created Product2

      $productData  = array('PID'=>$product_id,'Price'=>$productDetail['unitPrice'],'Name'=>$productDetail['stockCode']);









}
return $productData;

}

// $fields = getProduct2Fields($access_token, $instance_url);

// if ($fields !== null) {
//     // Get all products with all fields
//     $products = getAllProducts($access_token, $instance_url, $fields);
//     print_r($products);
// }

// die;

// // Get all fields for Contact
// $fields = getContactFields($access_token, $instance_url);

// if ($fields !== null) {
//     // Get all contacts with all fields
//     $contacts = getAllContacts($access_token, $instance_url, $fields);
//     print_r($contacts);
// } else {
//     echo "Failed to retrieve fields for Contact.\n";
// }

function getAccountFields($access_token, $instance_url) {
    $client = new Client();
    try {
        $response = $client->request('GET', "$instance_url/services/data/v52.0/sobjects/Account/describe", [
            'headers' => [
                'Authorization' => "Bearer $access_token",
                'Content-Type' => 'application/json',
            ]
        ]);

        $data = json_decode($response->getBody(), true);
        $fields = array_map(function($field) {
            return $field['name'];
        }, $data['fields']);
        return $fields;
    } catch (\GuzzleHttp\Exception\RequestException $e) {
        echo "Error describing Account object: " . $e->getResponse()->getBody()->getContents();
        return null;
    }
}
function getAllAccounts($access_token, $instance_url, $fields) {
    $client = new Client();
    try {
        $response = $client->request('GET', "$instance_url/services/data/v52.0/query", [
            'headers' => [
                'Authorization' => "Bearer $access_token",
                'Content-Type' => 'application/json',
            ],
            'query' => [
                'q' => "SELECT " . implode(',', $fields) . " FROM Account"
            ]
        ]);

        $data = json_decode($response->getBody(), true);
        return $data['records'];
    } catch (\GuzzleHttp\Exception\RequestException $e) {
        echo "Error retrieving Account records: " . $e->getResponse()->getBody()->getContents();
        return null;
    }
}


function createSalesforceAccount($access_token, $instance_url, $account_data) {
    $client = new Client();
    try {
        $response = $client->request('POST', "$instance_url/services/data/v52.0/sobjects/Account", [
            'headers' => [
                'Authorization' => "Bearer $access_token",
                'Content-Type' => 'application/json',
            ],
            'body' => json_encode($account_data),
        ]);
        $data = json_decode($response->getBody(), true);
        return $data;
    } catch (\GuzzleHttp\Exception\RequestException $e) {
        echo "Error creating Account: " . $e->getResponse()->getBody()->getContents();
        return null;
    }
}



function updateSalesforceAccount($access_token, $instance_url, $account_id, $account_data) {
    $client = new Client();
    try {
        $response = $client->request('PATCH', "$instance_url/services/data/v52.0/sobjects/Account/$account_id", [
            'headers' => [
                'Authorization' => "Bearer $access_token",
                'Content-Type' => 'application/json',
            ],
            'body' => json_encode($account_data),
        ]);
        return true;
    } catch (\GuzzleHttp\Exception\RequestException $e) {
        echo "Error updating Account: " . $e->getResponse()->getBody()->getContents();
        return false;
    }
}


function getAccountByEmail($access_token, $instance_url, $email,$name) {
    $client = new Client();
    try {
        $response = $client->request('GET', "$instance_url/services/data/v52.0/query", [
            'headers' => [
                'Authorization' => "Bearer $access_token",
                'Content-Type' => 'application/json',
            ],
            'query' => [
                'q' => "SELECT Id FROM Account WHERE Email__c = '$email' OR Name = '".addslashes($name)."'"  // Adjust the fields as necessary
            ]
        ]);

        $data = json_decode($response->getBody(), true);
        return $data['records'];
    } catch (\GuzzleHttp\Exception\RequestException $e) {
        echo "Error retrieving Account records: " . $e->getResponse()->getBody()->getContents();
        return null;
    }
}

function updateSalesforceContact($access_token, $instance_url, $contact_id, $contact_data) {
    $client = new Client();
    try {
        $response = $client->request('PATCH', "$instance_url/services/data/v52.0/sobjects/Contact/$contact_id", [
            'headers' => [
                'Authorization' => "Bearer $access_token",
                'Content-Type' => 'application/json',
            ],
            'body' => json_encode($contact_data),
        ]);
        return true;
    } catch (\GuzzleHttp\Exception\RequestException $e) {
        echo "Error updating Contact: " . $e->getResponse()->getBody()->getContents();
        return false;
    }
}

  function deleteAllOrderLineItems($access_token, $instance_url, $order_id) {
    $line_items = getOrderLineItems($access_token, $instance_url, $order_id);
    foreach ($line_items as $line_item) {
        $line_item_id = $line_item['Id'];
        $status = deleteOrderLineItem($access_token, $instance_url, $line_item_id);
        if ($status != 204) {
            echo "Failed to delete line item: $line_item_id\n";
        }
    }
}



function processAccount($access_token, $instance_url,$order) {
    
//     $fields = getAccountFields($access_token, $instance_url);

// if ($fields !== null) {
//     // Get all accounts with all fields
//     $accounts = getAllAccounts($access_token, $instance_url, $fields);
//     print_r($accounts);
// } else {
//     echo "Failed to retrieve fields for Account.\n";
// }

// die;
$name = $order['firstName'].' '.$order['lastName'];
   $accountSF= getAccountByEmail($access_token, $instance_url, $order['emailAddress'],$name);
  

   
    $account_data = [
    'Name' =>$name,
    'Email__c'=>$order['emailAddress'],
    'Phone' => $order['mobile'],
    'BillingStreet' =>$order['street'],
    'BillingCity' =>  $order['city'],
    'BillingState' =>$order['state'],
    'BillingPostalCode' => $order['postCode'],
    'BillingCountry' => $order['country'],

    'ShippingStreet' =>$order['street'],
    'ShippingCity' =>  $order['city'],
    'ShippingState' =>$order['state'],
    'ShippingPostalCode' => $order['postCode'],
    'ShippingCountry' => $order['country'],

    
   
    
    
    // Add other custom fields as necessary
];

  if(count($accountSF)>=1) {
      
      $accountSFID = $accountSF[0]['Id'];
      updateSalesforceAccount($access_token, $instance_url, $accountSFID, $account_data);
  }
  
  
else {
$account_result = createSalesforceAccount($access_token, $instance_url, $account_data);
$accountSFID = $account_result['id'];
}
return $accountSFID;

}

function processContact($access_token, $instance_url,$order,$accountId) {
    
        $salesforceContact = getCustomContacts($access_token, $instance_url,$order['emailAddress']); 
       $lastName =  $order['lastName'];
        if($order['lastName']=='') {
            $lastName = $order['firstName'];
        }
          
        $contact_data = [
    'FirstName' => $order['firstName'],
    'AccountId'=>$accountId,
    'LastName' => $lastName,
    'Phone' =>  $order['homePhone'],
    'MobilePhone' => $order['mobile'],
    'Email' =>  $order['emailAddress'],
    'MailingStreet' => $order['street'],
    'MailingCity' => $order['city'],
    'MailingState' => $order['state'],
    'MailingPostalCode' => $order['postCode'],
    'MailingCountry' =>$order['country'],
    // Add other custom fields as necessary
];


    if(count($salesforceContact)>=1) {
        $contact_id= $salesforceContact[0]['Id'];
        updateSalesforceContact($access_token, $instance_url, $contact_id, $contact_data);
        //getcontact detail
        
    }else {
        //create cotnact
      
$contact_result = createSalesforceContact($access_token, $instance_url, $contact_data);

$contact_id= ($contact_result['id']);

    }
 return $contact_id;
}
$orderParam = '';
  if (isset($_GET['order_id']) && $_GET['order_id'] > 0) {
      $orderParam = "  o.newSystemOrderID ='gid://shopify/Order/".$_GET['order_id']."'";
      
        $sql = "SELECT 
    o.orderID,
    o.newSystemOrderID,
    o.newSystemOrderNumber,
    o.newSystemCustomerID,
    o.newSystemCustomerEmail,
    o.order_created,
    o.order_completed,
    o.orderType,
    o.risk_level,
    o.shopify_recommendation,
    o.fullfillment_status,
    o.fullfillment_id,
    o.fullfillment_message,
    o.currency,
    o.order_total,
    o.order_subtotal,
    o.taxAmount,
    o.total_items,
    o.shipping_methods,
    o.shipping_country,
    o.payment_detail_title,
    o.internalPaymentType,
    o.payment_detail_status,
    o.note,
    o.coupon_code,
    o.coupon_amount,
    o.total_shipping,
    o.pending,
    o.ignoreRow,
    o.customerInsertCheck,
    o.statussync_from_shippit,
    o.refund_amount,
    o.refund_status,
    o.riskLevelLog,
    o.tokenProcessDate,
    o.tokenProcessCount,
    o.tokenIgnore,
    o.shopifyCursor,
    o.pendingOrderProcessTime,
    d.deliveryTradingName,
    d.deliveryFirstName,
    d.deliveryLastName,
    d.deliveryPhone,
    d.deliveryStreet,
    d.deliverySuburb,
    d.deliveryPostCode,
    d.deliveryCountry,
    d.deliveryCity,
    d.deliveryState,
    c.middleCustomerID,
    c.websiteID,
    c.emailAddress,
    c.firstName,
    c.lastName,
    c.tradingName,
    c.homePhone,
    c.mobile,
    c.street,
    c.city,
    c.postCode,
    c.state,
    c.country,
    c.middleEntryDate,
       o.salesforceID,
       o.store
FROM 
    newsystem_orders o
LEFT JOIN 
    newsystem_order_delivery d ON o.newSystemOrderID = d.newSystemOrderID
LEFT JOIN 
    newsystem_customers c ON o.newSystemCustomerID = c.newSystemMemberID
WHERE ".$orderParam."
      and o.store= '".$store."' 
LIMIT 15

";
  }
   elseif (isset($_GET['order']) && $_GET['order'] > 0) {
      $orderParam = "  o.newSystemOrderNumber ='".$_GET['order']."'";
      
     
  }
  else {
            $orderParam = " o.pendingProcess = 0";

     
  }

   $sql = "SELECT 
    o.orderID,
    o.newSystemOrderID,
    o.newSystemOrderNumber,
    o.newSystemCustomerID,
    o.newSystemCustomerEmail,
    o.order_created,
    o.order_completed,
    o.orderType,
    o.risk_level,
    o.shopify_recommendation,
    o.fullfillment_status,
    o.fullfillment_id,
    o.fullfillment_message,
    o.currency,
    o.order_total,
    o.order_subtotal,
    o.taxAmount,
    o.total_items,
    o.shipping_methods,
    o.shipping_country,
    o.payment_detail_title,
    o.internalPaymentType,
    o.payment_detail_status,
    o.note,
    o.coupon_code,
    o.coupon_amount,
    o.total_shipping,
    o.pending,
    o.ignoreRow,
    o.customerInsertCheck,
    o.statussync_from_shippit,
    o.refund_amount,
    o.refund_status,
    o.riskLevelLog,
    o.tokenProcessDate,
    o.tokenProcessCount,
    o.tokenIgnore,
    o.shopifyCursor,
    o.pendingOrderProcessTime,
    d.deliveryTradingName,
    d.deliveryFirstName,
    d.deliveryLastName,
    d.deliveryPhone,
    d.deliveryStreet,
    d.deliverySuburb,
    d.deliveryPostCode,
    d.deliveryCountry,
    d.deliveryCity,
    d.deliveryState,
    c.middleCustomerID,
    c.websiteID,
    c.emailAddress,
    c.firstName,
    c.lastName,
    c.tradingName,
    c.homePhone,
    c.mobile,
    c.street,
    c.city,
    c.postCode,
    c.state,
    c.country,
    c.middleEntryDate,
       o.salesforceID,
       o.store
FROM 
    newsystem_orders o
LEFT JOIN 
    newsystem_order_delivery d ON o.newSystemOrderID = d.newSystemOrderID
LEFT JOIN 
    newsystem_customers c ON o.newSystemCustomerID = c.newSystemMemberID
WHERE ".$orderParam."
      and o.store= '".$store."' 
LIMIT 15

";


echo $sql;
$orders = getDatafromSQL($sql);
foreach($orders as $order) {
    
    


    echo $order['newSystemOrderNumber'] .' processing<br>';
$accountSFID = processAccount($access_token, $instance_url,$order);

$Contact__c = processContact($access_token, $instance_url,$order,$accountSFID);

 
 $SFOrder = getSalesforceOrders($access_token, $instance_url,$order['newSystemOrderNumber']);



// Create a DateTime object from the input date
$date = new DateTime($order['order_created']);

// Format the date to the desired format
$formattedDate = $date->format('Y-m-d\TH:i:s.000+0000');




if(count($SFOrder)>=1){
    //update order
    echo 'UPDATE';
    $order_id = $SFOrder[0]['Id'];
     
$order_data = [
  'Phone__c'=>$order['deliveryPhone'],
  'Subtotal__c'=>$order['order_subtotal'], //Before Discount
  'Discount__c'=>$order['coupon_amount'],
  'Total__c'=>$order['order_total'],//After Discount + Tax
  'Tax__c'=>$order['taxAmount'],
  'Shopify_Created_date__c'=>$formattedDate,
  'Shipping_Name__c'=>$order['deliveryFirstName'].' '.$order['deliveryLastName'],
  'Shipping_Street__c'=>$order['deliveryStreet'],
  'Shipping_City__c'=>$order['deliveryCity'],
  'Shipping_State__c'=>$order['deliveryState'],
  'Shipping_Country__c'=>$order['deliveryCountry'],
  'Shipping_PIN_code__c'=>$order['deliveryPostCode'],
  'Billing_Name__c'=>$order['firstName'].' '.$order['lastName'],
  'Billing_Street__c'=>$order['street'],
  'Billing_City__c'=>$order['city'],
  'Billing_State__c'=>$order['state'],
  'Billing_Country__c'=>$order['country'],
  'Billing_PIN_code__c'=>$order['postCode'],
    // Add other required fields for Order__c
];

    updateSalesforceOrder($access_token, $instance_url, $order_id, $order_data);
    
}else {
     
$order_data = [
    'Name' => $order['newSystemOrderNumber'],
  'Contact__c'=>$Contact__c,
  'Order_Id__c'=> $order['newSystemOrderNumber'],
  'Phone__c'=>$order['deliveryPhone'],
  'Subtotal__c'=>$order['order_subtotal'], //Before Discount
  'Discount__c'=>$order['coupon_amount'],
  'Total__c'=>$order['order_total'],//After Discount + Tax
  'Tax__c'=>$order['taxAmount'],
  'Shopify_Created_date__c'=>$formattedDate,
  'Shipping_Name__c'=>$order['deliveryFirstName'].' '.$order['deliveryLastName'],
  'Shipping_Street__c'=>$order['deliveryStreet'],
  'Shipping_City__c'=>$order['deliveryCity'],
  'Shipping_State__c'=>$order['deliveryState'],
  'Shipping_Country__c'=>$order['deliveryCountry'],
  'Shipping_PIN_code__c'=>$order['deliveryPostCode'],
  'Billing_Name__c'=>$order['firstName'].' '.$order['lastName'],
  'Billing_Street__c'=>$order['street'],
  'Billing_City__c'=>$order['city'],
  'Billing_State__c'=>$order['state'],
  'Billing_Country__c'=>$order['country'],
  'Billing_PIN_code__c'=>$order['postCode'],
  'Notes__c'=>$store
    // Add other required fields for Order__c
];


    $order_result = createSalesforceOrder($access_token, $instance_url, $order_data);
$order_id = $order_result['id'];  // Capture the ID of the newly created Order__c
    
}


    $orderProducts = getDatas(TB_ORDERS_PRODUCT, array('newSystemOrderID'=>$order['newSystemOrderID']), '', "",false);
    
  
deleteAllOrderLineItems($access_token, $instance_url, $order_id);



    $order_line_items = array();
foreach($orderProducts as $product) {
    
    
    
   $productData =  processProduct($access_token, $instance_url,$product);
   $line_item=    [
       'Order__c' => $order_id,
        'Product__c' => $productData['PID'],  // Replace with actual field data
        'Quantity__c' => $product['quantity'],
        'Price__c' => $product['unitPrice'],
        // Add other required fields for OrderLineItem__c
    ];
      $line_item_result = createSalesforceOrderLineItem($access_token, $instance_url, $line_item);
    print_r($line_item_result);

    
}




foreach ($order_line_items as $line_item) {
   // $line_item_result = createSalesforceOrderLineItem($access_token, $instance_url, $line_item);
    print_r($line_item_result);
}

updateDatas(TB_ORDERS, array('salesforceID'=>$order_id,'pendingProcess'=>1), array('newSystemOrderNumber'=>$order['newSystemOrderNumber']), false);
}
die;
?>
