<?php 
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ERROR | E_WARNING | E_PARSE);

require 'vendor/autoload.php';
echo '<pre>';

include_once('config.php');


use GuzzleHttp\Client;


            


function authenticateSalesforce($client_id, $client_secret, $username, $password, $security_token) {
    $client = new Client();
    $response = $client->request('POST', 'https://login.salesforce.com/services/oauth2/token', [
        'form_params' => [
            'grant_type' => 'password',
            'client_id' => $client_id,
            'client_secret' => $client_secret,
            'username' => $username,
            'password' => $password . $security_token,
        ],
    ]);

    $data = json_decode($response->getBody(), true);
    return $data['access_token'];
}

function createSalesforceOrder($access_token, $instance_url, $order_data) {
    $client = new Client();
    try {
        $response = $client->request('POST', "$instance_url/services/data/v52.0/sobjects/Order__c", [
            'headers' => [
                'Authorization' => "Bearer $access_token",
                'Content-Type' => 'application/json',
            ],
            'body' => json_encode($order_data),
        ]);
        $data = json_decode($response->getBody(), true);
        return $data;
    } catch (\GuzzleHttp\Exception\RequestException $e) {
        echo "Error creating Order__c: " . $e->getResponse()->getBody()->getContents();
        return null;
    }
}
function createSalesforceOrderLineItem($access_token, $instance_url, $line_item_data) {
    $client = new Client();
    $response = $client->request('POST', "$instance_url/services/data/v52.0/sobjects/Order_Line_Item__c", [
        'headers' => [
            'Authorization' => "Bearer $access_token",
            'Content-Type' => 'application/json',
        ],
        'body' => json_encode($line_item_data),
    ]);

    $data = json_decode($response->getBody(), true);
    return $data;
}


$access_token = authenticateSalesforce(SF_CLIENT_ID, SF_CLIENT_SECRET, SF_USERNAME, SF_PASSWORD, SECURITY_TOKEN);
$instance_url = 'https://thgenesis.my.salesforce.com';


function getSalesforceOrders($access_token, $instance_url) {
    $client = new Client();
    try {
        $response = $client->request('GET', "$instance_url/services/data/v52.0/query", [
            'headers' => [
                'Authorization' => "Bearer $access_token",
                'Content-Type' => 'application/json',
            ],
            'query' => [
                'q' => "SELECT Id, Name, Contact__c FROM Order__c WHERE Order_Id__c = 'SRI#23519'"  // Adjust the fields as necessary
            ]
        ]);

        $data = json_decode($response->getBody(), true);
        return $data['records'];
    } catch (\GuzzleHttp\Exception\RequestException $e) {
        echo "Error retrieving Order__c records: " . $e->getResponse()->getBody()->getContents();
        return null;
    }
}



// $order_records = getSalesforceOrders($access_token, $instance_url);
// print_r($order_records);
// die;

function getCustomContacts($access_token, $instance_url) {
    $client = new Client();
    try {
        $response = $client->request('GET', "$instance_url/services/data/v52.0/query", [
            'headers' => [
                'Authorization' => "Bearer $access_token",
                'Content-Type' => 'application/json',
            ],
            'query' => [
                'q' => "SELECT Id, Phone, MobilePhone, FirstName, MiddleName, LastName, Email, MailingStreet, MailingCity, MailingState, MailingPostalCode, MailingCountry,HomePhone FROM Contact WHERE Email = 'tracee.jankoviak@gmail.com'"  // Adjust the fields as necessary
            ]
        ]);

        $data = json_decode($response->getBody(), true);
        return $data['records'];
    } catch (\GuzzleHttp\Exception\RequestException $e) {
        echo "Error retrieving Order__c records: " . $e->getResponse()->getBody()->getContents();
        return null;
    }
}

// $custom_contacts = getCustomContacts($access_token, $instance_url);
// print_r($custom_contacts);
// die;


function getProduct2Fields($access_token, $instance_url) {
    $client = new Client();
    try {
        $response = $client->request('GET', "$instance_url/services/data/v52.0/sobjects/Product2/describe", [
            'headers' => [
                'Authorization' => "Bearer $access_token",
                'Content-Type' => 'application/json',
            ]
        ]);

        $data = json_decode($response->getBody(), true);
        $fields = array_map(function($field) {
            return $field['name'];
        }, $data['fields']);
        return $fields;
    } catch (\GuzzleHttp\Exception\RequestException $e) {
        echo "Error describing Product2 object: " . $e->getResponse()->getBody()->getContents();
        return null;
    }
}


function getAllProducts($access_token, $instance_url, $fields) {
    $client = new Client();
    try {
        $response = $client->request('GET', "$instance_url/services/data/v52.0/query", [
            'headers' => [
                'Authorization' => "Bearer $access_token",
                'Content-Type' => 'application/json',
            ],
            'query' => [
                'q' => "SELECT " . implode(',', $fields) . " FROM Product2"
            ]
        ]);

        $data = json_decode($response->getBody(), true);
        return $data['records'];
    } catch (\GuzzleHttp\Exception\RequestException $e) {
        echo "Error retrieving Product2 records: " . $e->getResponse()->getBody()->getContents();
        return null;
    }
}


$fields = getProduct2Fields($access_token, $instance_url);

// if ($fields !== null) {
//     // Get all products with all fields
//     $products = getAllProducts($access_token, $instance_url, $fields);
//     print_r($products);
// }

// die;



$sql = "SELECT 
    o.orderID,
    o.newSystemOrderID,
    o.newSystemOrderNumber,
    o.newSystemCustomerID,
    o.newSystemCustomerEmail,
    o.order_created,
    o.order_completed,
    o.orderType,
    o.risk_level,
    o.shopify_recommendation,
    o.fullfillment_status,
    o.fullfillment_id,
    o.fullfillment_message,
    o.currency,
    o.order_total,
    o.order_subtotal,
    o.taxAmount,
    o.total_items,
    o.shipping_methods,
    o.shipping_country,
    o.payment_detail_title,
    o.internalPaymentType,
    o.payment_detail_status,
    o.note,
    o.coupon_code,
    o.coupon_amount,
    o.total_shipping,
    o.pending,
    o.ignoreRow,
    o.customerInsertCheck,
    o.statussync_from_shippit,
    o.refund_amount,
    o.refund_status,
    o.riskLevelLog,
    o.tokenProcessDate,
    o.tokenProcessCount,
    o.tokenIgnore,
    o.shopifyCursor,
    o.pendingOrderProcessTime,
    d.deliveryTradingName,
    d.deliveryFirstName,
    d.deliveryLastName,
    d.deliveryPhone,
    d.deliveryStreet,
    d.deliverySuburb,
    d.deliveryPostCode,
    d.deliveryCountry,
    d.deliveryCity,
    d.deliveryState,
    c.middleCustomerID,
    c.websiteID,
    c.emailAddress,
    c.firstName,
    c.lastName,
    c.tradingName,
    c.homePhone,
    c.mobile,
    c.street,
    c.city,
    c.postCode,
    c.state,
    c.country,
    c.middleEntryDate,
    c.lastCheckDate,
    c.salesforceID
FROM 
    newsystem_orders o
LEFT JOIN 
    newsystem_order_delivery d ON o.newSystemOrderID = d.newSystemOrderID
LEFT JOIN 
    newsystem_customers c ON o.newSystemCustomerID = c.newSystemMemberID
WHERE 
    c.salesforceID = ''
LIMIT 5;
;
";
$orders = getDatafromSQL($sql);
foreach($orders as $order) {
    
    print_r($order);
}
die;

$order_data = [
    'Name' => 'ShopifyID',
  'Contact__c'=>'0034x00001ie2cwAAA',
  'Order_Id__c'=>'ShopifyID',
  'Phone__c'=>'',
  'Subtotal__c'=>'', //Before Discount
  'Discount__c'=>'',
  'Total__c'=>'',//After Discount + Tax
  'Tax__c'=>'',
  'Shopify_Created_date__c'=>'',
  'Shipping_Name__c'=>'',
  'Shipping_Street__c'=>'',
  'Shipping_City__c'=>'',
  'Shipping_State__c'=>'',
  'Shipping_Country__c'=>'',
  'Shipping_PIN_code__c'=>'',
  'Billing_Name__c'=>'',
  'Billing_Street__c'=>'',
  'Billing_City__c'=>'',
  'Billing_State__c'=>'',
  'Billing_Country__c'=>'',
  'Billing_PIN_code__c'=>'',
    // Add other required fields for Order__c
];

$order_result = createSalesforceOrder($access_token, $instance_url, $order_data);
$order_id = $order_result['id'];  // Capture the ID of the newly created Order__c

// Now create OrderLineItem__c records
$order_line_items = [
    [ 'Name'=>'Product Name',
        'Order__c' => $order_id,
        'Product__c' => '01tRM000004VcrYYAS',  // Replace with actual field data
        'Quantity__c' => 2,
        'Price__c' => 100.00,
        // Add other required fields for OrderLineItem__c
    ],
    [
        'Name'=>'Product Name',
        'Order__c' => $order_id,
        'Product__c' => '01tRM000004VdMBYA0',  // Replace with actual field data
        'Quantity__c' => 1,
        'Price__c' => 200.00,
        // Add other required fields for OrderLineItem__c
    ],
];

foreach ($order_line_items as $line_item) {
    $line_item_result = createSalesforceOrderLineItem($access_token, $instance_url, $line_item);
    print_r($line_item_result);
}


?>
