<?php 
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ERROR | E_WARNING | E_PARSE);



include_once('config.php');




//weekly product refund

$startDate = $_GET['startDate']; // Replace with dynamic value
$endDate = $_GET['endDate'];   // Replace with dynamic value
$stores = "'SRI', 'PSC'";  // Replace with dynamic values or user input

if(isset($_GET['stores']) && $_GET['stores']!='') {
    $stores = wrapElementsInQuotes($_GET['stores']);  
}


// Fetch all necessary data in a single query
$sql = "
    SELECT 
        wd.startDate, wd.endDate, 
        nsp.stockCode, 
        SUM(sr.Amount_Return_Request__c) as Total_Amount
    FROM weekly_dates wd
    LEFT JOIN salesforce_refunds sr 
        ON sr.Refunded_Date__c BETWEEN wd.startDate AND wd.endDate 
        AND sr.Brand__c IN ($stores)
    LEFT JOIN newsystem_orders no 
        ON sr.Order__c = no.salesforceID
    LEFT JOIN newsystem_orders_product nsp 
        ON no.newSystemOrderID = nsp.newSystemOrderID
    WHERE 
        '$startDate' BETWEEN wd.startDate AND wd.endDate 
        OR '$endDate' BETWEEN wd.startDate AND wd.endDate 
        OR wd.startDate BETWEEN '$startDate' AND '$endDate'
        OR wd.endDate BETWEEN '$startDate' AND '$endDate'
    GROUP BY wd.startDate, wd.endDate, nsp.stockCode
    ORDER BY wd.startDate DESC
";

$data = getDatafromSQL($sql);

$finalArray = array();
$refundReasons = array();  // To track all unique refund reasons
$weekRanges = array();

// Process the fetched data
foreach ($data as $row) {
    $startDate = $row['startDate'];
    $endDate = $row['endDate'];
    $stockCode = $row['stockCode'];
    if($row['stockCode']=='') {
        $stockCode ='Not Available';
    }
    $totalAmount = $row['Total_Amount'];

    $weekRange = "$startDate to $endDate";

    if (!in_array($weekRange, $weekRanges)) {
        $weekRanges[] = $weekRange;
    }

    if (!isset($refundReasons[$stockCode])) {
        $refundReasons[$stockCode] = array();
    }

    $refundReasons[$stockCode][$weekRange] = $totalAmount;
}

// Initialize the final array with all refund reasons and set default values for each week
foreach ($refundReasons as $stockCode => $amounts) {
    
     
    $entry = array("Product" => $stockCode);
    
    foreach ($weekRanges as $weekRange) {
        if (!isset($refundReasons[$stockCode][$weekRange])) {
            $refundReasons[$stockCode][$weekRange] = 0;
        }
        
        $entry[$weekRange] = $refundReasons[$stockCode][$weekRange];
    }
    
    $finalArray[] = $entry;
}

echo json_encode($finalArray, JSON_PRETTY_PRINT);
?>
