<?php 
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ERROR | E_WARNING | E_PARSE);



include_once('config.php');




//weekly product refund

$startDate = $_GET['startDate']; // Replace with dynamic value
$endDate = $_GET['endDate'];   // Replace with dynamic value
$stores = "'SRI', 'PSC'";  // Replace with dynamic values or user input

if(isset($_GET['stores']) && $_GET['stores']!='') {
    $stores = wrapElementsInQuotes($_GET['stores']);  
}

$sql = "
    SELECT 
        w.startDate, 
        w.endDate, 
        sr.Reason_for_Refund__c, 
        SUM(sr.Amount_Return_Request__c) as Total_Amount
    FROM 
        weekly_dates w
    LEFT JOIN 
        salesforce_refunds sr 
    ON 
        sr.Refunded_Date__c BETWEEN w.startDate AND w.endDate
    WHERE 
        ('$startDate' BETWEEN w.startDate AND w.endDate 
        OR '$endDate' BETWEEN w.startDate AND w.endDate 
        OR w.startDate BETWEEN '$startDate' AND '$endDate' 
        OR w.endDate BETWEEN '$startDate' AND '$endDate')
        AND sr.Brand__c IN ($stores)
    GROUP BY 
        w.startDate, 
        w.endDate, 
        sr.Reason_for_Refund__c
    ORDER BY 
        w.startDate DESC";

// Fetch the data
$weekData = getDatafromSQL($sql);

// Process the fetched data
$refundReasons = array();
foreach ($weekData as $data) {
    $startDate = $data['startDate'];
    $endDate = $data['endDate'];
    $reason = $data['Reason_for_Refund__c'];
    $totalAmount = $data['Total_Amount'];
    
    if (!isset($refundReasons[$reason])) {
        $refundReasons[$reason] = array();
    }
    
    $weekRange = "$startDate to $endDate";
    $refundReasons[$reason][$weekRange] = $totalAmount;
}

// Initialize the final array with all refund reasons and set default values for each week
$finalArray = array();
foreach ($refundReasons as $reason => $amounts) {
    $entry = array("RefundReason" => $reason);
    
    foreach ($weekData as $data) {
        $weekRange = $data['startDate'] . " to " . $data['endDate'];
        if (!isset($refundReasons[$reason][$weekRange])) {
            $refundReasons[$reason][$weekRange] = 0;
        }
        $entry[$weekRange] = $refundReasons[$reason][$weekRange];
    }
    
    $finalArray[] = $entry;
}

echo json_encode($finalArray, JSON_PRETTY_PRINT);
?>


