<?php 
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ERROR | E_WARNING | E_PARSE);

require 'vendor/autoload.php';
echo '<pre>';

include_once('config.php');



use GuzzleHttp\Client;
use Shopify\PuplicApp;
use rdx\graphqlquery\Query;


  $access_token = authenticateSalesforce(SF_CLIENT_ID, SF_CLIENT_SECRET, SF_USERNAME, SF_PASSWORD, SECURITY_TOKEN);
$instance_url = 'https://thgenesis.my.salesforce.com';
    function check_sf_order($sfid,$name)
  {
    global $ci_connection;
    $sql = "select count(*) as total from salesforce_refunds where Order__c = '" . $sfid . "' and Name='".$name."'";
    $result = mysqli_query($ci_connection, $sql);
    $row = mysqli_fetch_array($result, MYSQLI_ASSOC);
    // $row=mysqli_fetch_array($result);


    return ($row['total']);
  }




  function authenticateSalesforce($client_id, $client_secret, $username, $password, $security_token) {
    $client = new Client();
    $response = $client->request('POST', 'https://login.salesforce.com/services/oauth2/token', [
        'form_params' => [
            'grant_type' => 'password',
            'client_id' => $client_id,
            'client_secret' => $client_secret,
            'username' => $username,
            'password' => $password . $security_token,
        ],
    ]);

    $data = json_decode($response->getBody(), true);
    return $data['access_token'];
}


 function getSalesforceRefunds($access_token, $instance_url) {
     
     
     $nextUrl = getDatafromSQL("SELECT saleforceNextUrl FROM `salesforce_refunds_next`");
     if(count($nextUrl)>0 && $nextUrl[0]['saleforceNextUrl']!='')  {
          $instance_url = "$instance_url".$nextUrl[0]['saleforceNextUrl'];
         
     }else {
           $instance_url = "$instance_url/services/data/v52.0/query";

     }
    


     
    $client = new Client();
    try {
        $response = $client->request('GET', $instance_url, [
            'headers' => [
                'Authorization' => "Bearer $access_token",
                'Content-Type' => 'application/json',
            ],
            'query' => [
                'q' => "SELECT Case__c,Order__c,Name,Refund_Type__c,Order_Date__c,Amount__c,Total_Order_Price__c,Amount_Return_Request__c,Returned_to__c,Refunded_Sales_Tax_Amount__c,Cart_Number__c,Brand__c,Refunded_Date__c,Amount_Requested__c,Product_Refunded__c,Reason_for_Refund__c,Quantity__c,Approval_Code__c,Notes__c,Initial_Contact_Date__c FROM Refund__c"  // Adjust the fields as necessary
            ]
        ]);

        $data = json_decode($response->getBody(), true);
        return array('records'=>$data['records'],'nextRecordsUrl'=>$data['nextRecordsUrl']);
    } catch (\GuzzleHttp\Exception\RequestException $e) {
          updateDatas('salesforce_refunds_next',array('saleforceNextUrl'=>''));

        echo "Error retrieving Order__c records: " . $e->getResponse()->getBody()->getContents();
        return null;
    }
}

$refunds = getSalesforceRefunds($access_token,$instance_url);




foreach($refunds['records'] as $refund) {
      $cartNUmber = $refund['Cart_Number__c'];
    if($refund['Cart_Number__c']==''){
        $cartNUmber = $refund['Brand__c'];
    }
    
       
  $createArray = array(
    'Case__c' => $refund['Case__c'],
    'Order__c' => $refund['Order__c'],
    'Name' => $refund['Name'],
    'Refund_Type__c' => $refund['Refund_Type__c'],
    'Order_Date__c' => date('Y-m-d H:i:s',strtotime($refund['Order_Date__c'])),
    'Amount__c' => $refund['Amount__c'],
    'Total_Order_Price__c' => $refund['Total_Order_Price__c'],
    'Amount_Return_Request__c' => $refund['Amount_Return_Request__c'] === '' ? '0' : $refund['Amount_Return_Request__c'],
    'Returned_to__c' => $refund['Returned_to__c'],
    'Refunded_Sales_Tax_Amount__c' => (empty(trim($refund['Refunded_Sales_Tax_Amount__c'])) || $refund['Refunded_Sales_Tax_Amount__c']===null) ? '0' : $refund['Refunded_Sales_Tax_Amount__c'],
    'Brand__c' => $refund['Brand__c'],
    'Cart_Number__c' => $cartNUmber,
   
    'Amount_Requested__c' => $refund['Amount_Requested__c'],
    'Product_Refunded__c' => addslashes($refund['Product_Refunded__c']),
    'Reason_for_Refund__c' => addslashes($refund['Reason_for_Refund__c']),
    'Quantity__c' => (int)$refund['Quantity__c'],
    'Approval_Code__c' => $refund['Approval_Code__c'],
    'Notes__c' => addslashes($refund['Notes__c'])
);


 $refdate = array();
if ($refund['Refunded_Date__c'] != '') {
    $refundDate = date('Y-m-d', strtotime($refund['Refunded_Date__c']));
    $refdate = array('Refunded_Date__c' => $refundDate);
}

$cAdate = array();
if ($refund['Initial_Contact_Date__c'] != '') {
    $initialContact = date('Y-m-d', strtotime($refund['Initial_Contact_Date__c']));
    $cAdate = array('Initial_Contact_Date__c' => $initialContact);
}

// Merge $refdate and $cAdate into $createArray
$createArray = array_merge($createArray, $refdate, $cAdate);
 



      if (check_sf_order($refund['Order__c'],$refund['Name']) > 0) {

            updateDatas('salesforce_refunds',$createArray, array('Order__c'=>$refund['Order__c'],'Name'=>$refund['Name']), false);


        echo $refund['Name'] . 'Already Exists and updated<br>';}
        else {
               echo $refund['Name'] . 'Created<br>';
            createDatas('salesforce_refunds',$createArray);
        }

}
if($refunds['nextRecordsUrl']!='') {

  updateDatas('salesforce_refunds_next',array('saleforceNextUrl'=>$refunds['nextRecordsUrl']));
}else {
    
    echo 'No Data Left';
}
