<?php
require 'vendor/autoload.php';

use GuzzleHttp\Client;

// Salesforce credentials
$clientId = 'YOUR_CONSUMER_KEY';
$clientSecret = 'YOUR_CONSUMER_SECRET';
$username = 'YOUR_SALESFORCE_USERNAME';
$password = 'YOUR_SALESFORCE_PASSWORD';
$securityToken = 'YOUR_SALESFORCE_SECURITY_TOKEN';

// Salesforce token URL
$tokenUrl = 'https://login.salesforce.com/services/oauth2/token';

// Create a new HTTP client
$client = new Client();

// Request access token
try {
    $response = $client->request('POST', $tokenUrl, [
        'form_params' => [
            'grant_type' => 'password',
            'client_id' => $clientId,
            'client_secret' => $clientSecret,
            'username' => $username,
            'password' => $password . $securityToken,
        ]
    ]);

    // Decode the JSON response
    $data = json_decode($response->getBody(), true);

    // Extract access token
    $accessToken = $data['access_token'];
    $instanceUrl = $data['instance_url'];

    echo "Access Token: " . $accessToken . "\n";
    echo "Instance URL: " . $instanceUrl . "\n";

    // Create a new account
    $accountData = [
        'Name' => 'Sample Account Name',   // Set the name of the account
        'Phone' => '123-456-7890',         // Set the phone number of the account
        'Website' => 'https://example.com' // Set the website of the account
    ];

    $response = $client->request('POST', $instanceUrl . '/services/data/v56.0/sobjects/Account/', [
        'headers' => [
            'Authorization' => 'Bearer ' . $accessToken,
            'Content-Type' => 'application/json'
        ],
        'body' => json_encode($accountData)
    ]);

    // Decode the JSON response
    $accountResponse = json_decode($response->getBody(), true);

    if (isset($accountResponse['id'])) {
        echo "Account Created Successfully. Account ID: " . $accountResponse['id'] . "\n";
    } else {
        echo "Failed to create account.\n";
        print_r($accountResponse);
    }

} catch (Exception $e) {
    echo 'Error: ' . $e->getMessage();
}
?>
