<?php
require 'vendor/autoload.php';

use GuzzleHttp\Client;

// Salesforce credentials
$clientId = 'YOUR_CONSUMER_KEY';
$clientSecret = 'YOUR_CONSUMER_SECRET';
$username = 'YOUR_SALESFORCE_USERNAME';
$password = 'YOUR_SALESFORCE_PASSWORD';
$securityToken = 'YOUR_SALESFORCE_SECURITY_TOKEN';

// Salesforce token URL
$tokenUrl = 'https://login.salesforce.com/services/oauth2/token';

// Create a new HTTP client
$client = new Client();

// Request access token
try {
    $response = $client->request('POST', $tokenUrl, [
        'form_params' => [
            'grant_type' => 'password',
            'client_id' => $clientId,
            'client_secret' => $clientSecret,
            'username' => $username,
            'password' => $password . $securityToken,
        ]
    ]);

    // Decode the JSON response
    $data = json_decode($response->getBody(), true);

    // Extract access token
    $accessToken = $data['access_token'];
    $instanceUrl = $data['instance_url'];

    echo "Access Token: " . $accessToken . "\n";
    echo "Instance URL: " . $instanceUrl . "\n";

    // Create a new order
    $orderData = [
        'AccountId' => 'YOUR_ACCOUNT_ID', // Replace with a valid Account ID from your Salesforce org
        'EffectiveDate' => '2023-12-31',  // Set the effective date of the order
        'Status' => 'Draft',               // Initial status of the order
        'ContractId' => 'YOUR_CONTRACT_ID' // Replace with a valid Contract ID if required
    ];

    $response = $client->request('POST', $instanceUrl . '/services/data/v56.0/sobjects/Order/', [
        'headers' => [
            'Authorization' => 'Bearer ' . $accessToken,
            'Content-Type' => 'application/json'
        ],
        'body' => json_encode($orderData)
    ]);

    // Decode the JSON response
    $orderResponse = json_decode($response->getBody(), true);

    if (isset($orderResponse['id'])) {
        echo "Order Created Successfully. Order ID: " . $orderResponse['id'] . "\n";
    } else {
        echo "Failed to create order.\n";
        print_r($orderResponse);
    }

} catch (Exception $e) {
    echo 'Error: ' . $e->getMessage();
}
?>
