<?php 
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ERROR | E_WARNING | E_PARSE);

require 'vendor/autoload.php';
echo '<pre>';

include_once('config.php');


use GuzzleHttp\Client;



// Create a new HTTP client
$client = new Client();

// Request access token
try { 
    $response = $client->request('POST', TOKEN_URL, [
        'form_params' => [
            'grant_type' => 'password',
            'client_id' => SF_CLIENT_ID,
            'client_secret' => SF_CLIENT_SECRET,
            'username' => SF_USERNAME,
            'password' => SF_PASSWORD . SECURITY_TOKEN,
        ]
    ]);


    // Decode the JSON response
    $data = json_decode($response->getBody(), true);

    // Extract access token
    $accessToken = $data['access_token'];
    $instanceUrl = $data['instance_url'];

    echo "Access Token: " . $accessToken . "\n";
    echo "Instance URL: " . $instanceUrl . "\n";

    // Composite request to create order and order line items
    $compositeRequest = [
        'compositeRequest' => [
            [
                'method' => 'POST',
                'url' => '/services/data/v56.0/sobjects/Order',
                'referenceId' => 'NewOrder',
                'body' => [
                    'AccountId' => '001RM00000BEhzgYAD', // Replace with a valid Account ID from your Salesforce org
                    'EffectiveDate' => '2024-06-05',  // Set the effective date of the order
                    'Status' => 'Draft'    , //Activated
                  'Pricebook2Id' => '01s4x000006v7duAAA',
                    'Description' => 'This is a test order', // Optional: description of the order
                    'HIC_ShopifySync__Shopify_Id__c'=>'SIDs',
                    'HIC_ShopifySync__Total_Tax__c'=>'18',
                    'HIC_ShopifySync__Store__c'=>'SRI',
                    'HIC_ShopifySync__order_status_url__c'=>'ORder URL',
                    'HIC_ShopifySync__Currency__c'=>'USD',
                    'HIC_ShopifySync__Total_Price__c'=>'418',
                    'HIC_ShopifySync__Created_At__c'=>'2024-06-05T12:00:00.000Z',
                    'HIC_ShopifySync__Total_Discount__c'=>'70',
                    'HIC_ShopifySync__Payment_Status__c'=>'paid',//payment status
                    'HIC_ShopifySync__Shipping_Price__c'=>'0',
                    'HIC_ShopifySync__Billing_Customer_Name__c'=>'Customer Name',
                    'Type' => 'Standard', // Type of the order (custom field, if applicable)
                    'BillingStreet' => '123 Main St',
                    'BillingCity' => 'San Francisco',
                    'BillingState' => 'CA',
                    'BillingPostalCode' => '94105',
                    'BillingCountry' => 'USA',
                    'ShippingStreet' => '456 Secondary St',
                    'ShippingCity' => 'San Francisco',
                    'ShippingState' => 'CA',
                    'ShippingPostalCode' => '94105',
                    'ShippingCountry' => 'USA'
// Initial status of the order
                   // 'ContractId' => '' // Replace with a valid Contract ID if required
                ]
            ],
            [
                'method' => 'POST',
                'url' => '/services/data/v56.0/sobjects/OrderItem',
                'referenceId' => 'NewOrderItem1',
                'body' => [
                    'OrderId' => '@{NewOrder.id}',
                    'Product2Id' => '01tRM000004VcrYYAS', // Replace with a valid Product ID from your Salesforce org
                    'Quantity' => 1,
                    'UnitPrice' => 100.00,
                    'PricebookEntryId' => '01uRM000000gU4wYAE' // Replace with a valid PricebookEntry ID from your Salesforce org
                ]
            ],
            [
                'method' => 'POST',
                'url' => '/services/data/v56.0/sobjects/OrderItem',
                'referenceId' => 'NewOrderItem2',
                'body' => [
                    'OrderId' => '@{NewOrder.id}',
                    'Product2Id' => '01tRM000004VdMBYA0', // Replace with a valid Product ID from your Salesforce org
                    'Quantity' => 2,
                    'UnitPrice' => 150.00,
                    'PricebookEntryId' => '01uRM000000gUw9YAE' 
                ]
            ]
        ]
    ];

    $response = $client->request('POST', $instanceUrl . '/services/data/v56.0/composite', [
        'headers' => [
            'Authorization' => 'Bearer ' . $accessToken,
            'Content-Type' => 'application/json'
        ],
        'body' => json_encode($compositeRequest)
    ]);

    $compositeResponse = json_decode($response->getBody(), true);

    if (isset($compositeResponse['compositeResponse'])) {
        foreach ($compositeResponse['compositeResponse'] as $response) {
            if ($response['httpStatusCode'] == 201) {
                echo $response['referenceId'] . " Created Successfully. ID: " . $response['body']['id'] . "\n";
            } else {
                echo "Failed to create " . $response['referenceId'] . "\n";
                print_r($response);
            }
        }
    } else {
        echo "Composite request failed.\n";
        print_r($compositeResponse);
    }

} catch (Exception $e) {
    echo 'Error: ' . $e->getMessage();
}
?>
