<?php 
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ERROR | E_WARNING | E_PARSE);

require 'vendor/autoload.php';
echo '<pre>';

include_once('config.php');


use GuzzleHttp\Client;


// Salesforce token URL
$tokenUrl = 'https://login.salesforce.com/services/oauth2/token';

// Create a new HTTP client
$client = new Client();

// Request access token
try {
    $response = $client->request('POST', $tokenUrl, [
        'form_params' => [
            'grant_type' => 'password',
            'client_id' => $clientId,
            'client_secret' => $clientSecret,
            'username' => $username,
            'password' => $password . $securityToken,
        ]
    ]);

    // Decode the JSON response
    $data = json_decode($response->getBody(), true);

    // Extract access token
    $accessToken = $data['access_token'];
    $instanceUrl = $data['instance_url'];

    echo "Access Token: " . $accessToken . "\n";
    echo "Instance URL: " . $instanceUrl . "\n";

    // Create a new product
    $productData = [
        'Name' => 'Sample Product',          // Set the name of the product
        'ProductCode' => 'SP001',            // Set the product code
        'Description' => 'Sample Product Description'
    ];

    $response = $client->request('POST', $instanceUrl . '/services/data/v56.0/sobjects/Product2/', [
        'headers' => [
            'Authorization' => 'Bearer ' . $accessToken,
            'Content-Type' => 'application/json'
        ],
        'body' => json_encode($productData)
    ]);

    // Decode the JSON response
    $productResponse = json_decode($response->getBody(), true);

    if (isset($productResponse['id'])) {
        $productId = $productResponse['id'];
        echo "Product Created Successfully. Product ID: " . $productId . "\n";

        // Create product variants
        $variants = [
            [
                'Name' => 'Sample Product - Variant 1',
                'ProductCode' => 'SP001-V1',
                'Description' => 'Sample Product Variant 1 Description',
                'Product2Id' => $productId,
                'UnitPrice' => 100.00,
                'Pricebook2Id' => 'YOUR_STANDARD_PRICEBOOK_ID' // Replace with the ID of your Standard Price Book
            ],
            [
                'Name' => 'Sample Product - Variant 2',
                'ProductCode' => 'SP001-V2',
                'Description' => 'Sample Product Variant 2 Description',
                'Product2Id' => $productId,
                'UnitPrice' => 120.00,
                'Pricebook2Id' => 'YOUR_STANDARD_PRICEBOOK_ID' // Replace with the ID of your Standard Price Book
            ]
        ];

        foreach ($variants as $variant) {
            // Create PricebookEntry for each variant
            $pricebookEntryData = [
                'Product2Id' => $productId,
                'UnitPrice' => $variant['UnitPrice'],
                'Pricebook2Id' => $variant['Pricebook2Id'],
                'IsActive' => true
            ];

            $response = $client->request('POST', $instanceUrl . '/services/data/v56.0/sobjects/PricebookEntry/', [
                'headers' => [
                    'Authorization' => 'Bearer ' . $accessToken,
                    'Content-Type' => 'application/json'
                ],
                'body' => json_encode($pricebookEntryData)
            ]);

            $pricebookEntryResponse = json_decode($response->getBody(), true);

            if (isset($pricebookEntryResponse['id'])) {
                echo "Pricebook Entry Created Successfully for Variant. Pricebook Entry ID: " . $pricebookEntryResponse['id'] . "\n";
            } else {
                echo "Failed to create Pricebook Entry for Variant.\n";
                print_r($pricebookEntryResponse);
            }
        }

    } else {
        echo "Failed to create product.\n";
        print_r($productResponse);
    }

} catch (Exception $e) {
    echo 'Error: ' . $e->getMessage();
}
?>
