<?php
require 'vendor/autoload.php';

use GuzzleHttp\Client;

// Salesforce credentials
$clientId = 'YOUR_CONSUMER_KEY';
$clientSecret = 'YOUR_CONSUMER_SECRET';
$username = 'YOUR_SALESFORCE_USERNAME';
$password = 'YOUR_SALESFORCE_PASSWORD';
$securityToken = 'YOUR_SALESFORCE_SECURITY_TOKEN';

// Salesforce token URL
$tokenUrl = 'https://login.salesforce.com/services/oauth2/token';

// Create a new HTTP client
$client = new Client();

// Request access token
try {
    $response = $client->request('POST', $tokenUrl, [
        'form_params' => [
            'grant_type' => 'password',
            'client_id' => $clientId,
            'client_secret' => $clientSecret,
            'username' => $username,
            'password' => $password . $securityToken,
        ]
    ]);

    // Decode the JSON response
    $data = json_decode($response->getBody(), true);

    // Extract access token
    $accessToken = $data['access_token'];
    $instanceUrl = $data['instance_url'];

    echo "Access Token: " . $accessToken . "\n";
    echo "Instance URL: " . $instanceUrl . "\n";

    // Create a new product
    $productData = [
        'Name' => 'Sample Product',          // Set the name of the product
        'ProductCode' => 'SP001',            // Set the product code
        'Description' => 'Sample Product Description'
    ];

    $response = $client->request('POST', $instanceUrl . '/services/data/v56.0/sobjects/Product2/', [
        'headers' => [
            'Authorization' => 'Bearer ' . $accessToken,
            'Content-Type' => 'application/json'
        ],
        'body' => json_encode($productData)
    ]);

    // Decode the JSON response
    $productResponse = json_decode($response->getBody(), true);

    if (isset($productResponse['id'])) {
        $productId = $productResponse['id'];
        echo "Product Created Successfully. Product ID: " . $productId . "\n";

        // Create a PricebookEntry for the product
        $pricebookEntryData = [
            'Product2Id' => $productId,
            'UnitPrice' => 100.00, // Set the price of the product
            'Pricebook2Id' => 'YOUR_STANDARD_PRICEBOOK_ID', // Replace with the ID of your Standard Price Book
            'IsActive' => true
        ];

        $response = $client->request('POST', $instanceUrl . '/services/data/v56.0/sobjects/PricebookEntry/', [
            'headers' => [
                'Authorization' => 'Bearer ' . $accessToken,
                'Content-Type' => 'application/json'
            ],
            'body' => json_encode($pricebookEntryData)
        ]);

        $pricebookEntryResponse = json_decode($response->getBody(), true);

        if (isset($pricebookEntryResponse['id'])) {
            echo "Pricebook Entry Created Successfully. Pricebook Entry ID: " . $pricebookEntryResponse['id'] . "\n";
        } else {
            echo "Failed to create Pricebook Entry.\n";
            print_r($pricebookEntryResponse);
        }

    } else {
        echo "Failed to create product.\n";
        print_r($productResponse);
    }

} catch (Exception $e) {
    echo 'Error: ' . $e->getMessage();
}
?>
