<!DOCTYPE html>
<html>
<head>
    <title>Refunds Dashboard</title>
    
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>

<link rel="stylesheet" href="https://code.jquery.com/ui/1.12.1/themes/base/jquery-ui.css">
<script src="https://code.jquery.com/ui/1.12.1/jquery-ui.js"></script>



  


       <script src="https://cdnjs.cloudflare.com/ajax/libs/babel-polyfill/7.4.0/polyfill.min.js"></script>
   <style>
   #gridContainer sup {
  font-size: 0.8em;
  vertical-align: super;
  line-height: 0;
}
 #filterContainer {
    display: flex;
    align-items: center;  justify-content: flex-end;
    margin: 0 0 15px 0;
    gap: 10px; /* Adjust the spacing between elements as needed */
  }

  #startDate, #endDate, #applyFilterButton {
    margin: 0;
  }
  #applyFilterButton {
    background: #ddd;
  }
.long-title {

  top: 0px;
  left: 0;
  right: 45px;
  z-index: 1;
}

.long-title h3 {
  font-family: 'Segoe UI Light', 'Helvetica Neue Light', 'Segoe UI', 'Helvetica Neue', 'Trebuchet MS', Verdana;
  font-weight: 200;
  font-size: 28px;
  text-align: center;
  margin: 45px 0 0 45px;
}
   #loading {
            position: fixed;
            width: 100%;
            height: 100%;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background-color: rgba(0,0,0,0.5);
            z-index: 2;
            display: flex;
            justify-content: center;
            align-items: center;
            font-size: 1.5em;
            color: white;
        }
</style>

  <link rel="stylesheet" href="https://cdn3.devexpress.com/jslib/23.1.7/css/dx.light.css">
    <script src="https://cdn3.devexpress.com/jslib/23.1.7/js/dx.all.js"></script>
    
    

</head>
<body>


<div class="long-title"><h3>Refunds</h3></div>
<div id="loading">Loading...</div>

<div id="filterContainer">
  <div id="dateRange"></div>
  <div id="dropDownBox"></div>
  <div id="applyFilterButton"></div>
</div>

<div id="tabs">
  <ul>
    <li><a href="#tab-1">Weekly Refunds By Week Refunded</a></li>
    <li><a href="#tab-2">Weekly Product Refunds</a></li>
    <li><a href="#tab-3">Product Orders & Returns</a></li>
        <li><a href="#tab-4">Refunds By Date</a></li>

  </ul>
  <div id="tab-1">
    <div id="gridContainer1" style="display:none;"></div>
  </div>
  <div id="tab-2">
    <div id="gridContainer2" style="display:none;"></div>
  </div>
  <div id="tab-3">
    <div id="gridContainer3" style="display:none;"></div>
  </div>
  <div id="tab-4">
    <div id="gridContainer4" style="display:none;"></div>
  </div>
</div>

<script>


   $(function() {
           function addGrandTotal(data) {
        return data.map(item => {
            let grandTotal = 0;
            Object.keys(item).forEach(key => {
                if (key !== "RefundReason" && key !== "GrandTotal" && key !== "Product" && key !== "TotalRefunds" && key !== "Category") {
                    const value = parseFloat(item[key]) || 0;
                    grandTotal += value;
                    item[key] = value.toFixed(2);
                }
            });

            if (!item.RefundReason) {
                item.RefundReason = "Without Reason";
            }

            return { ...item, GrandTotal: grandTotal.toFixed(2) };
        });
    }

    function getLast10WeeksRange() {
        const now = new Date();
        const dayOfWeek = now.getDay();
        const lastMonday = new Date(now.setDate(now.getDate() - dayOfWeek + (dayOfWeek === 0 ? -6 : 1))); // Get the last Monday
        const endDate = new Date(lastMonday); // This week's Monday
        endDate.setHours(23, 59, 59, 999);

        const startDate = new Date(endDate);
        startDate.setDate(startDate.getDate() - 70); // Go back 70 days (10 weeks)

        return {
            startDate: startDate.toISOString().split('T')[0],
            endDate: endDate.toISOString().split('T')[0]
        };
    }

    const { startDate, endDate } = getLast10WeeksRange();

    $("#tabs").tabs({
        activate: function(event, ui) {
            const newPanelId = ui.newPanel.attr('id');
            $("#loading").show();
            setTimeout(() => {
                $("#loading").hide();
                if (newPanelId === "tab-1") {
                    initializeGrid1("#gridContainer1", 'https://sri.nepsols.com/salesforce/api-refunds.php', startDate, endDate);
                } else if (newPanelId === "tab-2") {
                    initializeGrid2("#gridContainer2", 'https://sri.nepsols.com/salesforce/api-product-refunds.php', startDate, endDate);
                } else if (newPanelId === "tab-3") {
                    initializeGrid3("#gridContainer3", 'https://sri.nepsols.com/salesforce/api-reports.php', startDate, endDate);
                }
                 else if (newPanelId === "tab-4") {
                    initializeGrid4("#gridContainer4", 'https://sri.nepsols.com/salesforce/api-refunds-date.php', startDate, endDate);
                }
            }, 500); // Adjust the timeout as needed
        }
    });

    async function fetchData(url, startDate = null, endDate = null, dropDownValues = null) {
        let params = [];
        if (startDate && endDate) {
            params.push(`startDate=${startDate}`);
            params.push(`endDate=${endDate}`);
        }
        if (dropDownValues) {
            params.push(`stores=${dropDownValues.join(',')}`);
        }
        url += '?' + params.join('&');
        const response = await fetch(url);
        const data = await response.json();
        return data;
    }

    function createColumns1(data) {
        const columns = [{ dataField: "RefundReason", caption: "Refund Reason" }];
        const dateFields = new Set();

        data.forEach(item => {
            Object.keys(item).forEach(key => {
                if (key !== "RefundReason" && key !== "GrandTotal") {
                    dateFields.add(key);
                }
            });
        });

        dateFields.forEach(dateField => {
            columns.push({
                dataField: dateField,
                caption: dateField,
                dataType: "number",
                format: {
                    type: "currency",
                    precision: 2
                },
                cellTemplate: function(container, options) {
                    const value = parseFloat(options.value) || 0;
                    container.text(`$${value.toFixed(2)}`);
                }
            });
        });

        columns.push({
            dataField: "GrandTotal",
            caption: "Grand Total",
            dataType: "number",
            format: {
                type: "currency",
                precision: 2
            },
            cellTemplate: function(container, options) {
                const value = parseFloat(options.value) || 0;
                container.text(`$${value.toFixed(2)}`);
            }
        });

        return columns;
    }

    function createColumns2(data) {
        const columns = [{ dataField: "Product", caption: "Product Name" }];
        const dateFields = new Set();

        data.forEach(item => {
            Object.keys(item).forEach(key => {
                if (key !== "Product" && key !== "TotalRefunds") {
                    dateFields.add(key);
                }
            });
        });

        dateFields.forEach(dateField => {
            columns.push({
                dataField: dateField,
                caption: dateField,
                dataType: "number",
                format: {
                    type: "currency",
                    precision: 2
                },
                cellTemplate: function(container, options) {
                    const value = parseFloat(options.value) || 0;
                    container.text(`$${value.toFixed(2)}`);
                }
            });
        });

        return columns;
    }

    function createColumns3(data) {
        const columns = [
            { dataField: "ProductTitle", caption: "Product Title" },
            { dataField: "OrderedQuantity", caption: "Ordered Quantity", dataType: "number" },
            { dataField: "ReturnedQuantity", caption: "Returned Quantity", dataType: "number" },
            { 
                dataField: "ReturnRate", 
                caption: "Return Rate", 
                dataType: "number",
                cellTemplate: function(container, options) {
                    const value = parseFloat(options.value) || 0;
                    container.text(`${value.toFixed(2)}%`);
                }
            }
        ];

        return columns;
    }
    function createColumns4(data) {
        const columns = [
            { dataField: "RefundReason", caption: "Refund Reason" },
            { dataField: "RefundAmount", caption: "Amount Refunded ($)", dataType: "number",
          
                cellTemplate: function(container, options) {
                    const value = parseFloat(options.value) || 0;
                    container.text(`${value.toFixed(2)}`);
                }}
      
        ];

        return columns;
    }

    async function initializeGrid1(containerId, dataUrl, startDate = null, endDate = null, dropDownValues = null) {
        const data = await fetchData(dataUrl, startDate, endDate, dropDownValues);
        const dataWithGrandTotal = addGrandTotal(data);
        const columns = createColumns1(dataWithGrandTotal);

        $(containerId).dxDataGrid({
            dataSource: dataWithGrandTotal,
            columns: columns,
            showBorders: true,
            filterRow: {
                visible: true,
                applyFilter: 'auto',
            },
            paging: {
                enabled: false
            },
            scrolling: {
                columnRenderingMode: "virtual"
            },
            columnAutoWidth: true,
            summary: {
                totalItems: columns.map(column => ({
                    column: column.dataField,
                    summaryType: "sum",
                    customizeText: function(data) {
                        return `$${data.value.toFixed(2)}`;
                    }
                }))
            },
            onCellPrepared: function(e) {
                if (e.rowType === "totalFooter" && e.column.dataField === "RefundReason") {
                    e.cellElement.text("Total");
                }
            },
            onContentReady: function(e) {
                $("#loading").hide();
            }
        });

        $(containerId).show();
    }

    async function initializeGrid2(containerId, dataUrl, startDate = null, endDate = null, dropDownValues = null) {
        const data = await fetchData(dataUrl, startDate, endDate, dropDownValues);
        const columns = createColumns2(data);

        $(containerId).dxDataGrid({
            dataSource: data,
            columns: columns,
            showBorders: true,
            filterRow: {
                visible: true,
                applyFilter: 'auto',
            },
            paging: {
                enabled: false
            },
            scrolling: {
                columnRenderingMode: "virtual"
            },
            columnAutoWidth: true,
            summary: {
                totalItems: columns.map(column => ({
                    column: column.dataField,
                    summaryType: "sum",
                    customizeText: function(data) {
                        return `$${data.value.toFixed(2)}`;
                    }
                }))
            },
            onCellPrepared: function(e) {
                if (e.rowType === "totalFooter" && e.column.dataField === "Product") {
                    e.cellElement.text("Total");
                }
            },
            onContentReady: function(e) {
                $("#loading").hide();
            }
        });

        $(containerId).show();
    }

    async function initializeGrid3(containerId, dataUrl, startDate = null, endDate = null, dropDownValues = null) {
        const data = await fetchData(dataUrl, startDate, endDate, dropDownValues);
        const columns = createColumns3(data);

        $(containerId).dxDataGrid({
            dataSource: data,
            columns: columns,
            showBorders: true,
            filterRow: {
                visible: true,
                applyFilter: 'auto',
            },
            paging: {
                enabled: false
            },
            scrolling: {
                columnRenderingMode: "virtual"
            },
            columnAutoWidth: true,
            summary: {
                totalItems: columns.map(column => ({
                    column: column.dataField,
                    summaryType: "sum",
                    customizeText: function(data) {
                        return data.name === 'ReturnRate' ? `${data.value.toFixed(2)}%` : `${data.value.toFixed(2)}`;
                    }
                }))
            },
            onCellPrepared: function(e) {
                if (e.rowType === "totalFooter" && e.column.dataField === "ProductTitle") {
                    e.cellElement.text("Total");
                }
            },
            onContentReady: function(e) {
                $("#loading").hide();
            }
        });

        $(containerId).show();
    }
        async function initializeGrid4(containerId, dataUrl, startDate = null, endDate = null, dropDownValues = null) {
        const data = await fetchData(dataUrl, startDate, endDate, dropDownValues);
        const columns = createColumns4(data);

        $(containerId).dxDataGrid({
            dataSource: data,
            columns: columns,
            showBorders: true,
            filterRow: {
                visible: true,
                applyFilter: 'auto',
            },
            paging: {
                enabled: false
            },
            scrolling: {
                columnRenderingMode: "virtual"
            },
            columnAutoWidth: true,
            summary: {
                totalItems: columns.map(column => ({
                    column: column.dataField,
                    summaryType: "sum",
                    customizeText: function(data) {
                        return data.name === 'RefundAmount' ? `${data.value.toFixed(2)}%` : `${data.value.toFixed(2)}`;
                    }
                }))
            },
            onCellPrepared: function(e) {
                if (e.rowType === "totalFooter" && e.column.dataField === "RefundReason") {
                    e.cellElement.text("Total");
                }
            },
            onContentReady: function(e) {
                $("#loading").hide();
            }
        });

        $(containerId).show();
    }

    function initializeFilters(startDate, endDate) {
        const dateRangeBox = $("#dateRange").dxDateRangeBox({
            startDate: new Date(startDate),
            endDate: new Date(endDate),
            labelMode: "floating",
            displayFormat: "yyyy-MM-dd",
            showClearButton: true,
            valueChangeEvent: "change",
            applyValueMode: "instantly",
        }).dxDateRangeBox('instance');

        const makeAsyncDataSource = function(jsonFile) {
            return new DevExpress.data.CustomStore({
                loadMode: 'raw',
                key: 'ID',
                load() {
                    return $.getJSON(`${jsonFile}`);
                },
            });
        };

        const dropDownBox = $("#dropDownBox").dxDropDownBox({
            value: ['SRI', 'PSC'],
            valueExpr: 'ID',
            displayExpr: 'name',
            placeholder: 'Select stores',
            showClearButton: true,
            dataSource: makeAsyncDataSource('https://sri.nepsols.com/salesforce/api-stores-name.php'),
            contentTemplate(e) {
                const v = e.component.option('value');
                const $dataGrid = $('<div>').dxDataGrid({
                    dataSource: e.component.getDataSource(),
                    columns: [
                        { dataField: 'ID', caption: 'ID', visible: false },
                        { dataField: 'name', caption: 'Store Name' }
                    ],
                    hoverStateEnabled: true,
                    selection: { mode: 'multiple', showCheckBoxesMode: 'always' },
                    selectedRowKeys: v,
                    onSelectionChanged(selectedItems) {
                        const selectedKeys = selectedItems.selectedRowKeys;
                        const allKeys = selectedItems.component.getDataSource().items().map(item => item.ID).filter(id => id !== 'selectAll');

                        if (selectedKeys.includes('selectAll')) {
                            selectedItems.component.selectRows(allKeys, true);
                            e.component.option('value', allKeys);
                        } else {
                            e.component.option('value', selectedKeys);
                        }
                    },
                });

                const dataGridInstance = $dataGrid.dxDataGrid('instance');

                e.component.on('valueChanged', (args) => {
                    const { value } = args;
                    dataGridInstance.selectRows(value, false);
                });

                return $dataGrid;
            }
        }).dxDropDownBox('instance');

        $("#applyFilterButton").dxButton({
            text: 'Apply Filter',
            onClick: function() {
                let startDate = dateRangeBox.option('startDate');
                let endDate = dateRangeBox.option('endDate');
                const dropDownValues = dropDownBox.option('value');

                if (startDate && endDate) {
                    startDate = startDate.toISOString().split('T')[0];
                    endDate = new Date(endDate);
                    endDate.setHours(23, 59, 59, 999);
                    endDate = endDate.toISOString().split('T')[0];

                    $("#loading").show();

                    initializeGrid1("#gridContainer1", 'https://sri.nepsols.com/salesforce/api-refunds.php', startDate, endDate, dropDownValues);
                    initializeGrid2("#gridContainer2", 'https://sri.nepsols.com/salesforce/api-product-refunds.php', startDate, endDate, dropDownValues);
                    initializeGrid3("#gridContainer3", 'https://sri.nepsols.com/salesforce/api-reports.php', startDate, endDate, dropDownValues);
                                        initializeGrid4("#gridContainer4", 'https://sri.nepsols.com/salesforce/api-refunds-date.php', startDate, endDate, dropDownValues);

                }
            }
        });
    }

    initializeGrid1("#gridContainer1", 'https://sri.nepsols.com/salesforce/api-refunds.php', startDate, endDate);
    initializeFilters(startDate, endDate);
});


</script>


</html>
