<!DOCTYPE html>
<html>
<head>
    <title>Refunds Dashboard</title>
    
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>

<link rel="stylesheet" href="https://code.jquery.com/ui/1.12.1/themes/base/jquery-ui.css">
<script src="https://code.jquery.com/ui/1.12.1/jquery-ui.js"></script>



<link href="https://cdn3.devexpress.com/jslib/21.2.15/css/dx.common.css" rel="stylesheet" integrity="sha384-9ceVmCuW5Hi2O6t2DMUwzXLPJoXQBRHey6E6C5alO+ePpbqGKZTSdSNyjIsjMkka sha512-Iy5gn0p54NPHsw7C4tL7y3dNBA5qss7cBb5s7fPFwFYW4s0sQ7qd6Tqn+hsN2ddqioLziDhu9SgLdFcYEtrkMQ==" crossorigin="anonymous">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/devextreme/21.2.15/css/dx.light.css" rel="stylesheet">


       <script src="https://cdnjs.cloudflare.com/ajax/libs/babel-polyfill/7.4.0/polyfill.min.js"></script>



    <script src="https://cdn3.devexpress.com/jslib/21.2.15/js/dx.all.js"></script>
    
       <style>
   #gridContainer sup {
  font-size: 0.8em;
  vertical-align: super;
  line-height: 0;
}
 #filterContainer {
    display: flex;
    align-items: center;  justify-content: flex-end;
    margin: 0 0 15px 0;
    gap: 10px; /* Adjust the spacing between elements as needed */
  }

  #startDate, #endDate, #applyFilterButton {
    margin: 0;
  }
  #applyFilterButton {
    background: #ddd;
  }
.long-title {

  top: 0px;
  left: 0;
  right: 45px;
  z-index: 1;
}

.long-title h3 {
  font-family: 'Segoe UI Light', 'Helvetica Neue Light', 'Segoe UI', 'Helvetica Neue', 'Trebuchet MS', Verdana;
  font-weight: 200;
  font-size: 28px;
  text-align: center;
  margin: 45px 0 0 45px;
}
   #loading {
            position: fixed;
            width: 100%;
            height: 100%;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background-color: rgba(0,0,0,0.5);
            z-index: 2;
            display: flex;
            justify-content: center;
            align-items: center;
            font-size: 1.5em;
            color: white;
        }
</style>

</head>
<body>
            <div class="long-title"><h3>Refunds</h3></div>
<div id="loading" >Loading...</div>

<div id="filterContainer">
  <div id="startDate"></div>
  <div id="endDate"></div>
  <div id="applyFilterButton"></div>
</div>

<div id="tabs">
  <ul>
    <li><a href="#tab-1">Tab 1</a></li>
    <li><a href="#tab-2">Tab 2</a></li>
    <li><a href="#tab-3">Tab 3</a></li>
  </ul>
  <div id="tab-1">
    <div id="gridContainer1" style="display:none;"></div>
  </div>
  <div id="tab-2">
    <div id="gridContainer2" style="display:none;"></div>
  </div>
  <div id="tab-3">
    <div id="gridContainer3" style="display:none;"></div>
  </div>
</div>

<script>
$(function() {
    const { startDate, endDate } = getLast10WeeksRange();

    $("#tabs").tabs({
        activate: function(event, ui) {
            const newPanelId = ui.newPanel.attr('id');
            $("#loading").show();
            setTimeout(() => {
                $("#loading").hide();
                if (newPanelId === "tab-1") {
                    initializeGrid("#gridContainer1", 'https://sri.nepsols.com/salesforce/api-get-refunds.php', startDate, endDate);
                } else if (newPanelId === "tab-2") {
                    initializeGrid("#gridContainer2", 'https://sri.nepsols.com/salesforce/api-get-refunds.php', startDate, endDate);
                } else if (newPanelId === "tab-3") {
                    initializeGrid("#gridContainer3", 'https://sri.nepsols.com/salesforce/api-get-refunds.php', startDate, endDate);
                }
            }, 500); // Adjust the timeout as needed
        }
    });

    async function fetchData(url, startDate = null, endDate = null) {
        if (startDate && endDate) {
            url += `?startDate=${startDate}&endDate=${endDate}`;
        }
        const response = await fetch(url);
        const data = await response.json();
        return data;
    }

    function createColumns(data) {
        const columns = [{ dataField: "RefundReason", caption: "Refund Reason" }];
        const dateFields = new Set();

        data.forEach(item => {
            Object.keys(item).forEach(key => {
                if (key !== "RefundReason" && key !== "GrandTotal") {
                    dateFields.add(key);
                }
            });
        });

        dateFields.forEach(dateField => {
            columns.push({
                dataField: dateField,
                caption: dateField,
                dataType: "number",
                format: {
                    type: "currency",
                    precision: 2
                },
                cellTemplate: function(container, options) {
                    const value = parseFloat(options.value) || 0;
                    container.text(`$${value.toFixed(2)}`);
                }
            });
        });

        columns.push({
            dataField: "GrandTotal",
            caption: "Grand Total",
            dataType: "number",
            format: {
                type: "currency",
                precision: 2
            },
            cellTemplate: function(container, options) {
                const value = parseFloat(options.value) || 0;
                container.text(`$${value.toFixed(2)}`);
            }
        });

        return columns;
    }

    function addGrandTotal(data) {
        return data.map(item => {
            let grandTotal = 0;
            Object.keys(item).forEach(key => {
                if (key !== "RefundReason" && key !== "GrandTotal") {
                    const value = parseFloat(item[key]) || 0;
                    grandTotal += value;
                    item[key] = value.toFixed(2);
                }
            });

            if (!item.RefundReason) {
                item.RefundReason = "Without Reason";
            }

            return { ...item, GrandTotal: grandTotal.toFixed(2) };
        });
    }

    function getLast10WeeksRange() {
        const now = new Date();
        const dayOfWeek = now.getDay();
        const lastMonday = new Date(now.setDate(now.getDate() - dayOfWeek + (dayOfWeek === 0 ? -6 : 1))); // Get the last Monday
        const endDate = new Date(lastMonday); // This week's Monday
        endDate.setHours(23, 59, 59, 999);

        const startDate = new Date(endDate);
        startDate.setDate(startDate.getDate() - 70); // Go back 70 days (10 weeks)

        return {
            startDate: startDate.toISOString().split('T')[0],
            endDate: endDate.toISOString().split('T')[0]
        };
    }

    async function initializeGrid(containerId, dataUrl, startDate = null, endDate = null) {
        const data = await fetchData(dataUrl, startDate, endDate);
        const dataWithGrandTotal = addGrandTotal(data);
        const columns = createColumns(dataWithGrandTotal);

        $(containerId).dxDataGrid({
            dataSource: dataWithGrandTotal,
            columns: columns,
            showBorders: true,
            filterRow: {
                visible: true,
                applyFilter: 'auto',
            },
            paging: {
                enabled: false
            },
            scrolling: {
                columnRenderingMode: "virtual"
            },
            columnAutoWidth: true,
            summary: {
                totalItems: columns.map(column => ({
                    column: column.dataField,
                    summaryType: "sum",
                    customizeText: function(data) {
                        return `$${data.value.toFixed(2)}`;
                    }
                }))
            },
            onCellPrepared: function(e) {
                if (e.rowType === "totalFooter" && e.column.dataField === "RefundReason") {
                    e.cellElement.text("Total");
                }
            },
            onContentReady: function(e) {
                $("#loading").hide();
            }
        });

        $(containerId).show();
    }

    function initializeFilters(startDate, endDate) {
        const startDatePicker = $("#startDate").dxDateBox({
            type: 'date',
            placeholder: 'Start Date',
            value: new Date(startDate),
            max: new Date()
        }).dxDateBox('instance');

        const endDatePicker = $("#endDate").dxDateBox({
            type: 'date',
            placeholder: 'End Date',
            value: new Date(endDate),
            max: new Date()
        }).dxDateBox('instance');

        $("#applyFilterButton").dxButton({
            text: 'Apply Filter',
            onClick: function() {
                let startDate = startDatePicker.option('value');
                let endDate = endDatePicker.option('value');

                if (startDate && endDate) {
                    startDate = startDate.toISOString().split('T')[0];
                    endDate = new Date(endDate);
                    endDate.setHours(23, 59, 59, 999);
                    endDate = endDate.toISOString().split('T')[0];

                    $("#loading").show();

                    initializeGrid("#gridContainer1", 'https://sri.nepsols.com/salesforce/api-get-refunds.php', startDate, endDate);
                    initializeGrid("#gridContainer2", 'https://sri.nepsols.com/salesforce/api-get-refunds.php', startDate, endDate);
                    initializeGrid("#gridContainer3", 'https://sri.nepsols.com/salesforce/api-get-refunds.php', startDate, endDate);
                }
            }
        });
    }

    initializeGrid("#gridContainer1", 'https://sri.nepsols.com/salesforce/api-get-refunds.php', startDate, endDate);
    initializeFilters(startDate, endDate);
});
</script>



</html>
