<!DOCTYPE html>
<html>
<head>
    <title>Refunds Dashboard</title>
    
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>

<link href="https://cdn3.devexpress.com/jslib/21.2.15/css/dx.common.css" rel="stylesheet" integrity="sha384-9ceVmCuW5Hi2O6t2DMUwzXLPJoXQBRHey6E6C5alO+ePpbqGKZTSdSNyjIsjMkka sha512-Iy5gn0p54NPHsw7C4tL7y3dNBA5qss7cBb5s7fPFwFYW4s0sQ7qd6Tqn+hsN2ddqioLziDhu9SgLdFcYEtrkMQ==" crossorigin="anonymous">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/devextreme/21.2.15/css/dx.light.css" rel="stylesheet">


       <script src="https://cdnjs.cloudflare.com/ajax/libs/babel-polyfill/7.4.0/polyfill.min.js"></script>



    <script src="https://cdn3.devexpress.com/jslib/21.2.15/js/dx.all.js"></script>
    
       <style>
   #gridContainer sup {
  font-size: 0.8em;
  vertical-align: super;
  line-height: 0;
}
 #dateRangeContainer {
    display: flex;
    align-items: center;  justify-content: flex-end;
    margin: 0 0 15px 0;
    gap: 10px; /* Adjust the spacing between elements as needed */
  }

  #startDate, #endDate, #applyFilterButton {
    margin: 0;
  }
  #applyFilterButton {
  padding: 10px 0;
    background: #ddd;
  }
.long-title {

  top: 0px;
  left: 0;
  right: 45px;
  z-index: 1;
}

.long-title h3 {
  font-family: 'Segoe UI Light', 'Helvetica Neue Light', 'Segoe UI', 'Helvetica Neue', 'Trebuchet MS', Verdana;
  font-weight: 200;
  font-size: 28px;
  text-align: center;
  margin: 45px 0 0 45px;
}
   #loading {
            position: fixed;
            width: 100%;
            height: 100%;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background-color: rgba(0,0,0,0.5);
            z-index: 2;
            display: flex;
            justify-content: center;
            align-items: center;
            font-size: 1.5em;
            color: white;
        }
</style>

</head>
<body>
                  <div class="long-title"><h3>Refunds</h3></div>
<div id="dateRangeContainer">
        <div id="startDate"></div>
        <div id="endDate"></div>
        <button id="applyFilterButton">Apply Filter</button>
    </div>
      <div id="loading">Loading...</div>
    <div id="gridContainer" style="display:none;"></div>

 <script>
         $(function() {
            // Function to fetch data from a remote source
            async function fetchData() {
                const response = await fetch('https://sri.nepsols.com/salesforce/api-get-refunds.php'); // Replace with your URL
                const data = await response.json();
                return data;
            }

            // Function to dynamically create columns from data
            function createColumns(data) {
                const columns = [{ dataField: "RefundReason", caption: "Refund Reason" }];
                const dateFields = new Set();

                // Collect all date fields
                data.forEach(item => {
                    Object.keys(item).forEach(key => {
                        if (key !== "RefundReason" && key !== "GrandTotal") {
                            dateFields.add(key);
                        }
                    });
                });

                // Create columns for each date field
                dateFields.forEach(dateField => {
                    columns.push({
                        dataField: dateField,
                        caption: dateField,
                        dataType: "number",
                        format: {
                            type: "currency",
                            precision: 2
                        },
                        cellTemplate: function(container, options) {
                            const value = parseFloat(options.value) || 0;
                            container.text(`$${value.toFixed(2)}`);
                        }
                    });
                });

                // Add a Grand Total column
                columns.push({
                    dataField: "GrandTotal",
                    caption: "Grand Total",
                    dataType: "number",
                    format: {
                        type: "currency",
                        precision: 2
                    },
                    cellTemplate: function(container, options) {
                        const value = parseFloat(options.value) || 0;
                        container.text(`$${value.toFixed(2)}`);
                    }
                });

                return columns;
            }

            // Function to add Grand Total to each row
            function addGrandTotal(data) {
                return data.map(item => {
                    let grandTotal = 0;
                    Object.keys(item).forEach(key => {
                        if (key !== "RefundReason" && key !== "GrandTotal") {
                            const value = parseFloat(item[key]) || 0;
                            grandTotal += value;
                            item[key] = value.toFixed(2); // Ensure all values are numbers with two decimal places
                        }
                    });

                    // Replace empty RefundReason with "Without Reason"
                    if (!item.RefundReason) {
                        item.RefundReason = "Without Reason";
                    }

                    return { ...item, GrandTotal: grandTotal.toFixed(2) };
                });
            }

            // Initialize the grid with data and columns
            async function initializeGrid() {
                const data = await fetchData();
                const dataWithGrandTotal = addGrandTotal(data);
                const columns = createColumns(dataWithGrandTotal);

                const dataGrid =  $("#gridContainer").dxDataGrid({
                    dataSource: dataWithGrandTotal,
                    columns: columns,
                    showBorders: true,
                    filterRow: {
                        visible: true,
                        applyFilter: 'auto',
                    },
                    paging: {
                        enabled: false
                    },
                    scrolling: {
                        columnRenderingMode: "virtual"
                    },
                    columnAutoWidth: true,
                    summary: {
                        totalItems: columns.map(column => ({
                            column: column.dataField,
                            summaryType: "sum",
                            customizeText: function(data) {
                                return `$${data.value.toFixed(2)}`;
                            }
                        }))
                    },
                    onCellPrepared: function(e) {
                        if (e.rowType === "totalFooter" && e.column.dataField === "RefundReason") {
                            e.cellElement.text("Total");
                        }
                    }
                });
                
                  const applyFilterModeEditor = $('#useFilterApplyButton').dxSelectBox({
    items: applyFilterTypes,
    value: applyFilterTypes[0].key,
    valueExpr: 'key',
    inputAttr: { 'aria-label': 'Apply Filter' },
    displayExpr: 'name',
    onValueChanged(data) {
      dataGrid.option('filterRow.applyFilter', data.value);
    },
  }).dxSelectBox('instance');
  
    $('#applyFilterButton').dxButton({
    text: 'Apply Filter',
    onClick: function() {
      const startDate = startDatePicker.option('value');
      let endDate = endDatePicker.option('value');

      if (startDate && endDate) {
        // Adjust endDate to the end of the selected day
        endDate = new Date(endDate);
        endDate.setHours(23, 59, 59, 999);

        dataGrid.filter([['recordDate', '>=', startDate], 'and', ['recordDate', '<=', endDate]]);
      }
    }
  });

                // Hide the loading screen and show the grid
                $("#loading").hide();
                $("#gridContainer").show();
                
                
            }

            initializeGrid();          const applyFilterTypes = [{
    key: 'auto',
    name: 'Immediately',
  }, {
    key: 'onClick',
    name: 'On Button Click',
  }];



  const startDatePicker = $('#startDate').dxDateBox({
    type: 'date',
    placeholder: 'Start Date',
        max: new Date()  // Set max date to today

  }).dxDateBox('instance');

  const endDatePicker = $('#endDate').dxDateBox({
    type: 'date',
    placeholder: 'End Date',
        max: new Date()  // Set max date to today

  }).dxDateBox('instance');



  function getOrderDay(rowData) {
    return (new Date(rowData.recordDate)).getDay();
  }
        });
    </script>
</html>
