<?php 
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ERROR | E_WARNING | E_PARSE);

require 'vendor/autoload.php';
echo '<pre>';

include_once('config.php');


use GuzzleHttp\Client;



// Salesforce token URL
$tokenUrl = 'https://login.salesforce.com/services/oauth2/token';

// Create a new HTTP client
$client = new Client();

// Request access token
try {
    $response = $client->request('POST', $tokenUrl, [
        'form_params' => [
            'grant_type' => 'password',
            'client_id' => SF_CLIENT_ID,
            'client_secret' => SF_CLIENT_SECRET,
            'username' => SF_USERNAME,
            'password' => SF_PASSWORD . SECURITY_TOKEN,
        ]
    ]);

    // Decode the JSON response
    $data = json_decode($response->getBody(), true);

    // Extract access token
    $accessToken = $data['access_token'];
    $instanceUrl = $data['instance_url'];

    echo "Access Token: " . $accessToken . "\n";
    echo "Instance URL: " . $instanceUrl . "\n";

    // Now you can use the access token to make authorized requests to the Salesforce API
    // For example, to get information about the authenticated user:
    $response = $client->request('GET', $instanceUrl . '/services/oauth2/userinfo', [
        'headers' => [
            'Authorization' => 'Bearer ' . $accessToken,
        ]
    ]);

    $userInfo = json_decode($response->getBody(), true);
    print_r($userInfo);

} catch (Exception $e) {
    echo 'Error: ' . $e->getMessage();
}
/*

use EventFarm\Restforce\Rest\OAuthAccessToken;
use EventFarm\Restforce\Restforce;
use EventFarm\Restforce\RestforceInterface;

class DemoSalesforceApi
{
   
    private $restforce;

    public function getRestforceClient(): RestforceInterface
    {
        if ($this->restforce === null) {
            // You need either the OAuthAccessToken
            // or the Username & Password,
            // the other(s) can be null.
            $this->restforce = new Restforce(
                getenv('SF_CLIENT_ID'),
                getenv('SF_CLIENT_SECRET'),
                new OAuthAccessToken(''),
                getenv('SF_USERNAME'),
                getenv('SF_PASSWORD')
            );
        }
        return $this->restforce;
    }
}



$restforce = (new DemoSalesforceApi())->getClient();
$responseInterface = $restforce->limits();

print_r($responseInterface);*/
