<?php
declare(strict_types=1);

/**
 * TemplatesApi.
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  DocuSign\eSign
 * @author   Swagger Codegen team <apihelp@docusign.com>
 * @license  The DocuSign PHP Client SDK is licensed under the MIT License.
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * DocuSign REST API
 *
 * The DocuSign REST API provides you with a powerful, convenient, and simple Web services API for interacting with DocuSign.
 *
 * OpenAPI spec version: v2.1
 * Contact: devcenter@docusign.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 * Swagger Codegen version: 2.4.21
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace DocuSign\eSign\Api\TemplatesApi;


/**
 * CreateRecipientsOptions Class Doc Comment
 *
 * @category Class
 * @package  DocuSign\eSign
 * @author   Swagger Codegen team <apihelp@docusign.com>
 * @license  The DocuSign PHP Client SDK is licensed under the MIT License.
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class CreateRecipientsOptions
{
    /**
      * $resend_envelope 
      * @var ?string
      */
    protected ?string $resend_envelope = null;

    /**
     * Gets resend_envelope
     *
     * @return ?string
     */
    public function getResendEnvelope(): ?string
    {
        return $this->resend_envelope;
    }

    /**
     * Sets resend_envelope
     * @param ?string $resend_envelope 
     *
     * @return self
     */
    public function setResendEnvelope(?string $resend_envelope): self
    {
        $this->resend_envelope = $resend_envelope;
        return $this;
    }
}


/**
 * GetOptions Class Doc Comment
 *
 * @category Class
 * @package  DocuSign\eSign
 * @author   Swagger Codegen team <apihelp@docusign.com>
 * @license  The DocuSign PHP Client SDK is licensed under the MIT License.
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class GetOptions
{
    /**
      * $include 
      * @var ?string
      */
    protected ?string $include = null;

    /**
     * Gets include
     *
     * @return ?string
     */
    public function getInclude(): ?string
    {
        return $this->include;
    }

    /**
     * Sets include
     * @param ?string $include 
     *
     * @return self
     */
    public function setInclude(?string $include): self
    {
        $this->include = $include;
        return $this;
    }
}


/**
 * GetDocumentOptions Class Doc Comment
 *
 * @category Class
 * @package  DocuSign\eSign
 * @author   Swagger Codegen team <apihelp@docusign.com>
 * @license  The DocuSign PHP Client SDK is licensed under the MIT License.
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class GetDocumentOptions
{
    /**
      * $encrypt 
      * @var ?string
      */
    protected ?string $encrypt = null;

    /**
     * Gets encrypt
     *
     * @return ?string
     */
    public function getEncrypt(): ?string
    {
        return $this->encrypt;
    }

    /**
     * Sets encrypt
     * @param ?string $encrypt 
     *
     * @return self
     */
    public function setEncrypt(?string $encrypt): self
    {
        $this->encrypt = $encrypt;
        return $this;
    }
    /**
      * $file_type 
      * @var ?string
      */
    protected ?string $file_type = null;

    /**
     * Gets file_type
     *
     * @return ?string
     */
    public function getFileType(): ?string
    {
        return $this->file_type;
    }

    /**
     * Sets file_type
     * @param ?string $file_type 
     *
     * @return self
     */
    public function setFileType(?string $file_type): self
    {
        $this->file_type = $file_type;
        return $this;
    }
    /**
      * $show_changes 
      * @var ?string
      */
    protected ?string $show_changes = null;

    /**
     * Gets show_changes
     *
     * @return ?string
     */
    public function getShowChanges(): ?string
    {
        return $this->show_changes;
    }

    /**
     * Sets show_changes
     * @param ?string $show_changes 
     *
     * @return self
     */
    public function setShowChanges(?string $show_changes): self
    {
        $this->show_changes = $show_changes;
        return $this;
    }
}


/**
 * GetDocumentPageImageOptions Class Doc Comment
 *
 * @category Class
 * @package  DocuSign\eSign
 * @author   Swagger Codegen team <apihelp@docusign.com>
 * @license  The DocuSign PHP Client SDK is licensed under the MIT License.
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class GetDocumentPageImageOptions
{
    /**
      * $dpi 
      * @var ?string
      */
    protected ?string $dpi = null;

    /**
     * Gets dpi
     *
     * @return ?string
     */
    public function getDpi(): ?string
    {
        return $this->dpi;
    }

    /**
     * Sets dpi
     * @param ?string $dpi 
     *
     * @return self
     */
    public function setDpi(?string $dpi): self
    {
        $this->dpi = $dpi;
        return $this;
    }
    /**
      * $max_height 
      * @var ?string
      */
    protected ?string $max_height = null;

    /**
     * Gets max_height
     *
     * @return ?string
     */
    public function getMaxHeight(): ?string
    {
        return $this->max_height;
    }

    /**
     * Sets max_height
     * @param ?string $max_height 
     *
     * @return self
     */
    public function setMaxHeight(?string $max_height): self
    {
        $this->max_height = $max_height;
        return $this;
    }
    /**
      * $max_width 
      * @var ?string
      */
    protected ?string $max_width = null;

    /**
     * Gets max_width
     *
     * @return ?string
     */
    public function getMaxWidth(): ?string
    {
        return $this->max_width;
    }

    /**
     * Sets max_width
     * @param ?string $max_width 
     *
     * @return self
     */
    public function setMaxWidth(?string $max_width): self
    {
        $this->max_width = $max_width;
        return $this;
    }
    /**
      * $show_changes 
      * @var ?string
      */
    protected ?string $show_changes = null;

    /**
     * Gets show_changes
     *
     * @return ?string
     */
    public function getShowChanges(): ?string
    {
        return $this->show_changes;
    }

    /**
     * Sets show_changes
     * @param ?string $show_changes 
     *
     * @return self
     */
    public function setShowChanges(?string $show_changes): self
    {
        $this->show_changes = $show_changes;
        return $this;
    }
}


/**
 * GetDocumentTabsOptions Class Doc Comment
 *
 * @category Class
 * @package  DocuSign\eSign
 * @author   Swagger Codegen team <apihelp@docusign.com>
 * @license  The DocuSign PHP Client SDK is licensed under the MIT License.
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class GetDocumentTabsOptions
{
    /**
      * $page_numbers 
      * @var ?string
      */
    protected ?string $page_numbers = null;

    /**
     * Gets page_numbers
     *
     * @return ?string
     */
    public function getPageNumbers(): ?string
    {
        return $this->page_numbers;
    }

    /**
     * Sets page_numbers
     * @param ?string $page_numbers 
     *
     * @return self
     */
    public function setPageNumbers(?string $page_numbers): self
    {
        $this->page_numbers = $page_numbers;
        return $this;
    }
}


/**
 * GetPagesOptions Class Doc Comment
 *
 * @category Class
 * @package  DocuSign\eSign
 * @author   Swagger Codegen team <apihelp@docusign.com>
 * @license  The DocuSign PHP Client SDK is licensed under the MIT License.
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class GetPagesOptions
{
    /**
      * $count 
      * @var ?string
      */
    protected ?string $count = null;

    /**
     * Gets count
     *
     * @return ?string
     */
    public function getCount(): ?string
    {
        return $this->count;
    }

    /**
     * Sets count
     * @param ?string $count 
     *
     * @return self
     */
    public function setCount(?string $count): self
    {
        $this->count = $count;
        return $this;
    }
    /**
      * $dpi 
      * @var ?string
      */
    protected ?string $dpi = null;

    /**
     * Gets dpi
     *
     * @return ?string
     */
    public function getDpi(): ?string
    {
        return $this->dpi;
    }

    /**
     * Sets dpi
     * @param ?string $dpi 
     *
     * @return self
     */
    public function setDpi(?string $dpi): self
    {
        $this->dpi = $dpi;
        return $this;
    }
    /**
      * $max_height 
      * @var ?string
      */
    protected ?string $max_height = null;

    /**
     * Gets max_height
     *
     * @return ?string
     */
    public function getMaxHeight(): ?string
    {
        return $this->max_height;
    }

    /**
     * Sets max_height
     * @param ?string $max_height 
     *
     * @return self
     */
    public function setMaxHeight(?string $max_height): self
    {
        $this->max_height = $max_height;
        return $this;
    }
    /**
      * $max_width 
      * @var ?string
      */
    protected ?string $max_width = null;

    /**
     * Gets max_width
     *
     * @return ?string
     */
    public function getMaxWidth(): ?string
    {
        return $this->max_width;
    }

    /**
     * Sets max_width
     * @param ?string $max_width 
     *
     * @return self
     */
    public function setMaxWidth(?string $max_width): self
    {
        $this->max_width = $max_width;
        return $this;
    }
    /**
      * $nocache 
      * @var ?string
      */
    protected ?string $nocache = null;

    /**
     * Gets nocache
     *
     * @return ?string
     */
    public function getNocache(): ?string
    {
        return $this->nocache;
    }

    /**
     * Sets nocache
     * @param ?string $nocache 
     *
     * @return self
     */
    public function setNocache(?string $nocache): self
    {
        $this->nocache = $nocache;
        return $this;
    }
    /**
      * $show_changes 
      * @var ?string
      */
    protected ?string $show_changes = null;

    /**
     * Gets show_changes
     *
     * @return ?string
     */
    public function getShowChanges(): ?string
    {
        return $this->show_changes;
    }

    /**
     * Sets show_changes
     * @param ?string $show_changes 
     *
     * @return self
     */
    public function setShowChanges(?string $show_changes): self
    {
        $this->show_changes = $show_changes;
        return $this;
    }
    /**
      * $start_position 
      * @var ?string
      */
    protected ?string $start_position = null;

    /**
     * Gets start_position
     *
     * @return ?string
     */
    public function getStartPosition(): ?string
    {
        return $this->start_position;
    }

    /**
     * Sets start_position
     * @param ?string $start_position 
     *
     * @return self
     */
    public function setStartPosition(?string $start_position): self
    {
        $this->start_position = $start_position;
        return $this;
    }
}


/**
 * ListDocumentsOptions Class Doc Comment
 *
 * @category Class
 * @package  DocuSign\eSign
 * @author   Swagger Codegen team <apihelp@docusign.com>
 * @license  The DocuSign PHP Client SDK is licensed under the MIT License.
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class ListDocumentsOptions
{
    /**
      * $include_tabs 
      * @var ?string
      */
    protected ?string $include_tabs = null;

    /**
     * Gets include_tabs
     *
     * @return ?string
     */
    public function getIncludeTabs(): ?string
    {
        return $this->include_tabs;
    }

    /**
     * Sets include_tabs
     * @param ?string $include_tabs 
     *
     * @return self
     */
    public function setIncludeTabs(?string $include_tabs): self
    {
        $this->include_tabs = $include_tabs;
        return $this;
    }
}


/**
 * ListRecipientsOptions Class Doc Comment
 *
 * @category Class
 * @package  DocuSign\eSign
 * @author   Swagger Codegen team <apihelp@docusign.com>
 * @license  The DocuSign PHP Client SDK is licensed under the MIT License.
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class ListRecipientsOptions
{
    /**
      * $include_anchor_tab_locations When set to **true** and `include_tabs` is set to **true**, all tabs with anchor tab properties are included in the response.
      * @var ?string
      */
    protected ?string $include_anchor_tab_locations = null;

    /**
     * Gets include_anchor_tab_locations
     *
     * @return ?string
     */
    public function getIncludeAnchorTabLocations(): ?string
    {
        return $this->include_anchor_tab_locations;
    }

    /**
     * Sets include_anchor_tab_locations
     * @param ?string $include_anchor_tab_locations When set to **true** and `include_tabs` is set to **true**, all tabs with anchor tab properties are included in the response.
     *
     * @return self
     */
    public function setIncludeAnchorTabLocations(?string $include_anchor_tab_locations): self
    {
        $this->include_anchor_tab_locations = $include_anchor_tab_locations;
        return $this;
    }
    /**
      * $include_extended When set to **true**, the extended properties are included in the response.
      * @var ?string
      */
    protected ?string $include_extended = null;

    /**
     * Gets include_extended
     *
     * @return ?string
     */
    public function getIncludeExtended(): ?string
    {
        return $this->include_extended;
    }

    /**
     * Sets include_extended
     * @param ?string $include_extended When set to **true**, the extended properties are included in the response.
     *
     * @return self
     */
    public function setIncludeExtended(?string $include_extended): self
    {
        $this->include_extended = $include_extended;
        return $this;
    }
    /**
      * $include_tabs When set to **true**, the tab information associated with the recipient is included in the response.
      * @var ?string
      */
    protected ?string $include_tabs = null;

    /**
     * Gets include_tabs
     *
     * @return ?string
     */
    public function getIncludeTabs(): ?string
    {
        return $this->include_tabs;
    }

    /**
     * Sets include_tabs
     * @param ?string $include_tabs When set to **true**, the tab information associated with the recipient is included in the response.
     *
     * @return self
     */
    public function setIncludeTabs(?string $include_tabs): self
    {
        $this->include_tabs = $include_tabs;
        return $this;
    }
}


/**
 * ListTabsOptions Class Doc Comment
 *
 * @category Class
 * @package  DocuSign\eSign
 * @author   Swagger Codegen team <apihelp@docusign.com>
 * @license  The DocuSign PHP Client SDK is licensed under the MIT License.
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class ListTabsOptions
{
    /**
      * $include_anchor_tab_locations When set to **true**, all tabs with anchor tab properties are included in the response.
      * @var ?string
      */
    protected ?string $include_anchor_tab_locations = null;

    /**
     * Gets include_anchor_tab_locations
     *
     * @return ?string
     */
    public function getIncludeAnchorTabLocations(): ?string
    {
        return $this->include_anchor_tab_locations;
    }

    /**
     * Sets include_anchor_tab_locations
     * @param ?string $include_anchor_tab_locations When set to **true**, all tabs with anchor tab properties are included in the response.
     *
     * @return self
     */
    public function setIncludeAnchorTabLocations(?string $include_anchor_tab_locations): self
    {
        $this->include_anchor_tab_locations = $include_anchor_tab_locations;
        return $this;
    }
    /**
      * $include_metadata 
      * @var ?string
      */
    protected ?string $include_metadata = null;

    /**
     * Gets include_metadata
     *
     * @return ?string
     */
    public function getIncludeMetadata(): ?string
    {
        return $this->include_metadata;
    }

    /**
     * Sets include_metadata
     * @param ?string $include_metadata 
     *
     * @return self
     */
    public function setIncludeMetadata(?string $include_metadata): self
    {
        $this->include_metadata = $include_metadata;
        return $this;
    }
}


/**
 * ListTemplatesOptions Class Doc Comment
 *
 * @category Class
 * @package  DocuSign\eSign
 * @author   Swagger Codegen team <apihelp@docusign.com>
 * @license  The DocuSign PHP Client SDK is licensed under the MIT License.
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class ListTemplatesOptions
{
    /**
      * $count Number of records to return in the cache.
      * @var ?string
      */
    protected ?string $count = null;

    /**
     * Gets count
     *
     * @return ?string
     */
    public function getCount(): ?string
    {
        return $this->count;
    }

    /**
     * Sets count
     * @param ?string $count Number of records to return in the cache.
     *
     * @return self
     */
    public function setCount(?string $count): self
    {
        $this->count = $count;
        return $this;
    }
    /**
      * $created_from_date 
      * @var ?string
      */
    protected ?string $created_from_date = null;

    /**
     * Gets created_from_date
     *
     * @return ?string
     */
    public function getCreatedFromDate(): ?string
    {
        return $this->created_from_date;
    }

    /**
     * Sets created_from_date
     * @param ?string $created_from_date 
     *
     * @return self
     */
    public function setCreatedFromDate(?string $created_from_date): self
    {
        $this->created_from_date = $created_from_date;
        return $this;
    }
    /**
      * $created_to_date 
      * @var ?string
      */
    protected ?string $created_to_date = null;

    /**
     * Gets created_to_date
     *
     * @return ?string
     */
    public function getCreatedToDate(): ?string
    {
        return $this->created_to_date;
    }

    /**
     * Sets created_to_date
     * @param ?string $created_to_date 
     *
     * @return self
     */
    public function setCreatedToDate(?string $created_to_date): self
    {
        $this->created_to_date = $created_to_date;
        return $this;
    }
    /**
      * $folder_ids A comma separated list of folder ID GUIDs.
      * @var ?string
      */
    protected ?string $folder_ids = null;

    /**
     * Gets folder_ids
     *
     * @return ?string
     */
    public function getFolderIds(): ?string
    {
        return $this->folder_ids;
    }

    /**
     * Sets folder_ids
     * @param ?string $folder_ids A comma separated list of folder ID GUIDs.
     *
     * @return self
     */
    public function setFolderIds(?string $folder_ids): self
    {
        $this->folder_ids = $folder_ids;
        return $this;
    }
    /**
      * $folder_types 
      * @var ?string
      */
    protected ?string $folder_types = null;

    /**
     * Gets folder_types
     *
     * @return ?string
     */
    public function getFolderTypes(): ?string
    {
        return $this->folder_types;
    }

    /**
     * Sets folder_types
     * @param ?string $folder_types 
     *
     * @return self
     */
    public function setFolderTypes(?string $folder_types): self
    {
        $this->folder_types = $folder_types;
        return $this;
    }
    /**
      * $from_date Start of the search date range. Only returns templates created on or after this date/time. If no value is specified, there is no limit on the earliest date created.
      * @var ?string
      */
    protected ?string $from_date = null;

    /**
     * Gets from_date
     *
     * @return ?string
     */
    public function getFromDate(): ?string
    {
        return $this->from_date;
    }

    /**
     * Sets from_date
     * @param ?string $from_date Start of the search date range. Only returns templates created on or after this date/time. If no value is specified, there is no limit on the earliest date created.
     *
     * @return self
     */
    public function setFromDate(?string $from_date): self
    {
        $this->from_date = $from_date;
        return $this;
    }
    /**
      * $include A comma separated list of additional template attributes to include in the response. Valid values are: recipients, folders, documents, custom_fields, and notifications.
      * @var ?string
      */
    protected ?string $include = null;

    /**
     * Gets include
     *
     * @return ?string
     */
    public function getInclude(): ?string
    {
        return $this->include;
    }

    /**
     * Sets include
     * @param ?string $include A comma separated list of additional template attributes to include in the response. Valid values are: recipients, folders, documents, custom_fields, and notifications.
     *
     * @return self
     */
    public function setInclude(?string $include): self
    {
        $this->include = $include;
        return $this;
    }
    /**
      * $is_deleted_template_only 
      * @var ?string
      */
    protected ?string $is_deleted_template_only = null;

    /**
     * Gets is_deleted_template_only
     *
     * @return ?string
     */
    public function getIsDeletedTemplateOnly(): ?string
    {
        return $this->is_deleted_template_only;
    }

    /**
     * Sets is_deleted_template_only
     * @param ?string $is_deleted_template_only 
     *
     * @return self
     */
    public function setIsDeletedTemplateOnly(?string $is_deleted_template_only): self
    {
        $this->is_deleted_template_only = $is_deleted_template_only;
        return $this;
    }
    /**
      * $is_download 
      * @var ?string
      */
    protected ?string $is_download = null;

    /**
     * Gets is_download
     *
     * @return ?string
     */
    public function getIsDownload(): ?string
    {
        return $this->is_download;
    }

    /**
     * Sets is_download
     * @param ?string $is_download 
     *
     * @return self
     */
    public function setIsDownload(?string $is_download): self
    {
        $this->is_download = $is_download;
        return $this;
    }
    /**
      * $modified_from_date 
      * @var ?string
      */
    protected ?string $modified_from_date = null;

    /**
     * Gets modified_from_date
     *
     * @return ?string
     */
    public function getModifiedFromDate(): ?string
    {
        return $this->modified_from_date;
    }

    /**
     * Sets modified_from_date
     * @param ?string $modified_from_date 
     *
     * @return self
     */
    public function setModifiedFromDate(?string $modified_from_date): self
    {
        $this->modified_from_date = $modified_from_date;
        return $this;
    }
    /**
      * $modified_to_date 
      * @var ?string
      */
    protected ?string $modified_to_date = null;

    /**
     * Gets modified_to_date
     *
     * @return ?string
     */
    public function getModifiedToDate(): ?string
    {
        return $this->modified_to_date;
    }

    /**
     * Sets modified_to_date
     * @param ?string $modified_to_date 
     *
     * @return self
     */
    public function setModifiedToDate(?string $modified_to_date): self
    {
        $this->modified_to_date = $modified_to_date;
        return $this;
    }
    /**
      * $order Sets the direction order used to sort the list. Valid values are: -asc = ascending sort order (a to z)  -desc = descending sort order (z to a)
      * @var ?string
      */
    protected ?string $order = null;

    /**
     * Gets order
     *
     * @return ?string
     */
    public function getOrder(): ?string
    {
        return $this->order;
    }

    /**
     * Sets order
     * @param ?string $order Sets the direction order used to sort the list. Valid values are: -asc = ascending sort order (a to z)  -desc = descending sort order (z to a)
     *
     * @return self
     */
    public function setOrder(?string $order): self
    {
        $this->order = $order;
        return $this;
    }
    /**
      * $order_by Sets the file attribute used to sort the list. Valid values are:  -name: template name  -modified: date/time template was last modified.  -used: date/time the template was last used.
      * @var ?string
      */
    protected ?string $order_by = null;

    /**
     * Gets order_by
     *
     * @return ?string
     */
    public function getOrderBy(): ?string
    {
        return $this->order_by;
    }

    /**
     * Sets order_by
     * @param ?string $order_by Sets the file attribute used to sort the list. Valid values are:  -name: template name  -modified: date/time template was last modified.  -used: date/time the template was last used.
     *
     * @return self
     */
    public function setOrderBy(?string $order_by): self
    {
        $this->order_by = $order_by;
        return $this;
    }
    /**
      * $search_fields 
      * @var ?string
      */
    protected ?string $search_fields = null;

    /**
     * Gets search_fields
     *
     * @return ?string
     */
    public function getSearchFields(): ?string
    {
        return $this->search_fields;
    }

    /**
     * Sets search_fields
     * @param ?string $search_fields 
     *
     * @return self
     */
    public function setSearchFields(?string $search_fields): self
    {
        $this->search_fields = $search_fields;
        return $this;
    }
    /**
      * $search_text The search text used to search the names of templates.
      * @var ?string
      */
    protected ?string $search_text = null;

    /**
     * Gets search_text
     *
     * @return ?string
     */
    public function getSearchText(): ?string
    {
        return $this->search_text;
    }

    /**
     * Sets search_text
     * @param ?string $search_text The search text used to search the names of templates.
     *
     * @return self
     */
    public function setSearchText(?string $search_text): self
    {
        $this->search_text = $search_text;
        return $this;
    }
    /**
      * $shared_by_me If true, the response only includes templates shared by the user. If false, the response only returns template not shared by the user. If not specified, the response is not affected.
      * @var ?string
      */
    protected ?string $shared_by_me = null;

    /**
     * Gets shared_by_me
     *
     * @return ?string
     */
    public function getSharedByMe(): ?string
    {
        return $this->shared_by_me;
    }

    /**
     * Sets shared_by_me
     * @param ?string $shared_by_me If true, the response only includes templates shared by the user. If false, the response only returns template not shared by the user. If not specified, the response is not affected.
     *
     * @return self
     */
    public function setSharedByMe(?string $shared_by_me): self
    {
        $this->shared_by_me = $shared_by_me;
        return $this;
    }
    /**
      * $start_position The starting index for the first template shown in the response. This must be greater than or equal to 0 (zero).
      * @var ?string
      */
    protected ?string $start_position = null;

    /**
     * Gets start_position
     *
     * @return ?string
     */
    public function getStartPosition(): ?string
    {
        return $this->start_position;
    }

    /**
     * Sets start_position
     * @param ?string $start_position The starting index for the first template shown in the response. This must be greater than or equal to 0 (zero).
     *
     * @return self
     */
    public function setStartPosition(?string $start_position): self
    {
        $this->start_position = $start_position;
        return $this;
    }
    /**
      * $template_ids 
      * @var ?string
      */
    protected ?string $template_ids = null;

    /**
     * Gets template_ids
     *
     * @return ?string
     */
    public function getTemplateIds(): ?string
    {
        return $this->template_ids;
    }

    /**
     * Sets template_ids
     * @param ?string $template_ids 
     *
     * @return self
     */
    public function setTemplateIds(?string $template_ids): self
    {
        $this->template_ids = $template_ids;
        return $this;
    }
    /**
      * $to_date End of the search date range. Only returns templates created up to this date/time. If no value is provided, this defaults to the current date.
      * @var ?string
      */
    protected ?string $to_date = null;

    /**
     * Gets to_date
     *
     * @return ?string
     */
    public function getToDate(): ?string
    {
        return $this->to_date;
    }

    /**
     * Sets to_date
     * @param ?string $to_date End of the search date range. Only returns templates created up to this date/time. If no value is provided, this defaults to the current date.
     *
     * @return self
     */
    public function setToDate(?string $to_date): self
    {
        $this->to_date = $to_date;
        return $this;
    }
    /**
      * $used_from_date Start of the search date range. Only returns templates used or edited on or after this date/time. If no value is specified, there is no limit on the earliest date used.
      * @var ?string
      */
    protected ?string $used_from_date = null;

    /**
     * Gets used_from_date
     *
     * @return ?string
     */
    public function getUsedFromDate(): ?string
    {
        return $this->used_from_date;
    }

    /**
     * Sets used_from_date
     * @param ?string $used_from_date Start of the search date range. Only returns templates used or edited on or after this date/time. If no value is specified, there is no limit on the earliest date used.
     *
     * @return self
     */
    public function setUsedFromDate(?string $used_from_date): self
    {
        $this->used_from_date = $used_from_date;
        return $this;
    }
    /**
      * $used_to_date End of the search date range. Only returns templates used or edited up to this date/time. If no value is provided, this defaults to the current date.
      * @var ?string
      */
    protected ?string $used_to_date = null;

    /**
     * Gets used_to_date
     *
     * @return ?string
     */
    public function getUsedToDate(): ?string
    {
        return $this->used_to_date;
    }

    /**
     * Sets used_to_date
     * @param ?string $used_to_date End of the search date range. Only returns templates used or edited up to this date/time. If no value is provided, this defaults to the current date.
     *
     * @return self
     */
    public function setUsedToDate(?string $used_to_date): self
    {
        $this->used_to_date = $used_to_date;
        return $this;
    }
    /**
      * $user_filter Sets if the templates shown in the response Valid values are:  -owned_by_me: only shows templates the user owns.  -shared_with_me: only shows templates that are shared with the user.  -all: shows all templates owned or shared with the user.
      * @var ?string
      */
    protected ?string $user_filter = null;

    /**
     * Gets user_filter
     *
     * @return ?string
     */
    public function getUserFilter(): ?string
    {
        return $this->user_filter;
    }

    /**
     * Sets user_filter
     * @param ?string $user_filter Sets if the templates shown in the response Valid values are:  -owned_by_me: only shows templates the user owns.  -shared_with_me: only shows templates that are shared with the user.  -all: shows all templates owned or shared with the user.
     *
     * @return self
     */
    public function setUserFilter(?string $user_filter): self
    {
        $this->user_filter = $user_filter;
        return $this;
    }
    /**
      * $user_id 
      * @var ?string
      */
    protected ?string $user_id = null;

    /**
     * Gets user_id
     *
     * @return ?string
     */
    public function getUserId(): ?string
    {
        return $this->user_id;
    }

    /**
     * Sets user_id
     * @param ?string $user_id 
     *
     * @return self
     */
    public function setUserId(?string $user_id): self
    {
        $this->user_id = $user_id;
        return $this;
    }
}


/**
 * UpdateDocumentOptions Class Doc Comment
 *
 * @category Class
 * @package  DocuSign\eSign
 * @author   Swagger Codegen team <apihelp@docusign.com>
 * @license  The DocuSign PHP Client SDK is licensed under the MIT License.
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class UpdateDocumentOptions
{
    /**
      * $is_envelope_definition 
      * @var ?string
      */
    protected ?string $is_envelope_definition = null;

    /**
     * Gets is_envelope_definition
     *
     * @return ?string
     */
    public function getIsEnvelopeDefinition(): ?string
    {
        return $this->is_envelope_definition;
    }

    /**
     * Sets is_envelope_definition
     * @param ?string $is_envelope_definition 
     *
     * @return self
     */
    public function setIsEnvelopeDefinition(?string $is_envelope_definition): self
    {
        $this->is_envelope_definition = $is_envelope_definition;
        return $this;
    }
}


/**
 * UpdateRecipientsOptions Class Doc Comment
 *
 * @category Class
 * @package  DocuSign\eSign
 * @author   Swagger Codegen team <apihelp@docusign.com>
 * @license  The DocuSign PHP Client SDK is licensed under the MIT License.
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class UpdateRecipientsOptions
{
    /**
      * $resend_envelope 
      * @var ?string
      */
    protected ?string $resend_envelope = null;

    /**
     * Gets resend_envelope
     *
     * @return ?string
     */
    public function getResendEnvelope(): ?string
    {
        return $this->resend_envelope;
    }

    /**
     * Sets resend_envelope
     * @param ?string $resend_envelope 
     *
     * @return self
     */
    public function setResendEnvelope(?string $resend_envelope): self
    {
        $this->resend_envelope = $resend_envelope;
        return $this;
    }
}



namespace DocuSign\eSign\Api;

use DocuSign\eSign\Client\ApiClient;
use DocuSign\eSign\Client\ApiException;
use DocuSign\eSign\Configuration;
use DocuSign\eSign\ObjectSerializer;

/**
 * TemplatesApi Class Doc Comment
 *
 * @category Class
 * @package  DocuSign\eSign
 * @author   Swagger Codegen team <apihelp@docusign.com>
 * @license  The DocuSign PHP Client SDK is licensed under the MIT License.
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class TemplatesApi
{
    /**
     * API Client
     *
     * @var ApiClient instance of the ApiClient
     */
    protected ApiClient $apiClient;

    /**
     * Constructor
     *
     * @param ApiClient|null $apiClient The api client to use
     *
     * @return void
     */
    public function __construct(ApiClient $apiClient = null)
    {
        $this->apiClient = $apiClient ?? new ApiClient();
    }

    /**
     * Get API client
     *
     * @return ApiClient get the API client
     */
    public function getApiClient(): ApiClient
    {
        return $this->apiClient;
    }

    /**
     * Set the API client
     *
     * @param ApiClient $apiClient set the API client
     *
     * @return self
     */
    public function setApiClient(ApiClient $apiClient): self
    {
        $this->apiClient = $apiClient;
        return $this;
    }

    /**
    * Update $resourcePath with $
    *
    * @param string $resourcePath the resource path to use
    * @param string $baseName the base name param
    * @param string $paramName the parameter name
    *
    * @return string
    */
    public function updateResourcePath(string $resourcePath, string $baseName, string $paramName): string
    {
        return str_replace(
            "{" . $baseName . "}",
            $this->apiClient->getSerializer()->toPathValue($paramName),
            $resourcePath
        );
    }


    /**
     * Operation createCustomFields
     *
     * Creates custom document fields in an existing template document.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $template_id The ID of the template being accessed.
     * @param \DocuSign\eSign\Model\TemplateCustomFields $template_custom_fields  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\CustomFields
     */
    public function createCustomFields($account_id, $template_id, $template_custom_fields = null)
    {
        list($response) = $this->createCustomFieldsWithHttpInfo($account_id, $template_id, $template_custom_fields);
        return $response;
    }

    /**
     * Operation createCustomFieldsWithHttpInfo
     *
     * Creates custom document fields in an existing template document.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $template_id The ID of the template being accessed.
     * @param \DocuSign\eSign\Model\TemplateCustomFields $template_custom_fields  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\CustomFields, HTTP status code, HTTP response headers (array of strings)
     */
    public function createCustomFieldsWithHttpInfo($account_id, $template_id, $template_custom_fields = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling createCustomFields');
        }
        // verify the required parameter 'template_id' is set
        if ($template_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $template_id when calling createCustomFields');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/templates/{templateId}/custom_fields";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($template_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "templateId", $template_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        // body params
        $_tempBody = null;
        if (isset($template_custom_fields)) {
            $_tempBody = $template_custom_fields;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\CustomFields',
                '/v2.1/accounts/{accountId}/templates/{templateId}/custom_fields'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\CustomFields', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\CustomFields', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation createDocumentFields
     *
     * Creates custom document fields in an existing template document.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $document_id The ID of the document being accessed.
     * @param ?string $template_id The ID of the template being accessed.
     * @param \DocuSign\eSign\Model\DocumentFieldsInformation $document_fields_information  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\DocumentFieldsInformation
     */
    public function createDocumentFields($account_id, $document_id, $template_id, $document_fields_information = null)
    {
        list($response) = $this->createDocumentFieldsWithHttpInfo($account_id, $document_id, $template_id, $document_fields_information);
        return $response;
    }

    /**
     * Operation createDocumentFieldsWithHttpInfo
     *
     * Creates custom document fields in an existing template document.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $document_id The ID of the document being accessed.
     * @param ?string $template_id The ID of the template being accessed.
     * @param \DocuSign\eSign\Model\DocumentFieldsInformation $document_fields_information  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\DocumentFieldsInformation, HTTP status code, HTTP response headers (array of strings)
     */
    public function createDocumentFieldsWithHttpInfo($account_id, $document_id, $template_id, $document_fields_information = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling createDocumentFields');
        }
        // verify the required parameter 'document_id' is set
        if ($document_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $document_id when calling createDocumentFields');
        }
        // verify the required parameter 'template_id' is set
        if ($template_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $template_id when calling createDocumentFields');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/templates/{templateId}/documents/{documentId}/fields";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($document_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "documentId", $document_id);
        }
        // path params
        if ($template_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "templateId", $template_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        // body params
        $_tempBody = null;
        if (isset($document_fields_information)) {
            $_tempBody = $document_fields_information;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\DocumentFieldsInformation',
                '/v2.1/accounts/{accountId}/templates/{templateId}/documents/{documentId}/fields'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\DocumentFieldsInformation', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\DocumentFieldsInformation', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation createEditView
     *
     * Provides a URL to start an edit view of the Template UI
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $template_id The ID of the template being accessed.
     * @param \DocuSign\eSign\Model\TemplateViewRequest $template_view_request  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\ViewUrl
     */
    public function createEditView($account_id, $template_id, $template_view_request = null)
    {
        list($response) = $this->createEditViewWithHttpInfo($account_id, $template_id, $template_view_request);
        return $response;
    }

    /**
     * Operation createEditViewWithHttpInfo
     *
     * Provides a URL to start an edit view of the Template UI
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $template_id The ID of the template being accessed.
     * @param \DocuSign\eSign\Model\TemplateViewRequest $template_view_request  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\ViewUrl, HTTP status code, HTTP response headers (array of strings)
     */
    public function createEditViewWithHttpInfo($account_id, $template_id, $template_view_request = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling createEditView');
        }
        // verify the required parameter 'template_id' is set
        if ($template_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $template_id when calling createEditView');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/templates/{templateId}/views/edit";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($template_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "templateId", $template_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        // body params
        $_tempBody = null;
        if (isset($template_view_request)) {
            $_tempBody = $template_view_request;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\ViewUrl',
                '/v2.1/accounts/{accountId}/templates/{templateId}/views/edit'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\ViewUrl', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ViewUrl', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation createLock
     *
     * Lock a template.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $template_id The ID of the template being accessed.
     * @param \DocuSign\eSign\Model\LockRequest $lock_request  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\LockInformation
     */
    public function createLock($account_id, $template_id, $lock_request = null)
    {
        list($response) = $this->createLockWithHttpInfo($account_id, $template_id, $lock_request);
        return $response;
    }

    /**
     * Operation createLockWithHttpInfo
     *
     * Lock a template.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $template_id The ID of the template being accessed.
     * @param \DocuSign\eSign\Model\LockRequest $lock_request  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\LockInformation, HTTP status code, HTTP response headers (array of strings)
     */
    public function createLockWithHttpInfo($account_id, $template_id, $lock_request = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling createLock');
        }
        // verify the required parameter 'template_id' is set
        if ($template_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $template_id when calling createLock');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/templates/{templateId}/lock";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($template_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "templateId", $template_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        // body params
        $_tempBody = null;
        if (isset($lock_request)) {
            $_tempBody = $lock_request;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\LockInformation',
                '/v2.1/accounts/{accountId}/templates/{templateId}/lock'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\LockInformation', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\LockInformation', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation createRecipients
     *
     * Adds tabs for a recipient.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $template_id The ID of the template being accessed.
     * @param \DocuSign\eSign\Model\TemplateRecipients $template_recipients  (optional)
     * @param  \DocuSign\eSign\Api\TemplatesApi\CreateRecipientsOptions  $options for modifying the behavior of the function. (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\Recipients
     */
    public function createRecipients($account_id, $template_id, $template_recipients = null, \DocuSign\eSign\Api\TemplatesApi\CreateRecipientsOptions $options = null)
    {
        list($response) = $this->createRecipientsWithHttpInfo($account_id, $template_id, $template_recipients, $options);
        return $response;
    }

    /**
     * Operation createRecipientsWithHttpInfo
     *
     * Adds tabs for a recipient.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $template_id The ID of the template being accessed.
     * @param \DocuSign\eSign\Model\TemplateRecipients $template_recipients  (optional)
     * @param  \DocuSign\eSign\Api\TemplatesApi\CreateRecipientsOptions  $options for modifying the behavior of the function. (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\Recipients, HTTP status code, HTTP response headers (array of strings)
     */
    public function createRecipientsWithHttpInfo($account_id, $template_id, $template_recipients = null, \DocuSign\eSign\Api\TemplatesApi\CreateRecipientsOptions $options = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling createRecipients');
        }
        // verify the required parameter 'template_id' is set
        if ($template_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $template_id when calling createRecipients');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/templates/{templateId}/recipients";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);

        if ($options != null)
        {
            // query params
            if ($options->getResendEnvelope() != 'null') {
                $queryParams['resend_envelope'] = $this->apiClient->getSerializer()->toQueryValue($options->getResendEnvelope());
            }
        }

        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($template_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "templateId", $template_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        // body params
        $_tempBody = null;
        if (isset($template_recipients)) {
            $_tempBody = $template_recipients;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\Recipients',
                '/v2.1/accounts/{accountId}/templates/{templateId}/recipients'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\Recipients', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\Recipients', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation createTabs
     *
     * Adds tabs for a recipient.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $recipient_id The ID of the recipient being accessed.
     * @param ?string $template_id The ID of the template being accessed.
     * @param \DocuSign\eSign\Model\TemplateTabs $template_tabs  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\Tabs
     */
    public function createTabs($account_id, $recipient_id, $template_id, $template_tabs = null)
    {
        list($response) = $this->createTabsWithHttpInfo($account_id, $recipient_id, $template_id, $template_tabs);
        return $response;
    }

    /**
     * Operation createTabsWithHttpInfo
     *
     * Adds tabs for a recipient.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $recipient_id The ID of the recipient being accessed.
     * @param ?string $template_id The ID of the template being accessed.
     * @param \DocuSign\eSign\Model\TemplateTabs $template_tabs  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\Tabs, HTTP status code, HTTP response headers (array of strings)
     */
    public function createTabsWithHttpInfo($account_id, $recipient_id, $template_id, $template_tabs = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling createTabs');
        }
        // verify the required parameter 'recipient_id' is set
        if ($recipient_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $recipient_id when calling createTabs');
        }
        // verify the required parameter 'template_id' is set
        if ($template_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $template_id when calling createTabs');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/templates/{templateId}/recipients/{recipientId}/tabs";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($recipient_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "recipientId", $recipient_id);
        }
        // path params
        if ($template_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "templateId", $template_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        // body params
        $_tempBody = null;
        if (isset($template_tabs)) {
            $_tempBody = $template_tabs;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\Tabs',
                '/v2.1/accounts/{accountId}/templates/{templateId}/recipients/{recipientId}/tabs'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\Tabs', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\Tabs', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation createTemplate
     *
     * Creates an envelope from a template.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param \DocuSign\eSign\Model\EnvelopeTemplate $envelope_template  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\TemplateSummary
     */
    public function createTemplate($account_id, $envelope_template = null)
    {
        list($response) = $this->createTemplateWithHttpInfo($account_id, $envelope_template);
        return $response;
    }

    /**
     * Operation createTemplateWithHttpInfo
     *
     * Creates an envelope from a template.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param \DocuSign\eSign\Model\EnvelopeTemplate $envelope_template  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\TemplateSummary, HTTP status code, HTTP response headers (array of strings)
     */
    public function createTemplateWithHttpInfo($account_id, $envelope_template = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling createTemplate');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/templates";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        // body params
        $_tempBody = null;
        if (isset($envelope_template)) {
            $_tempBody = $envelope_template;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\TemplateSummary',
                '/v2.1/accounts/{accountId}/templates'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\TemplateSummary', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\TemplateSummary', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation createTemplateDocumentResponsiveHtmlPreview
     *
     * Post Responsive HTML Preview for a document in a template.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $document_id The ID of the document being accessed.
     * @param ?string $template_id The ID of the template being accessed.
     * @param \DocuSign\eSign\Model\DocumentHtmlDefinition $document_html_definition  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\DocumentHtmlDefinitions
     */
    public function createTemplateDocumentResponsiveHtmlPreview($account_id, $document_id, $template_id, $document_html_definition = null)
    {
        list($response) = $this->createTemplateDocumentResponsiveHtmlPreviewWithHttpInfo($account_id, $document_id, $template_id, $document_html_definition);
        return $response;
    }

    /**
     * Operation createTemplateDocumentResponsiveHtmlPreviewWithHttpInfo
     *
     * Post Responsive HTML Preview for a document in a template.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $document_id The ID of the document being accessed.
     * @param ?string $template_id The ID of the template being accessed.
     * @param \DocuSign\eSign\Model\DocumentHtmlDefinition $document_html_definition  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\DocumentHtmlDefinitions, HTTP status code, HTTP response headers (array of strings)
     */
    public function createTemplateDocumentResponsiveHtmlPreviewWithHttpInfo($account_id, $document_id, $template_id, $document_html_definition = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling createTemplateDocumentResponsiveHtmlPreview');
        }
        // verify the required parameter 'document_id' is set
        if ($document_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $document_id when calling createTemplateDocumentResponsiveHtmlPreview');
        }
        // verify the required parameter 'template_id' is set
        if ($template_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $template_id when calling createTemplateDocumentResponsiveHtmlPreview');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/templates/{templateId}/documents/{documentId}/responsive_html_preview";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($document_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "documentId", $document_id);
        }
        // path params
        if ($template_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "templateId", $template_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        // body params
        $_tempBody = null;
        if (isset($document_html_definition)) {
            $_tempBody = $document_html_definition;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\DocumentHtmlDefinitions',
                '/v2.1/accounts/{accountId}/templates/{templateId}/documents/{documentId}/responsive_html_preview'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\DocumentHtmlDefinitions', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\DocumentHtmlDefinitions', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation createTemplateDocumentTabs
     *
     * Adds the tabs to a tempate
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $document_id The ID of the document being accessed.
     * @param ?string $template_id The ID of the template being accessed.
     * @param \DocuSign\eSign\Model\TemplateTabs $template_tabs  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\Tabs
     */
    public function createTemplateDocumentTabs($account_id, $document_id, $template_id, $template_tabs = null)
    {
        list($response) = $this->createTemplateDocumentTabsWithHttpInfo($account_id, $document_id, $template_id, $template_tabs);
        return $response;
    }

    /**
     * Operation createTemplateDocumentTabsWithHttpInfo
     *
     * Adds the tabs to a tempate
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $document_id The ID of the document being accessed.
     * @param ?string $template_id The ID of the template being accessed.
     * @param \DocuSign\eSign\Model\TemplateTabs $template_tabs  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\Tabs, HTTP status code, HTTP response headers (array of strings)
     */
    public function createTemplateDocumentTabsWithHttpInfo($account_id, $document_id, $template_id, $template_tabs = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling createTemplateDocumentTabs');
        }
        // verify the required parameter 'document_id' is set
        if ($document_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $document_id when calling createTemplateDocumentTabs');
        }
        // verify the required parameter 'template_id' is set
        if ($template_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $template_id when calling createTemplateDocumentTabs');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/templates/{templateId}/documents/{documentId}/tabs";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($document_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "documentId", $document_id);
        }
        // path params
        if ($template_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "templateId", $template_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        // body params
        $_tempBody = null;
        if (isset($template_tabs)) {
            $_tempBody = $template_tabs;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\Tabs',
                '/v2.1/accounts/{accountId}/templates/{templateId}/documents/{documentId}/tabs'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\Tabs', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\Tabs', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation createTemplateRecipientPreview
     *
     * Provides a URL to start a recipient view of the Envelope UI
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $template_id The ID of the template being accessed.
     * @param \DocuSign\eSign\Model\RecipientPreviewRequest $recipient_preview_request  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\ViewUrl
     */
    public function createTemplateRecipientPreview($account_id, $template_id, $recipient_preview_request = null)
    {
        list($response) = $this->createTemplateRecipientPreviewWithHttpInfo($account_id, $template_id, $recipient_preview_request);
        return $response;
    }

    /**
     * Operation createTemplateRecipientPreviewWithHttpInfo
     *
     * Provides a URL to start a recipient view of the Envelope UI
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $template_id The ID of the template being accessed.
     * @param \DocuSign\eSign\Model\RecipientPreviewRequest $recipient_preview_request  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\ViewUrl, HTTP status code, HTTP response headers (array of strings)
     */
    public function createTemplateRecipientPreviewWithHttpInfo($account_id, $template_id, $recipient_preview_request = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling createTemplateRecipientPreview');
        }
        // verify the required parameter 'template_id' is set
        if ($template_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $template_id when calling createTemplateRecipientPreview');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/templates/{templateId}/views/recipient_preview";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($template_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "templateId", $template_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        // body params
        $_tempBody = null;
        if (isset($recipient_preview_request)) {
            $_tempBody = $recipient_preview_request;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\ViewUrl',
                '/v2.1/accounts/{accountId}/templates/{templateId}/views/recipient_preview'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\ViewUrl', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ViewUrl', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation createTemplateResponsiveHtmlPreview
     *
     * Get Responsive HTML Preview for all documents in a template.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $template_id The ID of the template being accessed.
     * @param \DocuSign\eSign\Model\DocumentHtmlDefinition $document_html_definition  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\DocumentHtmlDefinitions
     */
    public function createTemplateResponsiveHtmlPreview($account_id, $template_id, $document_html_definition = null)
    {
        list($response) = $this->createTemplateResponsiveHtmlPreviewWithHttpInfo($account_id, $template_id, $document_html_definition);
        return $response;
    }

    /**
     * Operation createTemplateResponsiveHtmlPreviewWithHttpInfo
     *
     * Get Responsive HTML Preview for all documents in a template.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $template_id The ID of the template being accessed.
     * @param \DocuSign\eSign\Model\DocumentHtmlDefinition $document_html_definition  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\DocumentHtmlDefinitions, HTTP status code, HTTP response headers (array of strings)
     */
    public function createTemplateResponsiveHtmlPreviewWithHttpInfo($account_id, $template_id, $document_html_definition = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling createTemplateResponsiveHtmlPreview');
        }
        // verify the required parameter 'template_id' is set
        if ($template_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $template_id when calling createTemplateResponsiveHtmlPreview');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/templates/{templateId}/responsive_html_preview";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($template_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "templateId", $template_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        // body params
        $_tempBody = null;
        if (isset($document_html_definition)) {
            $_tempBody = $document_html_definition;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\DocumentHtmlDefinitions',
                '/v2.1/accounts/{accountId}/templates/{templateId}/responsive_html_preview'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\DocumentHtmlDefinitions', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\DocumentHtmlDefinitions', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation deleteCustomFields
     *
     * Deletes envelope custom fields in a template.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $template_id The ID of the template being accessed.
     * @param \DocuSign\eSign\Model\TemplateCustomFields $template_custom_fields  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\CustomFields
     */
    public function deleteCustomFields($account_id, $template_id, $template_custom_fields = null)
    {
        list($response) = $this->deleteCustomFieldsWithHttpInfo($account_id, $template_id, $template_custom_fields);
        return $response;
    }

    /**
     * Operation deleteCustomFieldsWithHttpInfo
     *
     * Deletes envelope custom fields in a template.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $template_id The ID of the template being accessed.
     * @param \DocuSign\eSign\Model\TemplateCustomFields $template_custom_fields  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\CustomFields, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteCustomFieldsWithHttpInfo($account_id, $template_id, $template_custom_fields = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling deleteCustomFields');
        }
        // verify the required parameter 'template_id' is set
        if ($template_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $template_id when calling deleteCustomFields');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/templates/{templateId}/custom_fields";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($template_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "templateId", $template_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        // body params
        $_tempBody = null;
        if (isset($template_custom_fields)) {
            $_tempBody = $template_custom_fields;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\CustomFields',
                '/v2.1/accounts/{accountId}/templates/{templateId}/custom_fields'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\CustomFields', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\CustomFields', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation deleteDocumentFields
     *
     * Deletes custom document fields from an existing template document.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $document_id The ID of the document being accessed.
     * @param ?string $template_id The ID of the template being accessed.
     * @param \DocuSign\eSign\Model\DocumentFieldsInformation $document_fields_information  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\DocumentFieldsInformation
     */
    public function deleteDocumentFields($account_id, $document_id, $template_id, $document_fields_information = null)
    {
        list($response) = $this->deleteDocumentFieldsWithHttpInfo($account_id, $document_id, $template_id, $document_fields_information);
        return $response;
    }

    /**
     * Operation deleteDocumentFieldsWithHttpInfo
     *
     * Deletes custom document fields from an existing template document.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $document_id The ID of the document being accessed.
     * @param ?string $template_id The ID of the template being accessed.
     * @param \DocuSign\eSign\Model\DocumentFieldsInformation $document_fields_information  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\DocumentFieldsInformation, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteDocumentFieldsWithHttpInfo($account_id, $document_id, $template_id, $document_fields_information = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling deleteDocumentFields');
        }
        // verify the required parameter 'document_id' is set
        if ($document_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $document_id when calling deleteDocumentFields');
        }
        // verify the required parameter 'template_id' is set
        if ($template_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $template_id when calling deleteDocumentFields');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/templates/{templateId}/documents/{documentId}/fields";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($document_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "documentId", $document_id);
        }
        // path params
        if ($template_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "templateId", $template_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        // body params
        $_tempBody = null;
        if (isset($document_fields_information)) {
            $_tempBody = $document_fields_information;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\DocumentFieldsInformation',
                '/v2.1/accounts/{accountId}/templates/{templateId}/documents/{documentId}/fields'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\DocumentFieldsInformation', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\DocumentFieldsInformation', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation deleteDocumentPage
     *
     * Deletes a page from a document in an template.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $document_id The ID of the document being accessed.
     * @param ?string $page_number The page number being accessed.
     * @param ?string $template_id The ID of the template being accessed.
     * @param \DocuSign\eSign\Model\PageRequest $page_request  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return mixed
     */
    public function deleteDocumentPage($account_id, $document_id, $page_number, $template_id, $page_request = null)
    {
        list($response) = $this->deleteDocumentPageWithHttpInfo($account_id, $document_id, $page_number, $template_id, $page_request);
        return $response;
    }

    /**
     * Operation deleteDocumentPageWithHttpInfo
     *
     * Deletes a page from a document in an template.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $document_id The ID of the document being accessed.
     * @param ?string $page_number The page number being accessed.
     * @param ?string $template_id The ID of the template being accessed.
     * @param \DocuSign\eSign\Model\PageRequest $page_request  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteDocumentPageWithHttpInfo($account_id, $document_id, $page_number, $template_id, $page_request = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling deleteDocumentPage');
        }
        // verify the required parameter 'document_id' is set
        if ($document_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $document_id when calling deleteDocumentPage');
        }
        // verify the required parameter 'page_number' is set
        if ($page_number === null) {
            throw new \InvalidArgumentException('Missing the required parameter $page_number when calling deleteDocumentPage');
        }
        // verify the required parameter 'template_id' is set
        if ($template_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $template_id when calling deleteDocumentPage');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/templates/{templateId}/documents/{documentId}/pages/{pageNumber}";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($document_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "documentId", $document_id);
        }
        // path params
        if ($page_number !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "pageNumber", $page_number);
        }
        // path params
        if ($template_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "templateId", $template_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        // body params
        $_tempBody = null;
        if (isset($page_request)) {
            $_tempBody = $page_request;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/v2.1/accounts/{accountId}/templates/{templateId}/documents/{documentId}/pages/{pageNumber}'
            );

            return [null, $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation deleteDocuments
     *
     * Deletes documents from a template.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $template_id The ID of the template being accessed.
     * @param \DocuSign\eSign\Model\EnvelopeDefinition $envelope_definition  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\TemplateDocumentsResult
     */
    public function deleteDocuments($account_id, $template_id, $envelope_definition = null)
    {
        list($response) = $this->deleteDocumentsWithHttpInfo($account_id, $template_id, $envelope_definition);
        return $response;
    }

    /**
     * Operation deleteDocumentsWithHttpInfo
     *
     * Deletes documents from a template.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $template_id The ID of the template being accessed.
     * @param \DocuSign\eSign\Model\EnvelopeDefinition $envelope_definition  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\TemplateDocumentsResult, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteDocumentsWithHttpInfo($account_id, $template_id, $envelope_definition = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling deleteDocuments');
        }
        // verify the required parameter 'template_id' is set
        if ($template_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $template_id when calling deleteDocuments');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/templates/{templateId}/documents";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($template_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "templateId", $template_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        // body params
        $_tempBody = null;
        if (isset($envelope_definition)) {
            $_tempBody = $envelope_definition;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\TemplateDocumentsResult',
                '/v2.1/accounts/{accountId}/templates/{templateId}/documents'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\TemplateDocumentsResult', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\TemplateDocumentsResult', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation deleteGroupShare
     *
     * Removes a member group's sharing permissions for a template.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $template_id The ID of the template being accessed.
     * @param ?string $template_part Currently, the only defined part is **groups**.
     * @param \DocuSign\eSign\Model\GroupInformation $group_information  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\GroupInformation
     */
    public function deleteGroupShare($account_id, $template_id, $template_part, $group_information = null)
    {
        list($response) = $this->deleteGroupShareWithHttpInfo($account_id, $template_id, $template_part, $group_information);
        return $response;
    }

    /**
     * Operation deleteGroupShareWithHttpInfo
     *
     * Removes a member group's sharing permissions for a template.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $template_id The ID of the template being accessed.
     * @param ?string $template_part Currently, the only defined part is **groups**.
     * @param \DocuSign\eSign\Model\GroupInformation $group_information  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\GroupInformation, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteGroupShareWithHttpInfo($account_id, $template_id, $template_part, $group_information = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling deleteGroupShare');
        }
        // verify the required parameter 'template_id' is set
        if ($template_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $template_id when calling deleteGroupShare');
        }
        // verify the required parameter 'template_part' is set
        if ($template_part === null) {
            throw new \InvalidArgumentException('Missing the required parameter $template_part when calling deleteGroupShare');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/templates/{templateId}/{templatePart}";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($template_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "templateId", $template_id);
        }
        // path params
        if ($template_part !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "templatePart", $template_part);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        // body params
        $_tempBody = null;
        if (isset($group_information)) {
            $_tempBody = $group_information;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\GroupInformation',
                '/v2.1/accounts/{accountId}/templates/{templateId}/{templatePart}'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\GroupInformation', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\GroupInformation', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation deleteLock
     *
     * Deletes a template lock.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $template_id The ID of the template being accessed.
     * @param \DocuSign\eSign\Model\LockRequest $lock_request  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\LockInformation
     */
    public function deleteLock($account_id, $template_id, $lock_request = null)
    {
        list($response) = $this->deleteLockWithHttpInfo($account_id, $template_id, $lock_request);
        return $response;
    }

    /**
     * Operation deleteLockWithHttpInfo
     *
     * Deletes a template lock.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $template_id The ID of the template being accessed.
     * @param \DocuSign\eSign\Model\LockRequest $lock_request  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\LockInformation, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteLockWithHttpInfo($account_id, $template_id, $lock_request = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling deleteLock');
        }
        // verify the required parameter 'template_id' is set
        if ($template_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $template_id when calling deleteLock');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/templates/{templateId}/lock";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($template_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "templateId", $template_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        // body params
        $_tempBody = null;
        if (isset($lock_request)) {
            $_tempBody = $lock_request;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\LockInformation',
                '/v2.1/accounts/{accountId}/templates/{templateId}/lock'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\LockInformation', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\LockInformation', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation deleteRecipient
     *
     * Deletes the specified recipient file from a template.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $recipient_id The ID of the recipient being accessed.
     * @param ?string $template_id The ID of the template being accessed.
     * @param \DocuSign\eSign\Model\TemplateRecipients $template_recipients  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\Recipients
     */
    public function deleteRecipient($account_id, $recipient_id, $template_id, $template_recipients = null)
    {
        list($response) = $this->deleteRecipientWithHttpInfo($account_id, $recipient_id, $template_id, $template_recipients);
        return $response;
    }

    /**
     * Operation deleteRecipientWithHttpInfo
     *
     * Deletes the specified recipient file from a template.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $recipient_id The ID of the recipient being accessed.
     * @param ?string $template_id The ID of the template being accessed.
     * @param \DocuSign\eSign\Model\TemplateRecipients $template_recipients  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\Recipients, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteRecipientWithHttpInfo($account_id, $recipient_id, $template_id, $template_recipients = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling deleteRecipient');
        }
        // verify the required parameter 'recipient_id' is set
        if ($recipient_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $recipient_id when calling deleteRecipient');
        }
        // verify the required parameter 'template_id' is set
        if ($template_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $template_id when calling deleteRecipient');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/templates/{templateId}/recipients/{recipientId}";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($recipient_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "recipientId", $recipient_id);
        }
        // path params
        if ($template_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "templateId", $template_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        // body params
        $_tempBody = null;
        if (isset($template_recipients)) {
            $_tempBody = $template_recipients;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\Recipients',
                '/v2.1/accounts/{accountId}/templates/{templateId}/recipients/{recipientId}'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\Recipients', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\Recipients', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation deleteRecipients
     *
     * Deletes recipients from a template.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $template_id The ID of the template being accessed.
     * @param \DocuSign\eSign\Model\TemplateRecipients $template_recipients  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\Recipients
     */
    public function deleteRecipients($account_id, $template_id, $template_recipients = null)
    {
        list($response) = $this->deleteRecipientsWithHttpInfo($account_id, $template_id, $template_recipients);
        return $response;
    }

    /**
     * Operation deleteRecipientsWithHttpInfo
     *
     * Deletes recipients from a template.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $template_id The ID of the template being accessed.
     * @param \DocuSign\eSign\Model\TemplateRecipients $template_recipients  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\Recipients, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteRecipientsWithHttpInfo($account_id, $template_id, $template_recipients = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling deleteRecipients');
        }
        // verify the required parameter 'template_id' is set
        if ($template_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $template_id when calling deleteRecipients');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/templates/{templateId}/recipients";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($template_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "templateId", $template_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        // body params
        $_tempBody = null;
        if (isset($template_recipients)) {
            $_tempBody = $template_recipients;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\Recipients',
                '/v2.1/accounts/{accountId}/templates/{templateId}/recipients'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\Recipients', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\Recipients', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation deleteTabs
     *
     * Deletes the tabs associated with a recipient in a template.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $recipient_id The ID of the recipient being accessed.
     * @param ?string $template_id The ID of the template being accessed.
     * @param \DocuSign\eSign\Model\TemplateTabs $template_tabs  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\Tabs
     */
    public function deleteTabs($account_id, $recipient_id, $template_id, $template_tabs = null)
    {
        list($response) = $this->deleteTabsWithHttpInfo($account_id, $recipient_id, $template_id, $template_tabs);
        return $response;
    }

    /**
     * Operation deleteTabsWithHttpInfo
     *
     * Deletes the tabs associated with a recipient in a template.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $recipient_id The ID of the recipient being accessed.
     * @param ?string $template_id The ID of the template being accessed.
     * @param \DocuSign\eSign\Model\TemplateTabs $template_tabs  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\Tabs, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteTabsWithHttpInfo($account_id, $recipient_id, $template_id, $template_tabs = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling deleteTabs');
        }
        // verify the required parameter 'recipient_id' is set
        if ($recipient_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $recipient_id when calling deleteTabs');
        }
        // verify the required parameter 'template_id' is set
        if ($template_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $template_id when calling deleteTabs');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/templates/{templateId}/recipients/{recipientId}/tabs";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($recipient_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "recipientId", $recipient_id);
        }
        // path params
        if ($template_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "templateId", $template_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        // body params
        $_tempBody = null;
        if (isset($template_tabs)) {
            $_tempBody = $template_tabs;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\Tabs',
                '/v2.1/accounts/{accountId}/templates/{templateId}/recipients/{recipientId}/tabs'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\Tabs', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\Tabs', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation deleteTemplateDocumentTabs
     *
     * Deletes tabs from an envelope document
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $document_id The ID of the document being accessed.
     * @param ?string $template_id The ID of the template being accessed.
     * @param \DocuSign\eSign\Model\TemplateTabs $template_tabs  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\Tabs
     */
    public function deleteTemplateDocumentTabs($account_id, $document_id, $template_id, $template_tabs = null)
    {
        list($response) = $this->deleteTemplateDocumentTabsWithHttpInfo($account_id, $document_id, $template_id, $template_tabs);
        return $response;
    }

    /**
     * Operation deleteTemplateDocumentTabsWithHttpInfo
     *
     * Deletes tabs from an envelope document
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $document_id The ID of the document being accessed.
     * @param ?string $template_id The ID of the template being accessed.
     * @param \DocuSign\eSign\Model\TemplateTabs $template_tabs  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\Tabs, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteTemplateDocumentTabsWithHttpInfo($account_id, $document_id, $template_id, $template_tabs = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling deleteTemplateDocumentTabs');
        }
        // verify the required parameter 'document_id' is set
        if ($document_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $document_id when calling deleteTemplateDocumentTabs');
        }
        // verify the required parameter 'template_id' is set
        if ($template_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $template_id when calling deleteTemplateDocumentTabs');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/templates/{templateId}/documents/{documentId}/tabs";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($document_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "documentId", $document_id);
        }
        // path params
        if ($template_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "templateId", $template_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        // body params
        $_tempBody = null;
        if (isset($template_tabs)) {
            $_tempBody = $template_tabs;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\Tabs',
                '/v2.1/accounts/{accountId}/templates/{templateId}/documents/{documentId}/tabs'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\Tabs', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\Tabs', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation get
     *
     * Gets a list of templates for a specified account.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $template_id The ID of the template being accessed.
     * @param  \DocuSign\eSign\Api\TemplatesApi\GetOptions  $options for modifying the behavior of the function. (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\EnvelopeTemplate
     */
    public function get($account_id, $template_id, \DocuSign\eSign\Api\TemplatesApi\GetOptions $options = null)
    {
        list($response) = $this->getWithHttpInfo($account_id, $template_id, $options);
        return $response;
    }

    /**
     * Operation getWithHttpInfo
     *
     * Gets a list of templates for a specified account.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $template_id The ID of the template being accessed.
     * @param  \DocuSign\eSign\Api\TemplatesApi\GetOptions  $options for modifying the behavior of the function. (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\EnvelopeTemplate, HTTP status code, HTTP response headers (array of strings)
     */
    public function getWithHttpInfo($account_id, $template_id, \DocuSign\eSign\Api\TemplatesApi\GetOptions $options = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling get');
        }
        // verify the required parameter 'template_id' is set
        if ($template_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $template_id when calling get');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/templates/{templateId}";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);

        if ($options != null)
        {
            // query params
            if ($options->getInclude() != 'null') {
                $queryParams['include'] = $this->apiClient->getSerializer()->toQueryValue($options->getInclude());
            }
        }

        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($template_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "templateId", $template_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\EnvelopeTemplate',
                '/v2.1/accounts/{accountId}/templates/{templateId}'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\EnvelopeTemplate', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\EnvelopeTemplate', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getDocument
     *
     * Gets PDF documents from a template.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $document_id The ID of the document being accessed.
     * @param ?string $template_id The ID of the template being accessed.
     * @param  \DocuSign\eSign\Api\TemplatesApi\GetDocumentOptions  $options for modifying the behavior of the function. (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \SplFileObject
     */
    public function getDocument($account_id, $document_id, $template_id, \DocuSign\eSign\Api\TemplatesApi\GetDocumentOptions $options = null)
    {
        list($response) = $this->getDocumentWithHttpInfo($account_id, $document_id, $template_id, $options);
        return $response;
    }

    /**
     * Operation getDocumentWithHttpInfo
     *
     * Gets PDF documents from a template.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $document_id The ID of the document being accessed.
     * @param ?string $template_id The ID of the template being accessed.
     * @param  \DocuSign\eSign\Api\TemplatesApi\GetDocumentOptions  $options for modifying the behavior of the function. (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \SplFileObject, HTTP status code, HTTP response headers (array of strings)
     */
    public function getDocumentWithHttpInfo($account_id, $document_id, $template_id, \DocuSign\eSign\Api\TemplatesApi\GetDocumentOptions $options = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling getDocument');
        }
        // verify the required parameter 'document_id' is set
        if ($document_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $document_id when calling getDocument');
        }
        // verify the required parameter 'template_id' is set
        if ($template_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $template_id when calling getDocument');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/templates/{templateId}/documents/{documentId}";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/pdf']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);

        if ($options != null)
        {
            // query params
            if ($options->getEncrypt() != 'null') {
                $queryParams['encrypt'] = $this->apiClient->getSerializer()->toQueryValue($options->getEncrypt());
            }
            if ($options->getFileType() != 'null') {
                $queryParams['file_type'] = $this->apiClient->getSerializer()->toQueryValue($options->getFileType());
            }
            if ($options->getShowChanges() != 'null') {
                $queryParams['show_changes'] = $this->apiClient->getSerializer()->toQueryValue($options->getShowChanges());
            }
        }

        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($document_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "documentId", $document_id);
        }
        // path params
        if ($template_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "templateId", $template_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\SplFileObject',
                '/v2.1/accounts/{accountId}/templates/{templateId}/documents/{documentId}'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\SplFileObject', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\SplFileObject', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getDocumentPageImage
     *
     * Gets a page image from a template for display.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $document_id The ID of the document being accessed.
     * @param ?string $page_number The page number being accessed.
     * @param ?string $template_id The ID of the template being accessed.
     * @param  \DocuSign\eSign\Api\TemplatesApi\GetDocumentPageImageOptions  $options for modifying the behavior of the function. (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \SplFileObject
     */
    public function getDocumentPageImage($account_id, $document_id, $page_number, $template_id, \DocuSign\eSign\Api\TemplatesApi\GetDocumentPageImageOptions $options = null)
    {
        list($response) = $this->getDocumentPageImageWithHttpInfo($account_id, $document_id, $page_number, $template_id, $options);
        return $response;
    }

    /**
     * Operation getDocumentPageImageWithHttpInfo
     *
     * Gets a page image from a template for display.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $document_id The ID of the document being accessed.
     * @param ?string $page_number The page number being accessed.
     * @param ?string $template_id The ID of the template being accessed.
     * @param  \DocuSign\eSign\Api\TemplatesApi\GetDocumentPageImageOptions  $options for modifying the behavior of the function. (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \SplFileObject, HTTP status code, HTTP response headers (array of strings)
     */
    public function getDocumentPageImageWithHttpInfo($account_id, $document_id, $page_number, $template_id, \DocuSign\eSign\Api\TemplatesApi\GetDocumentPageImageOptions $options = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling getDocumentPageImage');
        }
        // verify the required parameter 'document_id' is set
        if ($document_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $document_id when calling getDocumentPageImage');
        }
        // verify the required parameter 'page_number' is set
        if ($page_number === null) {
            throw new \InvalidArgumentException('Missing the required parameter $page_number when calling getDocumentPageImage');
        }
        // verify the required parameter 'template_id' is set
        if ($template_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $template_id when calling getDocumentPageImage');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/templates/{templateId}/documents/{documentId}/pages/{pageNumber}/page_image";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['image/png']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);

        if ($options != null)
        {
            // query params
            if ($options->getDpi() != 'null') {
                $queryParams['dpi'] = $this->apiClient->getSerializer()->toQueryValue($options->getDpi());
            }
            if ($options->getMaxHeight() != 'null') {
                $queryParams['max_height'] = $this->apiClient->getSerializer()->toQueryValue($options->getMaxHeight());
            }
            if ($options->getMaxWidth() != 'null') {
                $queryParams['max_width'] = $this->apiClient->getSerializer()->toQueryValue($options->getMaxWidth());
            }
            if ($options->getShowChanges() != 'null') {
                $queryParams['show_changes'] = $this->apiClient->getSerializer()->toQueryValue($options->getShowChanges());
            }
        }

        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($document_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "documentId", $document_id);
        }
        // path params
        if ($page_number !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "pageNumber", $page_number);
        }
        // path params
        if ($template_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "templateId", $template_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\SplFileObject',
                '/v2.1/accounts/{accountId}/templates/{templateId}/documents/{documentId}/pages/{pageNumber}/page_image'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\SplFileObject', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\SplFileObject', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getDocumentTabs
     *
     * Returns tabs on the document.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $document_id The ID of the document being accessed.
     * @param ?string $template_id The ID of the template being accessed.
     * @param  \DocuSign\eSign\Api\TemplatesApi\GetDocumentTabsOptions  $options for modifying the behavior of the function. (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\Tabs
     */
    public function getDocumentTabs($account_id, $document_id, $template_id, \DocuSign\eSign\Api\TemplatesApi\GetDocumentTabsOptions $options = null)
    {
        list($response) = $this->getDocumentTabsWithHttpInfo($account_id, $document_id, $template_id, $options);
        return $response;
    }

    /**
     * Operation getDocumentTabsWithHttpInfo
     *
     * Returns tabs on the document.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $document_id The ID of the document being accessed.
     * @param ?string $template_id The ID of the template being accessed.
     * @param  \DocuSign\eSign\Api\TemplatesApi\GetDocumentTabsOptions  $options for modifying the behavior of the function. (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\Tabs, HTTP status code, HTTP response headers (array of strings)
     */
    public function getDocumentTabsWithHttpInfo($account_id, $document_id, $template_id, \DocuSign\eSign\Api\TemplatesApi\GetDocumentTabsOptions $options = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling getDocumentTabs');
        }
        // verify the required parameter 'document_id' is set
        if ($document_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $document_id when calling getDocumentTabs');
        }
        // verify the required parameter 'template_id' is set
        if ($template_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $template_id when calling getDocumentTabs');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/templates/{templateId}/documents/{documentId}/tabs";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);

        if ($options != null)
        {
            // query params
            if ($options->getPageNumbers() != 'null') {
                $queryParams['page_numbers'] = $this->apiClient->getSerializer()->toQueryValue($options->getPageNumbers());
            }
        }

        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($document_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "documentId", $document_id);
        }
        // path params
        if ($template_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "templateId", $template_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\Tabs',
                '/v2.1/accounts/{accountId}/templates/{templateId}/documents/{documentId}/tabs'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\Tabs', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\Tabs', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getLock
     *
     * Gets template lock information.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $template_id The ID of the template being accessed.
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\LockInformation
     */
    public function getLock($account_id, $template_id)
    {
        list($response) = $this->getLockWithHttpInfo($account_id, $template_id);
        return $response;
    }

    /**
     * Operation getLockWithHttpInfo
     *
     * Gets template lock information.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $template_id The ID of the template being accessed.
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\LockInformation, HTTP status code, HTTP response headers (array of strings)
     */
    public function getLockWithHttpInfo($account_id, $template_id): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling getLock');
        }
        // verify the required parameter 'template_id' is set
        if ($template_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $template_id when calling getLock');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/templates/{templateId}/lock";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($template_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "templateId", $template_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\LockInformation',
                '/v2.1/accounts/{accountId}/templates/{templateId}/lock'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\LockInformation', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\LockInformation', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getNotificationSettings
     *
     * Gets template notification information.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $template_id The ID of the template being accessed.
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\Notification
     */
    public function getNotificationSettings($account_id, $template_id)
    {
        list($response) = $this->getNotificationSettingsWithHttpInfo($account_id, $template_id);
        return $response;
    }

    /**
     * Operation getNotificationSettingsWithHttpInfo
     *
     * Gets template notification information.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $template_id The ID of the template being accessed.
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\Notification, HTTP status code, HTTP response headers (array of strings)
     */
    public function getNotificationSettingsWithHttpInfo($account_id, $template_id): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling getNotificationSettings');
        }
        // verify the required parameter 'template_id' is set
        if ($template_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $template_id when calling getNotificationSettings');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/templates/{templateId}/notification";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($template_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "templateId", $template_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\Notification',
                '/v2.1/accounts/{accountId}/templates/{templateId}/notification'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\Notification', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\Notification', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getPageTabs
     *
     * Returns tabs on the specified page.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $document_id The ID of the document being accessed.
     * @param ?string $page_number The page number being accessed.
     * @param ?string $template_id The ID of the template being accessed.
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\Tabs
     */
    public function getPageTabs($account_id, $document_id, $page_number, $template_id)
    {
        list($response) = $this->getPageTabsWithHttpInfo($account_id, $document_id, $page_number, $template_id);
        return $response;
    }

    /**
     * Operation getPageTabsWithHttpInfo
     *
     * Returns tabs on the specified page.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $document_id The ID of the document being accessed.
     * @param ?string $page_number The page number being accessed.
     * @param ?string $template_id The ID of the template being accessed.
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\Tabs, HTTP status code, HTTP response headers (array of strings)
     */
    public function getPageTabsWithHttpInfo($account_id, $document_id, $page_number, $template_id): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling getPageTabs');
        }
        // verify the required parameter 'document_id' is set
        if ($document_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $document_id when calling getPageTabs');
        }
        // verify the required parameter 'page_number' is set
        if ($page_number === null) {
            throw new \InvalidArgumentException('Missing the required parameter $page_number when calling getPageTabs');
        }
        // verify the required parameter 'template_id' is set
        if ($template_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $template_id when calling getPageTabs');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/templates/{templateId}/documents/{documentId}/pages/{pageNumber}/tabs";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($document_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "documentId", $document_id);
        }
        // path params
        if ($page_number !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "pageNumber", $page_number);
        }
        // path params
        if ($template_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "templateId", $template_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\Tabs',
                '/v2.1/accounts/{accountId}/templates/{templateId}/documents/{documentId}/pages/{pageNumber}/tabs'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\Tabs', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\Tabs', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getPages
     *
     * Returns document page image(s) based on input.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $document_id The ID of the document being accessed.
     * @param ?string $template_id The ID of the template being accessed.
     * @param  \DocuSign\eSign\Api\TemplatesApi\GetPagesOptions  $options for modifying the behavior of the function. (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\PageImages
     */
    public function getPages($account_id, $document_id, $template_id, \DocuSign\eSign\Api\TemplatesApi\GetPagesOptions $options = null)
    {
        list($response) = $this->getPagesWithHttpInfo($account_id, $document_id, $template_id, $options);
        return $response;
    }

    /**
     * Operation getPagesWithHttpInfo
     *
     * Returns document page image(s) based on input.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $document_id The ID of the document being accessed.
     * @param ?string $template_id The ID of the template being accessed.
     * @param  \DocuSign\eSign\Api\TemplatesApi\GetPagesOptions  $options for modifying the behavior of the function. (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\PageImages, HTTP status code, HTTP response headers (array of strings)
     */
    public function getPagesWithHttpInfo($account_id, $document_id, $template_id, \DocuSign\eSign\Api\TemplatesApi\GetPagesOptions $options = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling getPages');
        }
        // verify the required parameter 'document_id' is set
        if ($document_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $document_id when calling getPages');
        }
        // verify the required parameter 'template_id' is set
        if ($template_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $template_id when calling getPages');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/templates/{templateId}/documents/{documentId}/pages";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);

        if ($options != null)
        {
            // query params
            if ($options->getCount() != 'null') {
                $queryParams['count'] = $this->apiClient->getSerializer()->toQueryValue($options->getCount());
            }
            if ($options->getDpi() != 'null') {
                $queryParams['dpi'] = $this->apiClient->getSerializer()->toQueryValue($options->getDpi());
            }
            if ($options->getMaxHeight() != 'null') {
                $queryParams['max_height'] = $this->apiClient->getSerializer()->toQueryValue($options->getMaxHeight());
            }
            if ($options->getMaxWidth() != 'null') {
                $queryParams['max_width'] = $this->apiClient->getSerializer()->toQueryValue($options->getMaxWidth());
            }
            if ($options->getNocache() != 'null') {
                $queryParams['nocache'] = $this->apiClient->getSerializer()->toQueryValue($options->getNocache());
            }
            if ($options->getShowChanges() != 'null') {
                $queryParams['show_changes'] = $this->apiClient->getSerializer()->toQueryValue($options->getShowChanges());
            }
            if ($options->getStartPosition() != 'null') {
                $queryParams['start_position'] = $this->apiClient->getSerializer()->toQueryValue($options->getStartPosition());
            }
        }

        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($document_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "documentId", $document_id);
        }
        // path params
        if ($template_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "templateId", $template_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\PageImages',
                '/v2.1/accounts/{accountId}/templates/{templateId}/documents/{documentId}/pages'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\PageImages', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\PageImages', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getTemplateDocumentHtmlDefinitions
     *
     * Get the Original HTML Definition used to generate the Responsive HTML for a given document in a template.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $document_id The ID of the document being accessed.
     * @param ?string $template_id The ID of the template being accessed.
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\DocumentHtmlDefinitionOriginals
     */
    public function getTemplateDocumentHtmlDefinitions($account_id, $document_id, $template_id)
    {
        list($response) = $this->getTemplateDocumentHtmlDefinitionsWithHttpInfo($account_id, $document_id, $template_id);
        return $response;
    }

    /**
     * Operation getTemplateDocumentHtmlDefinitionsWithHttpInfo
     *
     * Get the Original HTML Definition used to generate the Responsive HTML for a given document in a template.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $document_id The ID of the document being accessed.
     * @param ?string $template_id The ID of the template being accessed.
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\DocumentHtmlDefinitionOriginals, HTTP status code, HTTP response headers (array of strings)
     */
    public function getTemplateDocumentHtmlDefinitionsWithHttpInfo($account_id, $document_id, $template_id): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling getTemplateDocumentHtmlDefinitions');
        }
        // verify the required parameter 'document_id' is set
        if ($document_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $document_id when calling getTemplateDocumentHtmlDefinitions');
        }
        // verify the required parameter 'template_id' is set
        if ($template_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $template_id when calling getTemplateDocumentHtmlDefinitions');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/templates/{templateId}/documents/{documentId}/html_definitions";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($document_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "documentId", $document_id);
        }
        // path params
        if ($template_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "templateId", $template_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\DocumentHtmlDefinitionOriginals',
                '/v2.1/accounts/{accountId}/templates/{templateId}/documents/{documentId}/html_definitions'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\DocumentHtmlDefinitionOriginals', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\DocumentHtmlDefinitionOriginals', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getTemplateHtmlDefinitions
     *
     * Get the Original HTML Definition used to generate the Responsive HTML for the template.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $template_id The ID of the template being accessed.
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\DocumentHtmlDefinitionOriginals
     */
    public function getTemplateHtmlDefinitions($account_id, $template_id)
    {
        list($response) = $this->getTemplateHtmlDefinitionsWithHttpInfo($account_id, $template_id);
        return $response;
    }

    /**
     * Operation getTemplateHtmlDefinitionsWithHttpInfo
     *
     * Get the Original HTML Definition used to generate the Responsive HTML for the template.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $template_id The ID of the template being accessed.
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\DocumentHtmlDefinitionOriginals, HTTP status code, HTTP response headers (array of strings)
     */
    public function getTemplateHtmlDefinitionsWithHttpInfo($account_id, $template_id): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling getTemplateHtmlDefinitions');
        }
        // verify the required parameter 'template_id' is set
        if ($template_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $template_id when calling getTemplateHtmlDefinitions');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/templates/{templateId}/html_definitions";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($template_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "templateId", $template_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\DocumentHtmlDefinitionOriginals',
                '/v2.1/accounts/{accountId}/templates/{templateId}/html_definitions'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\DocumentHtmlDefinitionOriginals', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\DocumentHtmlDefinitionOriginals', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation listCustomFields
     *
     * Gets the custom document fields from a template.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $template_id The ID of the template being accessed.
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\CustomFields
     */
    public function listCustomFields($account_id, $template_id)
    {
        list($response) = $this->listCustomFieldsWithHttpInfo($account_id, $template_id);
        return $response;
    }

    /**
     * Operation listCustomFieldsWithHttpInfo
     *
     * Gets the custom document fields from a template.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $template_id The ID of the template being accessed.
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\CustomFields, HTTP status code, HTTP response headers (array of strings)
     */
    public function listCustomFieldsWithHttpInfo($account_id, $template_id): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling listCustomFields');
        }
        // verify the required parameter 'template_id' is set
        if ($template_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $template_id when calling listCustomFields');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/templates/{templateId}/custom_fields";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($template_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "templateId", $template_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\CustomFields',
                '/v2.1/accounts/{accountId}/templates/{templateId}/custom_fields'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\CustomFields', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\CustomFields', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation listDocumentFields
     *
     * Gets the custom document fields for a an existing template document.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $document_id The ID of the document being accessed.
     * @param ?string $template_id The ID of the template being accessed.
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\DocumentFieldsInformation
     */
    public function listDocumentFields($account_id, $document_id, $template_id)
    {
        list($response) = $this->listDocumentFieldsWithHttpInfo($account_id, $document_id, $template_id);
        return $response;
    }

    /**
     * Operation listDocumentFieldsWithHttpInfo
     *
     * Gets the custom document fields for a an existing template document.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $document_id The ID of the document being accessed.
     * @param ?string $template_id The ID of the template being accessed.
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\DocumentFieldsInformation, HTTP status code, HTTP response headers (array of strings)
     */
    public function listDocumentFieldsWithHttpInfo($account_id, $document_id, $template_id): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling listDocumentFields');
        }
        // verify the required parameter 'document_id' is set
        if ($document_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $document_id when calling listDocumentFields');
        }
        // verify the required parameter 'template_id' is set
        if ($template_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $template_id when calling listDocumentFields');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/templates/{templateId}/documents/{documentId}/fields";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($document_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "documentId", $document_id);
        }
        // path params
        if ($template_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "templateId", $template_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\DocumentFieldsInformation',
                '/v2.1/accounts/{accountId}/templates/{templateId}/documents/{documentId}/fields'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\DocumentFieldsInformation', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\DocumentFieldsInformation', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation listDocuments
     *
     * Gets a list of documents associated with a template.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $template_id The ID of the template being accessed.
     * @param  \DocuSign\eSign\Api\TemplatesApi\ListDocumentsOptions  $options for modifying the behavior of the function. (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\TemplateDocumentsResult
     */
    public function listDocuments($account_id, $template_id, \DocuSign\eSign\Api\TemplatesApi\ListDocumentsOptions $options = null)
    {
        list($response) = $this->listDocumentsWithHttpInfo($account_id, $template_id, $options);
        return $response;
    }

    /**
     * Operation listDocumentsWithHttpInfo
     *
     * Gets a list of documents associated with a template.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $template_id The ID of the template being accessed.
     * @param  \DocuSign\eSign\Api\TemplatesApi\ListDocumentsOptions  $options for modifying the behavior of the function. (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\TemplateDocumentsResult, HTTP status code, HTTP response headers (array of strings)
     */
    public function listDocumentsWithHttpInfo($account_id, $template_id, \DocuSign\eSign\Api\TemplatesApi\ListDocumentsOptions $options = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling listDocuments');
        }
        // verify the required parameter 'template_id' is set
        if ($template_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $template_id when calling listDocuments');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/templates/{templateId}/documents";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);

        if ($options != null)
        {
            // query params
            if ($options->getIncludeTabs() != 'null') {
                $queryParams['include_tabs'] = $this->apiClient->getSerializer()->toQueryValue($options->getIncludeTabs());
            }
        }

        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($template_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "templateId", $template_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\TemplateDocumentsResult',
                '/v2.1/accounts/{accountId}/templates/{templateId}/documents'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\TemplateDocumentsResult', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\TemplateDocumentsResult', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation listRecipients
     *
     * Gets recipient information from a template.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $template_id The ID of the template being accessed.
     * @param  \DocuSign\eSign\Api\TemplatesApi\ListRecipientsOptions  $options for modifying the behavior of the function. (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\Recipients
     */
    public function listRecipients($account_id, $template_id, \DocuSign\eSign\Api\TemplatesApi\ListRecipientsOptions $options = null)
    {
        list($response) = $this->listRecipientsWithHttpInfo($account_id, $template_id, $options);
        return $response;
    }

    /**
     * Operation listRecipientsWithHttpInfo
     *
     * Gets recipient information from a template.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $template_id The ID of the template being accessed.
     * @param  \DocuSign\eSign\Api\TemplatesApi\ListRecipientsOptions  $options for modifying the behavior of the function. (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\Recipients, HTTP status code, HTTP response headers (array of strings)
     */
    public function listRecipientsWithHttpInfo($account_id, $template_id, \DocuSign\eSign\Api\TemplatesApi\ListRecipientsOptions $options = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling listRecipients');
        }
        // verify the required parameter 'template_id' is set
        if ($template_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $template_id when calling listRecipients');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/templates/{templateId}/recipients";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);

        if ($options != null)
        {
            // query params
            if ($options->getIncludeAnchorTabLocations() != 'null') {
                $queryParams['include_anchor_tab_locations'] = $this->apiClient->getSerializer()->toQueryValue($options->getIncludeAnchorTabLocations());
            }
            if ($options->getIncludeExtended() != 'null') {
                $queryParams['include_extended'] = $this->apiClient->getSerializer()->toQueryValue($options->getIncludeExtended());
            }
            if ($options->getIncludeTabs() != 'null') {
                $queryParams['include_tabs'] = $this->apiClient->getSerializer()->toQueryValue($options->getIncludeTabs());
            }
        }

        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($template_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "templateId", $template_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\Recipients',
                '/v2.1/accounts/{accountId}/templates/{templateId}/recipients'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\Recipients', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\Recipients', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation listTabs
     *
     * Gets the tabs information for a signer or sign-in-person recipient in a template.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $recipient_id The ID of the recipient being accessed.
     * @param ?string $template_id The ID of the template being accessed.
     * @param  \DocuSign\eSign\Api\TemplatesApi\ListTabsOptions  $options for modifying the behavior of the function. (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\Tabs
     */
    public function listTabs($account_id, $recipient_id, $template_id, \DocuSign\eSign\Api\TemplatesApi\ListTabsOptions $options = null)
    {
        list($response) = $this->listTabsWithHttpInfo($account_id, $recipient_id, $template_id, $options);
        return $response;
    }

    /**
     * Operation listTabsWithHttpInfo
     *
     * Gets the tabs information for a signer or sign-in-person recipient in a template.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $recipient_id The ID of the recipient being accessed.
     * @param ?string $template_id The ID of the template being accessed.
     * @param  \DocuSign\eSign\Api\TemplatesApi\ListTabsOptions  $options for modifying the behavior of the function. (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\Tabs, HTTP status code, HTTP response headers (array of strings)
     */
    public function listTabsWithHttpInfo($account_id, $recipient_id, $template_id, \DocuSign\eSign\Api\TemplatesApi\ListTabsOptions $options = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling listTabs');
        }
        // verify the required parameter 'recipient_id' is set
        if ($recipient_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $recipient_id when calling listTabs');
        }
        // verify the required parameter 'template_id' is set
        if ($template_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $template_id when calling listTabs');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/templates/{templateId}/recipients/{recipientId}/tabs";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);

        if ($options != null)
        {
            // query params
            if ($options->getIncludeAnchorTabLocations() != 'null') {
                $queryParams['include_anchor_tab_locations'] = $this->apiClient->getSerializer()->toQueryValue($options->getIncludeAnchorTabLocations());
            }
            if ($options->getIncludeMetadata() != 'null') {
                $queryParams['include_metadata'] = $this->apiClient->getSerializer()->toQueryValue($options->getIncludeMetadata());
            }
        }

        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($recipient_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "recipientId", $recipient_id);
        }
        // path params
        if ($template_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "templateId", $template_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\Tabs',
                '/v2.1/accounts/{accountId}/templates/{templateId}/recipients/{recipientId}/tabs'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\Tabs', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\Tabs', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation listTemplates
     *
     * Gets the definition of a template.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param  \DocuSign\eSign\Api\TemplatesApi\ListTemplatesOptions  $options for modifying the behavior of the function. (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\EnvelopeTemplateResults
     */
    public function listTemplates($account_id, \DocuSign\eSign\Api\TemplatesApi\ListTemplatesOptions $options = null)
    {
        list($response) = $this->listTemplatesWithHttpInfo($account_id, $options);
        return $response;
    }

    /**
     * Operation listTemplatesWithHttpInfo
     *
     * Gets the definition of a template.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param  \DocuSign\eSign\Api\TemplatesApi\ListTemplatesOptions  $options for modifying the behavior of the function. (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\EnvelopeTemplateResults, HTTP status code, HTTP response headers (array of strings)
     */
    public function listTemplatesWithHttpInfo($account_id, \DocuSign\eSign\Api\TemplatesApi\ListTemplatesOptions $options = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling listTemplates');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/templates";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);

        if ($options != null)
        {
            // query params
            if ($options->getCount() != 'null') {
                $queryParams['count'] = $this->apiClient->getSerializer()->toQueryValue($options->getCount());
            }
            if ($options->getCreatedFromDate() != 'null') {
                $queryParams['created_from_date'] = $this->apiClient->getSerializer()->toQueryValue($options->getCreatedFromDate());
            }
            if ($options->getCreatedToDate() != 'null') {
                $queryParams['created_to_date'] = $this->apiClient->getSerializer()->toQueryValue($options->getCreatedToDate());
            }
            if ($options->getFolderIds() != 'null') {
                $queryParams['folder_ids'] = $this->apiClient->getSerializer()->toQueryValue($options->getFolderIds());
            }
            if ($options->getFolderTypes() != 'null') {
                $queryParams['folder_types'] = $this->apiClient->getSerializer()->toQueryValue($options->getFolderTypes());
            }
            if ($options->getFromDate() != 'null') {
                $queryParams['from_date'] = $this->apiClient->getSerializer()->toQueryValue($options->getFromDate());
            }
            if ($options->getInclude() != 'null') {
                $queryParams['include'] = $this->apiClient->getSerializer()->toQueryValue($options->getInclude());
            }
            if ($options->getIsDeletedTemplateOnly() != 'null') {
                $queryParams['is_deleted_template_only'] = $this->apiClient->getSerializer()->toQueryValue($options->getIsDeletedTemplateOnly());
            }
            if ($options->getIsDownload() != 'null') {
                $queryParams['is_download'] = $this->apiClient->getSerializer()->toQueryValue($options->getIsDownload());
            }
            if ($options->getModifiedFromDate() != 'null') {
                $queryParams['modified_from_date'] = $this->apiClient->getSerializer()->toQueryValue($options->getModifiedFromDate());
            }
            if ($options->getModifiedToDate() != 'null') {
                $queryParams['modified_to_date'] = $this->apiClient->getSerializer()->toQueryValue($options->getModifiedToDate());
            }
            if ($options->getOrder() != 'null') {
                $queryParams['order'] = $this->apiClient->getSerializer()->toQueryValue($options->getOrder());
            }
            if ($options->getOrderBy() != 'null') {
                $queryParams['order_by'] = $this->apiClient->getSerializer()->toQueryValue($options->getOrderBy());
            }
            if ($options->getSearchFields() != 'null') {
                $queryParams['search_fields'] = $this->apiClient->getSerializer()->toQueryValue($options->getSearchFields());
            }
            if ($options->getSearchText() != 'null') {
                $queryParams['search_text'] = $this->apiClient->getSerializer()->toQueryValue($options->getSearchText());
            }
            if ($options->getSharedByMe() != 'null') {
                $queryParams['shared_by_me'] = $this->apiClient->getSerializer()->toQueryValue($options->getSharedByMe());
            }
            if ($options->getStartPosition() != 'null') {
                $queryParams['start_position'] = $this->apiClient->getSerializer()->toQueryValue($options->getStartPosition());
            }
            if ($options->getTemplateIds() != 'null') {
                $queryParams['template_ids'] = $this->apiClient->getSerializer()->toQueryValue($options->getTemplateIds());
            }
            if ($options->getToDate() != 'null') {
                $queryParams['to_date'] = $this->apiClient->getSerializer()->toQueryValue($options->getToDate());
            }
            if ($options->getUsedFromDate() != 'null') {
                $queryParams['used_from_date'] = $this->apiClient->getSerializer()->toQueryValue($options->getUsedFromDate());
            }
            if ($options->getUsedToDate() != 'null') {
                $queryParams['used_to_date'] = $this->apiClient->getSerializer()->toQueryValue($options->getUsedToDate());
            }
            if ($options->getUserFilter() != 'null') {
                $queryParams['user_filter'] = $this->apiClient->getSerializer()->toQueryValue($options->getUserFilter());
            }
            if ($options->getUserId() != 'null') {
                $queryParams['user_id'] = $this->apiClient->getSerializer()->toQueryValue($options->getUserId());
            }
        }

        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\EnvelopeTemplateResults',
                '/v2.1/accounts/{accountId}/templates'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\EnvelopeTemplateResults', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\EnvelopeTemplateResults', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation rotateDocumentPage
     *
     * Rotates page image from a template for display.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $document_id The ID of the document being accessed.
     * @param ?string $page_number The page number being accessed.
     * @param ?string $template_id The ID of the template being accessed.
     * @param \DocuSign\eSign\Model\PageRequest $page_request  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return mixed
     */
    public function rotateDocumentPage($account_id, $document_id, $page_number, $template_id, $page_request = null)
    {
        list($response) = $this->rotateDocumentPageWithHttpInfo($account_id, $document_id, $page_number, $template_id, $page_request);
        return $response;
    }

    /**
     * Operation rotateDocumentPageWithHttpInfo
     *
     * Rotates page image from a template for display.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $document_id The ID of the document being accessed.
     * @param ?string $page_number The page number being accessed.
     * @param ?string $template_id The ID of the template being accessed.
     * @param \DocuSign\eSign\Model\PageRequest $page_request  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function rotateDocumentPageWithHttpInfo($account_id, $document_id, $page_number, $template_id, $page_request = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling rotateDocumentPage');
        }
        // verify the required parameter 'document_id' is set
        if ($document_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $document_id when calling rotateDocumentPage');
        }
        // verify the required parameter 'page_number' is set
        if ($page_number === null) {
            throw new \InvalidArgumentException('Missing the required parameter $page_number when calling rotateDocumentPage');
        }
        // verify the required parameter 'template_id' is set
        if ($template_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $template_id when calling rotateDocumentPage');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/templates/{templateId}/documents/{documentId}/pages/{pageNumber}/page_image";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($document_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "documentId", $document_id);
        }
        // path params
        if ($page_number !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "pageNumber", $page_number);
        }
        // path params
        if ($template_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "templateId", $template_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        // body params
        $_tempBody = null;
        if (isset($page_request)) {
            $_tempBody = $page_request;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PUT',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/v2.1/accounts/{accountId}/templates/{templateId}/documents/{documentId}/pages/{pageNumber}/page_image'
            );

            return [null, $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation update
     *
     * Updates an existing template.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $template_id The ID of the template being accessed.
     * @param \DocuSign\eSign\Model\EnvelopeTemplate $envelope_template  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\TemplateUpdateSummary
     */
    public function update($account_id, $template_id, $envelope_template = null)
    {
        list($response) = $this->updateWithHttpInfo($account_id, $template_id, $envelope_template);
        return $response;
    }

    /**
     * Operation updateWithHttpInfo
     *
     * Updates an existing template.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $template_id The ID of the template being accessed.
     * @param \DocuSign\eSign\Model\EnvelopeTemplate $envelope_template  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\TemplateUpdateSummary, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateWithHttpInfo($account_id, $template_id, $envelope_template = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling update');
        }
        // verify the required parameter 'template_id' is set
        if ($template_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $template_id when calling update');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/templates/{templateId}";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($template_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "templateId", $template_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        // body params
        $_tempBody = null;
        if (isset($envelope_template)) {
            $_tempBody = $envelope_template;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PUT',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\TemplateUpdateSummary',
                '/v2.1/accounts/{accountId}/templates/{templateId}'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\TemplateUpdateSummary', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\TemplateUpdateSummary', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation updateCustomFields
     *
     * Updates envelope custom fields in a template.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $template_id The ID of the template being accessed.
     * @param \DocuSign\eSign\Model\TemplateCustomFields $template_custom_fields  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\CustomFields
     */
    public function updateCustomFields($account_id, $template_id, $template_custom_fields = null)
    {
        list($response) = $this->updateCustomFieldsWithHttpInfo($account_id, $template_id, $template_custom_fields);
        return $response;
    }

    /**
     * Operation updateCustomFieldsWithHttpInfo
     *
     * Updates envelope custom fields in a template.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $template_id The ID of the template being accessed.
     * @param \DocuSign\eSign\Model\TemplateCustomFields $template_custom_fields  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\CustomFields, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateCustomFieldsWithHttpInfo($account_id, $template_id, $template_custom_fields = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling updateCustomFields');
        }
        // verify the required parameter 'template_id' is set
        if ($template_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $template_id when calling updateCustomFields');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/templates/{templateId}/custom_fields";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($template_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "templateId", $template_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        // body params
        $_tempBody = null;
        if (isset($template_custom_fields)) {
            $_tempBody = $template_custom_fields;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PUT',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\CustomFields',
                '/v2.1/accounts/{accountId}/templates/{templateId}/custom_fields'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\CustomFields', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\CustomFields', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation updateDocument
     *
     * Adds a document to a template document.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $document_id The ID of the document being accessed.
     * @param ?string $template_id The ID of the template being accessed.
     * @param \DocuSign\eSign\Model\EnvelopeDefinition $envelope_definition  (optional)
     * @param  \DocuSign\eSign\Api\TemplatesApi\UpdateDocumentOptions  $options for modifying the behavior of the function. (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\EnvelopeDocument
     */
    public function updateDocument($account_id, $document_id, $template_id, $envelope_definition = null, \DocuSign\eSign\Api\TemplatesApi\UpdateDocumentOptions $options = null)
    {
        list($response) = $this->updateDocumentWithHttpInfo($account_id, $document_id, $template_id, $envelope_definition, $options);
        return $response;
    }

    /**
     * Operation updateDocumentWithHttpInfo
     *
     * Adds a document to a template document.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $document_id The ID of the document being accessed.
     * @param ?string $template_id The ID of the template being accessed.
     * @param \DocuSign\eSign\Model\EnvelopeDefinition $envelope_definition  (optional)
     * @param  \DocuSign\eSign\Api\TemplatesApi\UpdateDocumentOptions  $options for modifying the behavior of the function. (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\EnvelopeDocument, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateDocumentWithHttpInfo($account_id, $document_id, $template_id, $envelope_definition = null, \DocuSign\eSign\Api\TemplatesApi\UpdateDocumentOptions $options = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling updateDocument');
        }
        // verify the required parameter 'document_id' is set
        if ($document_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $document_id when calling updateDocument');
        }
        // verify the required parameter 'template_id' is set
        if ($template_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $template_id when calling updateDocument');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/templates/{templateId}/documents/{documentId}";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);

        if ($options != null)
        {
            // query params
            if ($options->getIsEnvelopeDefinition() != 'null') {
                $queryParams['is_envelope_definition'] = $this->apiClient->getSerializer()->toQueryValue($options->getIsEnvelopeDefinition());
            }
        }

        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($document_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "documentId", $document_id);
        }
        // path params
        if ($template_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "templateId", $template_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        // body params
        $_tempBody = null;
        if (isset($envelope_definition)) {
            $_tempBody = $envelope_definition;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PUT',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\EnvelopeDocument',
                '/v2.1/accounts/{accountId}/templates/{templateId}/documents/{documentId}'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\EnvelopeDocument', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\EnvelopeDocument', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation updateDocumentFields
     *
     * Updates existing custom document fields in an existing template document.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $document_id The ID of the document being accessed.
     * @param ?string $template_id The ID of the template being accessed.
     * @param \DocuSign\eSign\Model\DocumentFieldsInformation $document_fields_information  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\DocumentFieldsInformation
     */
    public function updateDocumentFields($account_id, $document_id, $template_id, $document_fields_information = null)
    {
        list($response) = $this->updateDocumentFieldsWithHttpInfo($account_id, $document_id, $template_id, $document_fields_information);
        return $response;
    }

    /**
     * Operation updateDocumentFieldsWithHttpInfo
     *
     * Updates existing custom document fields in an existing template document.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $document_id The ID of the document being accessed.
     * @param ?string $template_id The ID of the template being accessed.
     * @param \DocuSign\eSign\Model\DocumentFieldsInformation $document_fields_information  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\DocumentFieldsInformation, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateDocumentFieldsWithHttpInfo($account_id, $document_id, $template_id, $document_fields_information = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling updateDocumentFields');
        }
        // verify the required parameter 'document_id' is set
        if ($document_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $document_id when calling updateDocumentFields');
        }
        // verify the required parameter 'template_id' is set
        if ($template_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $template_id when calling updateDocumentFields');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/templates/{templateId}/documents/{documentId}/fields";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($document_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "documentId", $document_id);
        }
        // path params
        if ($template_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "templateId", $template_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        // body params
        $_tempBody = null;
        if (isset($document_fields_information)) {
            $_tempBody = $document_fields_information;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PUT',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\DocumentFieldsInformation',
                '/v2.1/accounts/{accountId}/templates/{templateId}/documents/{documentId}/fields'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\DocumentFieldsInformation', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\DocumentFieldsInformation', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation updateDocuments
     *
     * Adds documents to a template document.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $template_id The ID of the template being accessed.
     * @param \DocuSign\eSign\Model\EnvelopeDefinition $envelope_definition  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\TemplateDocumentsResult
     */
    public function updateDocuments($account_id, $template_id, $envelope_definition = null)
    {
        list($response) = $this->updateDocumentsWithHttpInfo($account_id, $template_id, $envelope_definition);
        return $response;
    }

    /**
     * Operation updateDocumentsWithHttpInfo
     *
     * Adds documents to a template document.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $template_id The ID of the template being accessed.
     * @param \DocuSign\eSign\Model\EnvelopeDefinition $envelope_definition  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\TemplateDocumentsResult, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateDocumentsWithHttpInfo($account_id, $template_id, $envelope_definition = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling updateDocuments');
        }
        // verify the required parameter 'template_id' is set
        if ($template_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $template_id when calling updateDocuments');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/templates/{templateId}/documents";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($template_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "templateId", $template_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        // body params
        $_tempBody = null;
        if (isset($envelope_definition)) {
            $_tempBody = $envelope_definition;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PUT',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\TemplateDocumentsResult',
                '/v2.1/accounts/{accountId}/templates/{templateId}/documents'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\TemplateDocumentsResult', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\TemplateDocumentsResult', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation updateGroupShare
     *
     * Shares a template with a group
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $template_id The ID of the template being accessed.
     * @param ?string $template_part Currently, the only defined part is **groups**.
     * @param \DocuSign\eSign\Model\GroupInformation $group_information  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\GroupInformation
     */
    public function updateGroupShare($account_id, $template_id, $template_part, $group_information = null)
    {
        list($response) = $this->updateGroupShareWithHttpInfo($account_id, $template_id, $template_part, $group_information);
        return $response;
    }

    /**
     * Operation updateGroupShareWithHttpInfo
     *
     * Shares a template with a group
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $template_id The ID of the template being accessed.
     * @param ?string $template_part Currently, the only defined part is **groups**.
     * @param \DocuSign\eSign\Model\GroupInformation $group_information  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\GroupInformation, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateGroupShareWithHttpInfo($account_id, $template_id, $template_part, $group_information = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling updateGroupShare');
        }
        // verify the required parameter 'template_id' is set
        if ($template_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $template_id when calling updateGroupShare');
        }
        // verify the required parameter 'template_part' is set
        if ($template_part === null) {
            throw new \InvalidArgumentException('Missing the required parameter $template_part when calling updateGroupShare');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/templates/{templateId}/{templatePart}";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($template_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "templateId", $template_id);
        }
        // path params
        if ($template_part !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "templatePart", $template_part);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        // body params
        $_tempBody = null;
        if (isset($group_information)) {
            $_tempBody = $group_information;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PUT',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\GroupInformation',
                '/v2.1/accounts/{accountId}/templates/{templateId}/{templatePart}'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\GroupInformation', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\GroupInformation', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation updateLock
     *
     * Updates a template lock.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $template_id The ID of the template being accessed.
     * @param \DocuSign\eSign\Model\LockRequest $lock_request  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\LockInformation
     */
    public function updateLock($account_id, $template_id, $lock_request = null)
    {
        list($response) = $this->updateLockWithHttpInfo($account_id, $template_id, $lock_request);
        return $response;
    }

    /**
     * Operation updateLockWithHttpInfo
     *
     * Updates a template lock.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $template_id The ID of the template being accessed.
     * @param \DocuSign\eSign\Model\LockRequest $lock_request  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\LockInformation, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateLockWithHttpInfo($account_id, $template_id, $lock_request = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling updateLock');
        }
        // verify the required parameter 'template_id' is set
        if ($template_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $template_id when calling updateLock');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/templates/{templateId}/lock";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($template_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "templateId", $template_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        // body params
        $_tempBody = null;
        if (isset($lock_request)) {
            $_tempBody = $lock_request;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PUT',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\LockInformation',
                '/v2.1/accounts/{accountId}/templates/{templateId}/lock'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\LockInformation', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\LockInformation', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation updateNotificationSettings
     *
     * Updates the notification  structure for an existing template.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $template_id The ID of the template being accessed.
     * @param \DocuSign\eSign\Model\TemplateNotificationRequest $template_notification_request  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\Notification
     */
    public function updateNotificationSettings($account_id, $template_id, $template_notification_request = null)
    {
        list($response) = $this->updateNotificationSettingsWithHttpInfo($account_id, $template_id, $template_notification_request);
        return $response;
    }

    /**
     * Operation updateNotificationSettingsWithHttpInfo
     *
     * Updates the notification  structure for an existing template.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $template_id The ID of the template being accessed.
     * @param \DocuSign\eSign\Model\TemplateNotificationRequest $template_notification_request  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\Notification, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateNotificationSettingsWithHttpInfo($account_id, $template_id, $template_notification_request = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling updateNotificationSettings');
        }
        // verify the required parameter 'template_id' is set
        if ($template_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $template_id when calling updateNotificationSettings');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/templates/{templateId}/notification";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($template_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "templateId", $template_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        // body params
        $_tempBody = null;
        if (isset($template_notification_request)) {
            $_tempBody = $template_notification_request;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PUT',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\Notification',
                '/v2.1/accounts/{accountId}/templates/{templateId}/notification'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\Notification', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\Notification', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation updateRecipients
     *
     * Updates recipients in a template.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $template_id The ID of the template being accessed.
     * @param \DocuSign\eSign\Model\TemplateRecipients $template_recipients  (optional)
     * @param  \DocuSign\eSign\Api\TemplatesApi\UpdateRecipientsOptions  $options for modifying the behavior of the function. (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\RecipientsUpdateSummary
     */
    public function updateRecipients($account_id, $template_id, $template_recipients = null, \DocuSign\eSign\Api\TemplatesApi\UpdateRecipientsOptions $options = null)
    {
        list($response) = $this->updateRecipientsWithHttpInfo($account_id, $template_id, $template_recipients, $options);
        return $response;
    }

    /**
     * Operation updateRecipientsWithHttpInfo
     *
     * Updates recipients in a template.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $template_id The ID of the template being accessed.
     * @param \DocuSign\eSign\Model\TemplateRecipients $template_recipients  (optional)
     * @param  \DocuSign\eSign\Api\TemplatesApi\UpdateRecipientsOptions  $options for modifying the behavior of the function. (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\RecipientsUpdateSummary, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateRecipientsWithHttpInfo($account_id, $template_id, $template_recipients = null, \DocuSign\eSign\Api\TemplatesApi\UpdateRecipientsOptions $options = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling updateRecipients');
        }
        // verify the required parameter 'template_id' is set
        if ($template_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $template_id when calling updateRecipients');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/templates/{templateId}/recipients";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);

        if ($options != null)
        {
            // query params
            if ($options->getResendEnvelope() != 'null') {
                $queryParams['resend_envelope'] = $this->apiClient->getSerializer()->toQueryValue($options->getResendEnvelope());
            }
        }

        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($template_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "templateId", $template_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        // body params
        $_tempBody = null;
        if (isset($template_recipients)) {
            $_tempBody = $template_recipients;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PUT',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\RecipientsUpdateSummary',
                '/v2.1/accounts/{accountId}/templates/{templateId}/recipients'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\RecipientsUpdateSummary', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\RecipientsUpdateSummary', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation updateTabs
     *
     * Updates the tabs for a recipient.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $recipient_id The ID of the recipient being accessed.
     * @param ?string $template_id The ID of the template being accessed.
     * @param \DocuSign\eSign\Model\TemplateTabs $template_tabs  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\Tabs
     */
    public function updateTabs($account_id, $recipient_id, $template_id, $template_tabs = null)
    {
        list($response) = $this->updateTabsWithHttpInfo($account_id, $recipient_id, $template_id, $template_tabs);
        return $response;
    }

    /**
     * Operation updateTabsWithHttpInfo
     *
     * Updates the tabs for a recipient.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $recipient_id The ID of the recipient being accessed.
     * @param ?string $template_id The ID of the template being accessed.
     * @param \DocuSign\eSign\Model\TemplateTabs $template_tabs  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\Tabs, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateTabsWithHttpInfo($account_id, $recipient_id, $template_id, $template_tabs = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling updateTabs');
        }
        // verify the required parameter 'recipient_id' is set
        if ($recipient_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $recipient_id when calling updateTabs');
        }
        // verify the required parameter 'template_id' is set
        if ($template_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $template_id when calling updateTabs');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/templates/{templateId}/recipients/{recipientId}/tabs";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($recipient_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "recipientId", $recipient_id);
        }
        // path params
        if ($template_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "templateId", $template_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        // body params
        $_tempBody = null;
        if (isset($template_tabs)) {
            $_tempBody = $template_tabs;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PUT',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\Tabs',
                '/v2.1/accounts/{accountId}/templates/{templateId}/recipients/{recipientId}/tabs'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\Tabs', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\Tabs', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation updateTemplateDocumentTabs
     *
     * Updates the tabs for a template
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $document_id The ID of the document being accessed.
     * @param ?string $template_id The ID of the template being accessed.
     * @param \DocuSign\eSign\Model\TemplateTabs $template_tabs  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\Tabs
     */
    public function updateTemplateDocumentTabs($account_id, $document_id, $template_id, $template_tabs = null)
    {
        list($response) = $this->updateTemplateDocumentTabsWithHttpInfo($account_id, $document_id, $template_id, $template_tabs);
        return $response;
    }

    /**
     * Operation updateTemplateDocumentTabsWithHttpInfo
     *
     * Updates the tabs for a template
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $document_id The ID of the document being accessed.
     * @param ?string $template_id The ID of the template being accessed.
     * @param \DocuSign\eSign\Model\TemplateTabs $template_tabs  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\Tabs, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateTemplateDocumentTabsWithHttpInfo($account_id, $document_id, $template_id, $template_tabs = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling updateTemplateDocumentTabs');
        }
        // verify the required parameter 'document_id' is set
        if ($document_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $document_id when calling updateTemplateDocumentTabs');
        }
        // verify the required parameter 'template_id' is set
        if ($template_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $template_id when calling updateTemplateDocumentTabs');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/templates/{templateId}/documents/{documentId}/tabs";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($document_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "documentId", $document_id);
        }
        // path params
        if ($template_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "templateId", $template_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        // body params
        $_tempBody = null;
        if (isset($template_tabs)) {
            $_tempBody = $template_tabs;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PUT',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\Tabs',
                '/v2.1/accounts/{accountId}/templates/{templateId}/documents/{documentId}/tabs'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\Tabs', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\Tabs', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }
}
