<?php 

function checkEmailDeliverability($email) {
    list($user, $domain) = explode('@', $email);
    if (checkdnsrr($domain, 'MX')) {
        $mxhosts = [];
        getmxrr($domain, $mxhosts);
        $connect = fsockopen($mxhosts[0], 25);
        if ($connect) {
            if (preg_match('/^220/', $response = fgets($connect, 1024))) {
                fputs($connect, "HELO $domain\r\n");
                $out = fgets($connect, 1024);
                fputs($connect, "MAIL FROM: <test@$domain>\r\n");
                $from = fgets($connect, 1024);
                fputs($connect, "RCPT TO: <$email>\r\n");
                $to = fgets($connect, 1024);
                fputs($connect, "QUIT\r\n");
                fclose($connect);
                if (!preg_match('/^250/', $from) || !preg_match('/^250/', $to)) {
                    return false; // Server responded negatively
                }
                return true; // Positive response, email is likely deliverable
            }
        }
    }
    return false; // DNS record not found or connection failed
}

$email = "er.rafun@gmail.com";
if (checkEmailDeliverability($email)) {
    echo "The email address can receive emails.";
} else {
    echo "The email address may not receive emails.";
}


